// Gorazd Generator
// Generator of dictionary entries from ALTO XML.
// Copyright (C) 2018  Vít Tuček, Slovanský ústav AV ČR, v. v. i.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

grammar SJSRecord2;
// simplified version of SJSDictionary that parses only one record
slovnik: (heslo | odkazove_heslo);
text_hesla: (slovo | ',' | ';' | '-')+?;
nerozpoznano: .+?;

// ODKAZOVE HESLO
odkazove_heslo: BIGSKIP? odkazova_hlavicka nerozpoznano?;
odkazova_hlavicka: zahlavi text_hesla? 'v.' text_hesla? odkaz* text_hesla? nerozpoznano?;
odkaz: RU_SLOVO+;

// HESLO
heslo: BIGSKIP? hlavicka vyskyt odstavec+ exh? confer* text_hesla? nerozpoznano?;

wtf: hlavicka vyskyt?;

hlavicka: zahlavi slovni_druhy? nerozpoznano?
        | zahlavi nasobne_zahlavi slovni_druhy? nerozpoznano?
        ;

zahlavi: RU_SLOVO gramaticke_zarazeni*;
nasobne_zahlavi: ( RU_SLOVO | ',')+ gramaticke_zarazeni+
               | (RU_SLOVO ',' gramaticke_zarazeni)+
               ;
gramaticke_zarazeni: ','? '-' RU_SLOVO;
slovni_druhy: slovni_druh (slovni_druh | ',' )* text_hesla?;
slovni_druh: SLOVNI_DRUH;

vyskyt: TAB ('occurrit in' | 'occurrit') (pamatka | text_hesla)*; // TAB je nepovinny, protoze ho obcas sezere slovni_druh
pamatka: LA_SLOVO; // TODO viceslovne pamatky a podobne lahudky + overovani oproti seznamu --> v postprocesu

//odstavec: indikator_odstavce moderni_jazyky?  stare_jazyky?  (':'|';') text_odstavce? confer?;
odstavec: indikator_odstavce moderni_jazyky ':' text_odstavce? confer? ';'?
        | indikator_odstavce moderni_jazyky ';' stare_jazyky text_odstavce? confer? ';'?
        ;
indikator_odstavce: (TAB | '\u2666' | '\u26ab' | '\u25cf' | '\u2014' | '-' ) poznamka_indikator?;  // puntik u25CF = ●, hrebik u2666 = ♦, dlouha pomlka u2014 = —
poznamka_indikator: ((RU_SLOVO| LA_SLOVO)+? ':'?);
//text_odstavce: (slovo | ',' | ':' | ';' | TAB | '-')+; // TAB se muze vyskytovat v Nota: a nektere odstavce neobsahuji preklady a tudiz je zahrnujeme do textu
text_odstavce: (slovo | ',' | ':' | ';')+; //

moderni_jazyky: cestina ';' rustina ';' nemcina;
cestina: la_preklad (',' la_preklad)*;
rustina: ru_preklad (',' ru_preklad)*;
nemcina: la_preklad (',' la_preklad)*;

//stare_jazyky: '-' '-'? poznamka_stare_jazyky? rectina ';' latina (';' staronemcina)?
//            | '-'? '-'? latina rectina?// pravidlo 3.f
//            ;
stare_jazyky: '\u2014' poznamka_stare_jazyky? rectina ';' latina (';' staronemcina)?
            | latina rectina?// pravidlo 3.f
            ;
poznamka_stare_jazyky: (RU_SLOVO | LA_SLOVO)+ ':'? ; // TODO overit

rectina: el_preklad (',' el_preklad)*;
latina: latina_predloha;
latina_predloha: la_preklad (',' la_preklad)*;
staronemcina: la_preklad (',' la_preklad)*;


// slova v prekladech obcas konci pomlkou
ru_preklad: (slovo | '-')+;
la_preklad: (slovo | '-')+;
el_preklad: slovo+;

slovo: RU_SLOVO | EL_SLOVO | LA_SLOVO;

exh: ('\u2014' | TAB) 'Exh.' ;
confer: TAB ('Cf.' | 'CL' ) (confer_odkaz | ',')+ // samostatny confer
      | '\u2014' 'cf.' (confer_odkaz | ',')+ // odstavcovy confer
      ;
confer_odkaz: slovo (slovo | '-')*;

//                                               LEXER RULES

// _NORMAL is actually anything other than italics
// LA_ refers to all other alphabets than RU and EL
RU_SLOVO: '{ru' '\t' ZBYTEK_SLOVA;
EL_SLOVO: '{el' '\t'  ZBYTEK_SLOVA;
LA_SLOVO: '{' JINY_JAZYK '\t' ZBYTEK_SLOVA;

// ANTLR doesn't allow negation of more than one token / character
// we  chose to list all possibilities in order to keep the resulting parse tree cleaner
fragment
JINY_JAZYK: 'cs' | 'de' | 'la' | ; // we must allow empty match

fragment
ZBYTEK_SLOVA: .*? '}';
//ZBYTEK_SLOVA: '|' FONTSIZE '|' CONTENT '|' POZICE '|' WC '|' IMG_ID '|' FONT '}';
//['LANG', 'STYLE', 'FONTSIZE', 'CONTENT', 'HPOS', 'VPOS', 'WIDTH', 'HEIGHT', 'WC', 'IMG_ID', 'FONT' ]

SLOVNI_DRUH: 'm.'
           | 'f.'
           | 'n.'
           | 'adj.'
           | 'poss.'
           | 'pron.'
           | 'num.'
           | 'ipf.'
           | 'pf.'
           | 'praep.'
           | 'conj.'
           | 'part.'
           | 'interj.'
           | 'ptc.'
//            | ('m'|'f') '\n.,\n' 'nom propr.'
           | 'nom.'
           | 'propr.'
           ;
TAB: 'TAB';
BIGSKIP: 'BIGSKIP';

WS: '\n' -> skip;

//ErrorCharacter: . ;