# -*- coding: utf-8 -*-
import setuptools, sys

setuptools.setup(
    name="gorazd_export",
    version="1",
    url="http://gorazd.org",

    author="Vít Tuček",
    author_email="vit.tucek+gorazd@gmail.com",

    description="export slovníkových hesel ze systému Invenio",
    long_description=open('README.rst').read(),

    packages=setuptools.find_packages(),
    include_package_data=True,

    install_requires=[],
    license="GNU General Public License v3",    
    entry_points = {
        'console_scripts': ['exporter=gorazd_export.exporter:main'],
    },

    classifiers=[
        'Programming Language :: Python',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
    ],
)

if 'install' in sys.argv:
    from pkg_resources import Requirement, resource_filename
    import os
    import shutil

    # retrieve the temporary path where the package has been extracted to for installation
    xsl_path_temp = resource_filename(Requirement.parse("gorazd_export"), "gorazd_export/xsl")

    XSL_PATH = os.path.join(os.path.expanduser('~'), 'export_xsl')

    # if the config directory tree doesn't exist, create it
    if not os.path.exists(XSL_PATH):
        os.makedirs(XSL_PATH)

    # copy every file from given location to the specified ``CONFIG_PATH``
    for file_name in os.listdir(xsl_path_temp):
        file_path_full = os.path.join(xsl_path_temp, file_name)
        if os.path.isfile(file_path_full):
            print("Copying file %s to %s" % (file_name, XSL_PATH))
            shutil.copy(file_path_full, XSL_PATH)
