<!-- 
 Gorazd Export
 export slovníkových hesel ze systému Invenio
 Copyright (C) 2018  Vít Tuček, Slovanský ústav AV ČR, v. v. i.

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.
 -->

 <?xml version="1.0" encoding="UTF-8"?>
<?aip_tornado idCode="DAO2XML" name="GORAZD GENERATOR TISKOVYCH VYSTUPU - cast4" lang="CZ" encoding="@@" ?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl">
	<xsl:output method="xml" indent="yes" omit-xml-declaration="yes" encoding="UTF-8"/>
	<!-- print.html -->
	<xsl:variable name="root_tag" select="''"/>
	<xsl:variable name="rec_tag" select="''"/>
	<xsl:template match="text()"/>
	<xsl:template match="collection">
		<!-- Hlavička HTML -->
		<xsl:text disable-output-escaping="yes"><![CDATA[<!DOCTYPE html>
<html>
<head>
<title>Gorazd export Generátor tiskových výstupů</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
</head>
<body>
]]></xsl:text>
		<xsl:for-each select="div">
			<xsl:element name="div">
				<!-- Zkopíruj atribut do elementu -->
				<xsl:copy-of select="@*"/>
				<xsl:for-each select="p">
					<xsl:element name="p">
						<!-- Zkopíruj atribut do elementu -->
						<xsl:copy-of select="@*"/>
						<!-- SPAN -->
						<xsl:for-each select="*">
							<xsl:choose>
								<!-- 1. - znaky - před slovem -->
								<xsl:when test="(./following-sibling::*[1]=',' or ./following-sibling::*[1]='.' or ./following-sibling::*[1]=':' or ./following-sibling::*[1]=';' or ./following-sibling::*[1]='!' or ./following-sibling::*[1]='?' or ./following-sibling::*[1]='×') and (.=',' or .='.' or .=':' or .=';' or .='!' or .='?' or .='×' or .='*' or .='(' or .='[' or .='{' or .='+' or .=')' or .=']' or .='}')">
									<xsl:element name="span">
										<!-- Zkopíruj atribut do elementu -->
										<xsl:copy-of select="@*"/>
										<!-- Hodnota znaku,který se k němu připojí -->
										<xsl:value-of select="./following-sibling::*[1]"/>
									</xsl:element>
								</xsl:when>
								<!-- 1. - znaky - ošetření -->
								<xsl:when test="(./following-sibling::*[1]=',' or ./following-sibling::*[1]='.' or ./following-sibling::*[1]=':' or ./following-sibling::*[1]=';' or ./following-sibling::*[1]='!' or ./following-sibling::*[1]='?' or ./following-sibling::*[1]='×') and not(.=',' or .='.' or .=':' or .=';' or .='!' or .='?' or .='×' or .='*' or .='(' or .='[' or .='{' or .='+' or .=')' or .=']' or .='}')">
									<xsl:element name="span">
										<!-- Zkopíruj atribut do elementu -->
										<xsl:copy-of select="@*"/>
										<!-- Hodnota slova -->
										<!-- Pro horní nebo dolní index, jinak bez elementu -->
										<xsl:copy-of select="node()"/>
										<!-- Hodnota znaku,který se k němu připojí -->
										<xsl:value-of select="./following-sibling::*[1]"/>
									</xsl:element>
								</xsl:when>
								<!-- U těchto znaků už se nevyrábí span -->
								<xsl:when test=".=',' or .='.' or .=':' or .=';' or .='!' or .='?' or .='×'">
								</xsl:when>
								<!-- 3. - Závorky a ostatní - před slovem -->
								<xsl:when test="(./following-sibling::*[1]=')' or ./following-sibling::*[1]=']' or ./following-sibling::*[1]='}') and not(.=',' or .='.' or .=':' or .=';' or .='!' or .='?' or .='×' or .='*' or .='(' or .='[' or .='{' or .='+' or .=')' or .=']' or .='}')">
									<xsl:element name="span">
										<!-- Zkopíruj atribut do elementu -->
										<xsl:copy-of select="@*"/>
										<!-- Hodnota slova -->
										<!-- Pro horní nebo dolní index, jinak bez elementu -->
										<xsl:copy-of select="node()"/>
										<!-- Hodnota znaku,který se k němu připojí -->
										<xsl:value-of select="./following-sibling::*[1]"/>
									</xsl:element>
								</xsl:when>
								<!-- 3. - Ošetření -->
								<xsl:when test="(./following-sibling::*[1]=')' or ./following-sibling::*[1]=']' or ./following-sibling::*[1]='}') and (.=',' or .='.' or .=':' or .=';' or .='!' or .='?' or .='×' or .='*' or .='(' or .='[' or .='{' or .='+' or .=')' or .=']' or .='}')">
									<xsl:element name="span">
										<!-- Zkopíruj atribut do elementu -->
										<xsl:copy-of select="@*"/>
										<!-- Hodnota znaku,který se k němu připojí -->
										<xsl:value-of select="./following-sibling::*[1]"/>
									</xsl:element>
								</xsl:when>
								<!-- 4. - Závorky a ostatní - za slovem -->
								<xsl:when test="./preceding-sibling::*[1]='*' or ./preceding-sibling::*[1]='(' or ./preceding-sibling::*[1]='[' or ./preceding-sibling::*[1]='{' or ./preceding-sibling::*[1]='+'">
									<xsl:element name="span">
										<!-- Zkopíruj atribut do elementu -->
										<xsl:copy-of select="@*"/>
										<!-- Hodnota slova -->
										<!-- Hodnota znaku,který se k němu připojí -->
										<xsl:value-of select="./preceding-sibling::*[1]"/>
										<!-- Pro horní nebo dolní index, jinak bez elementu -->
										<xsl:copy-of select="node()"/>
									</xsl:element>
								</xsl:when>
								<!-- U těchto znaků už se nevyrábí span -->
								<xsl:when test=".='*' or .='(' or .='[' or .='{' or .='+' or .=')' or .=']' or .='}'">
								</xsl:when>
								<!-- NBSP -->
								<xsl:when test=".='$'">
									<xsl:element name="span">
										<xsl:copy-of select="@*"/>
										<xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;]]></xsl:text>
									</xsl:element>
								</xsl:when>
								<!-- Všechno ostatní se kopíruje -->
								<xsl:otherwise>
									<xsl:copy-of select="."/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
					</xsl:element>
				</xsl:for-each>
			</xsl:element>
		</xsl:for-each>
		<!-- Konec HTML -->
		<xsl:text disable-output-escaping="yes"><![CDATA[
</body>
</html>]]></xsl:text>
	</xsl:template>
</xsl:stylesheet>
