<!-- 
 Gorazd Export
 export slovníkových hesel ze systému Invenio
 Copyright (C) 2018  Vít Tuček, Slovanský ústav AV ČR, v. v. i.

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <https://www.gnu.org/licenses/>.
 -->
 
<?xml version="1.0" encoding="UTF-8"?>
<?aip_tornado idCode="DAO2XML" name="GORAZD GENERATOR TISKOVYCH VYSTUPU - cast1" lang="CZ" encoding="@@" ?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl">
	<xsl:output method="xml" indent="yes" omit-xml-declaration="yes" encoding="UTF-8"/>
	<xsl:variable name="root_tag" select="'collection'"/>
	<xsl:variable name="rec_tag" select="''"/>
	<xsl:template match="text()"/>
	<xsl:variable name="spanstyle">
		<xsl:text>height: 32px; padding-right: 2px; </xsl:text>
	</xsl:variable>
    <xsl:template match="/">
        <collection>
            <xsl:apply-templates/>
        </collection>
    </xsl:template>
	<xsl:template match="heslo">
		<xsl:variable name="slovnik">
			<xsl:choose>
				<xsl:when test="@slovnik='SJS'">
					<xsl:text>sjs</xsl:text>
				</xsl:when>
				<xsl:when test="@slovnik='RSI'">
					<xsl:text>rsi</xsl:text>
				</xsl:when>
				<xsl:when test="@slovnik='SNSP'">
					<xsl:text>snsp</xsl:text>
				</xsl:when>
				<xsl:otherwise>sjs</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- text-indent: 0.4cm;  -->
		<xsl:element name="div">
			<!-- Typ slovníku -->
			<xsl:attribute name="class"><xsl:value-of select="$slovnik"/></xsl:attribute>
			<!-- Vlasta CSS styl pro DIV -->
			<xsl:attribute name="style"><xsl:text>float: left; padding: 10px; width: 100%; text-align: justify;</xsl:text></xsl:attribute>
			<!-- Typ hesla 
			<xsl:if test="@typ">
				<xsl:attribute name="heslo"><xsl:value-of select="@typ"/></xsl:attribute>
			</xsl:if> -->
			<xsl:for-each select="*">
				<!-- bez metadat -->
				<xsl:if test="name()!='metadata'">
					<xsl:element name="p">
						<xsl:attribute name="class"><xsl:value-of select="name()"/></xsl:attribute>
						<!-- odsazení Vlasta -->
						<xsl:choose>
							<!-- Odstavec 0.4cm pro dané odstavce -->
							<xsl:when test="name()='vyskyt' or name()='odstavec' or name()='confer' or name()='exh'">
								<xsl:attribute name="style"><xsl:text>margin-top: 0; margin-bottom: 0; clear: both;</xsl:text><xsl:choose><xsl:when test="name()='odstavec' and $slovnik='rsi'"> margin-left: 0.4cm;</xsl:when><xsl:otherwise> text-indent: 0.4cm;</xsl:otherwise></xsl:choose></xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="style"><xsl:text>margin-top: 0; margin-bottom: 0;</xsl:text></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<!-- span -->
						<xsl:choose>
							<xsl:when test="$slovnik='sjs'">
								<xsl:call-template name="zpracujGXML-sjs"/>
							</xsl:when>
							<xsl:when test="$slovnik='rsi'">
								<xsl:call-template name="zpracujGXML-rsi"/>
							</xsl:when>
							<xsl:when test="$slovnik='snsp'">
								<xsl:call-template name="zpracujGXML-snsp"/>
							</xsl:when>
						</xsl:choose>
					</xsl:element>
				</xsl:if>
			</xsl:for-each>
			<!-- TO ve WORDU nefunguje-->
			<xsl:element name="p">
				<xsl:attribute name="style"><xsl:text>margin-top: 0; margin-bottom: 0;  clear: both;</xsl:text></xsl:attribute>
				<xsl:element name="span">
					<xsl:attribute name="style"><xsl:value-of select="$spanstyle"/><xsl:text> font-family: FreeSerif; font-size: 24.pt;</xsl:text></xsl:attribute>
					<xsl:text>$</xsl:text>
				</xsl:element>
			</xsl:element> 
			<!-- Náhrada je margin-bottom: 32px; u divu -->
		</xsl:element>
	</xsl:template>
	<!-- Pro každou instanci hledá String -->
	<xsl:template name="zpracujGXML-sjs">
		<xsl:for-each select="*">
			<xsl:choose>
				<!-- Nalezení Stringu -->
				<xsl:when test="name()='String'">
					<xsl:call-template name="radek-sjs"/>
				</xsl:when>
				<!-- Komentáře zde nepatří -->
				<xsl:when test="name()='komentar'">
				</xsl:when>
				<!-- Vytvoří element a přejde na další úroveň -->
				<xsl:otherwise>
					<xsl:call-template name="zpracujGXML-sjs"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<!-- Pro každý String vytvoř span s atributy -->
	<xsl:template name="radek-sjs">
		<!-- Hodnota stylu -->
		<!-- 16-06-2017 Úplně nově jako CSS -->
		<xsl:variable name="style">
			<xsl:choose>
				<xsl:when test="@CONTENT='≻' or @CONTENT='•' or @CONTENT='♦' or @CONTENT='⚫' or @CONTENT='◼' or @CONTENT='—' or @CONTENT='→'">
					<!--normal-->
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="@STYLE='bold'">
							<xsl:text>font-weight: 900;</xsl:text>
						</xsl:when>
						<xsl:when test="@STYLE='italics'">
							<xsl:text>font-style: italic;</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<!--normal-->
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- Hodnota velikosti písma -->
		<xsl:variable name="size">
			<xsl:choose>
				<xsl:when test="@CONTENT='≻' or @CONTENT='•' or @CONTENT='♦' or @CONTENT='⚫' or @CONTENT='◼' or @CONTENT='—' or @CONTENT='→'">
					<xsl:text>font-size: 10.pt;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<!-- @FONTSIZE>@aip-size -->
					<xsl:choose>
						<xsl:when test="@FONTSIZE and @FONTSIZE!=''">
							<xsl:choose>
								<xsl:when test="@FONTSIZE='normal'">
									<xsl:text>font-size: 10.pt;</xsl:text>
								</xsl:when>
								<xsl:when test="@FONTSIZE='small'">
									<xsl:text>font-size: 8.pt;</xsl:text>
								</xsl:when>
								<xsl:when test="@FONTSIZE='big'">
									<xsl:text>font-size: 16.pt;</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>font-size: 10.pt;</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="@aip-size='16'">
							<xsl:text>font-size: 8.pt;</xsl:text>
						</xsl:when>
						<xsl:when test="@aip-size='24'">
							<xsl:text>font-size: 10.pt;</xsl:text>
						</xsl:when>
						<xsl:when test="@aip-size='32'">
							<xsl:text>font-size: 16.pt;</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- Hodnota fontu -->
		<xsl:variable name="font">
			<xsl:choose>
				<xsl:when test="@CONTENT='≻' or @CONTENT='♦' or @CONTENT='⚫' or @CONTENT='◼' or @CONTENT='—' or @CONTENT='→'">
					<xsl:text>font-family: FreeSerif;</xsl:text>
				</xsl:when>
				<xsl:when test="@CONTENT='•'">
					<xsl:text>font-family: CyrillicaBulgarian10U;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="@aip-font='FreeSerif'">
							<xsl:text>font-family: FreeSerif;</xsl:text>
						</xsl:when>
						<xsl:when test="@aip-font='CyrillicaBulgarian10U'">
							<xsl:text>font-family: CyrillicaBulgarian10U;</xsl:text>
						</xsl:when>
						<xsl:when test="@aip-font='ArialNarrow'">
							<xsl:text>font-family: Arial Narrow;</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<!-- nic -->
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- Hodnota oddělovače - asi zbytečný 
		<xsl:variable name="delimiter">
			<xsl:choose>
				<xsl:when test="@CONTENT=',' or @CONTENT=';' or @CONTENT=':' or @CONTENT='–' or @CONTENT='.' or @CONTENT='-'">
				</xsl:when>
			</xsl:choose>
		</xsl:variable>-->
		<!-- Část2 -->
		<!-- Mezera PŘED 
		<xsl:choose>-->
		<!-- Hodnoty znaků 
			<xsl:when test="@CONTENT='*' or @CONTENT='(' or @CONTENT='[' or @CONTENT='{' or @CONTENT='+'">
				<xsl:element name="span">
					<xsl:attribute name="class"><xsl:text>space</xsl:text></xsl:attribute>
					<xsl:attribute name="style"><xsl:value-of select="$spanstyle"/><xsl:text>width: 10px; </xsl:text></xsl:attribute>
					<xsl:text>&#032;</xsl:text>
				</xsl:element>
			</xsl:when>
		</xsl:choose>-->
		<xsl:element name="span">
			<!-- Doplní atribut style -->
			<xsl:attribute name="style"><xsl:value-of select="$spanstyle"/><xsl:value-of select="$style"/><xsl:text> </xsl:text><xsl:value-of select="$size"/><xsl:text> </xsl:text><xsl:value-of select="$font"/><!-- Delimiter <xsl:text> </xsl:text><xsl:value-of select="$delimiter"/> --></xsl:attribute>
			<!-- Úprava podivného znaku -->
			<xsl:variable name="content">
				<xsl:call-template name="string-replace-all">
					<xsl:with-param name="text" select="@CONTENT"/>
					<xsl:with-param name="replace">≻</xsl:with-param>
					<xsl:with-param name="by">></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<!-- Vypíše hodnotu Stringu -->
			<xsl:choose>
				<xsl:when test="@aip-index='horni'">
					<xsl:element name="sup">
						<xsl:value-of select="normalize-space($content)"/>
					</xsl:element>
				</xsl:when>
				<xsl:when test="@aip-index='dolni'">
					<xsl:element name="sub">
						<xsl:value-of select="normalize-space($content)"/>
					</xsl:element>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="normalize-space($content)"/>
				</xsl:otherwise>
			</xsl:choose>
			<!-- Část2
			<xsl:choose> -->
			<!-- 1 - znaky 
				<xsl:when test="following-sibling::*[1]/@CONTENT=',' or following-sibling::*[1]/@CONTENT='.' or following-sibling::*[1]/@CONTENT=':' or following-sibling::*[1]/@CONTENT=';' or following-sibling::*[1]/@CONTENT='!' or following-sibling::*[1]/@CONTENT='?' or following-sibling::*[1]/@CONTENT='×'">
					-->
			<!-- nic
				</xsl:when> -->
			<!-- Horní a dolní indexy
				<xsl:when test="following-sibling::*[1]/@aip-index='dolni' or following-sibling::*[1]/@aip-index='horni'"> -->
			<!-- nic
				</xsl:when> -->
			<!-- 3. Závorky a ostatní
				<xsl:when test="following-sibling::*[1]/@CONTENT='*' or following-sibling::*[1]/@CONTENT='(' or following-sibling::*[1]/@CONTENT='[' or following-sibling::*[1]/@CONTENT='{' or following-sibling::*[1]/@CONTENT='+' or following-sibling::*[1]/@CONTENT=')' or following-sibling::*[1]/@CONTENT=']' or following-sibling::*[1]/@CONTENT='}'">
					 -->
			<!-- nic
				</xsl:when> -->
			<!-- Jinak mezera
				<xsl:otherwise>
					<xsl:text> </xsl:text>
				</xsl:otherwise>
			</xsl:choose> -->
		</xsl:element>
		<!-- Mezery ZA 
		<xsl:choose>-->
		<!-- Mezera za indexem 
			<xsl:when test="@aip-index and @aip-index!=''">
				<xsl:element name="span">
					<xsl:attribute name="class"><xsl:text>space</xsl:text></xsl:attribute>
					<xsl:attribute name="style"><xsl:value-of select="$spanstyle"/><xsl:text>width: 10px; </xsl:text></xsl:attribute>
					<xsl:text>&#032;</xsl:text>
				</xsl:element>
			</xsl:when>-->
		<!-- Hodnoty znaků 
			<xsl:when test="@CONTENT=',' or @CONTENT=';' or @CONTENT=':' or @CONTENT='!' or @CONTENT='.' or @CONTENT='?' or @CONTENT='¹' or @CONTENT='²' or @CONTENT='³' or @CONTENT='×' or @CONTENT='}' or @CONTENT=']' or @CONTENT=')' or @CONTENT='...' or @CONTENT='..'">
				<xsl:element name="span">
					<xsl:attribute name="class"><xsl:text>space</xsl:text></xsl:attribute>
					<xsl:attribute name="style"><xsl:value-of select="$spanstyle"/><xsl:text>width: 10px; </xsl:text></xsl:attribute>
					<xsl:text>&#032;</xsl:text>
				</xsl:element>
			</xsl:when>
		</xsl:choose>-->
	</xsl:template>
	<!-- Pro každou instanci hledá String -->
	<xsl:template name="zpracujGXML-rsi">
		<xsl:for-each select="*">
			<xsl:choose>
				<!-- Nalezení Stringu -->
				<xsl:when test="name()='String'">
					<xsl:call-template name="radek-rsi"/>
				</xsl:when>
				<!-- Komentáře zde nepatří -->
				<xsl:when test="name()='komentar'">
				</xsl:when>
				<!-- Vytvoří element a přejde na další úroveň -->
				<xsl:otherwise>
					<xsl:call-template name="zpracujGXML-rsi"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<!-- Pro každý String vytvoř span s atributy -->
	<xsl:template name="radek-rsi">
		<!-- Hodnota stylu -->
		<xsl:variable name="style">
			<xsl:choose>
				<xsl:when test="@CONTENT='≻' or @CONTENT='•' or @CONTENT='♦' or @CONTENT='⚫' or @CONTENT='◼' or @CONTENT='—' or @CONTENT='→'">
					<!--normal-->
				</xsl:when>
				<xsl:when test="@nepresne">
					<xsl:text>font-weight: 900;</xsl:text>
				</xsl:when>
				<xsl:when test="(@CONTENT='num nota' or @CONTENT='propr') and (name(..)='slovni_druh' or name(../..)='slovni_druh')">
					<xsl:text>font-style: italic;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="@STYLE='bold'">
							<xsl:text>font-weight: 900;</xsl:text>
						</xsl:when>
						<xsl:when test="@STYLE='italics'">
							<xsl:text>font-style: italic;</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<!--normal-->
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- Hodnota velikosti písma -->
		<xsl:variable name="size">
			<xsl:choose>
				<xsl:when test="@CONTENT='≻' or @CONTENT='•' or @CONTENT='♦' or @CONTENT='⚫' or @CONTENT='◼' or @CONTENT='—' or @CONTENT='→'">
					<xsl:text>font-size: 10.pt;</xsl:text>
				</xsl:when>
				<xsl:when test="@nepresne">
					<xsl:text>font-size: 16.pt;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<!-- @FONTSIZE>@aip-size -->
					<xsl:choose>
						<xsl:when test="@FONTSIZE and @FONTSIZE!=''">
							<xsl:choose>
								<xsl:when test="@FONTSIZE='normal'">
									<xsl:text>font-size: 10.pt;</xsl:text>
								</xsl:when>
								<xsl:when test="@FONTSIZE='small'">
									<xsl:text>font-size: 8.pt;</xsl:text>
								</xsl:when>
								<xsl:when test="@FONTSIZE='big'">
									<xsl:text>font-size: 16.pt;</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>font-size: 10.pt;</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="@aip-size='16'">
							<xsl:text>font-size: 8.pt;</xsl:text>
						</xsl:when>
						<xsl:when test="@aip-size='24'">
							<xsl:text>font-size: 10.pt;</xsl:text>
						</xsl:when>
						<xsl:when test="@aip-size='32'">
							<xsl:text>font-size: 16.pt;</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- Hodnota fontu -->
		<xsl:variable name="font">
			<xsl:choose>
				<xsl:when test="@CONTENT='≻' or @CONTENT='♦' or @CONTENT='⚫' or @CONTENT='◼' or @CONTENT='—' or @CONTENT='→'">
					<xsl:text>font-family: FreeSerif;</xsl:text>
				</xsl:when>
				<xsl:when test="@CONTENT='•'">
					<xsl:text>font-family: CyrillicaBulgarian10U;</xsl:text>
				</xsl:when>
				<xsl:when test="@nepresne">
					<xsl:text>font-family: CyrillicaBulgarian10U;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<!-- @aip-font>@FONT -->
					<xsl:choose>
						<xsl:when test="@aip-font and @aip-font!=''">
							<xsl:choose>
								<xsl:when test="@aip-font='FreeSerif'">
									<xsl:text>font-family: FreeSerif;</xsl:text>
								</xsl:when>
								<xsl:when test="@aip-font='CyrillicaBulgarian10U'">
									<xsl:text>font-family: CyrillicaBulgarian10U;</xsl:text>
								</xsl:when>
								<xsl:when test="@aip-font='ArialNarrow'">
									<xsl:text>font-family: Arial Narrow;</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<!-- nic -->
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="@FONT and @FONT!=''">
							<xsl:choose>
								<xsl:when test="@FONT='FreeSerif'">
									<xsl:text>font-family: FreeSerif;</xsl:text>
								</xsl:when>
								<xsl:when test="@FONT='CyrillicaBulgarian10U'">
									<xsl:text>font-family: CyrillicaBulgarian10U;</xsl:text>
								</xsl:when>
								<xsl:when test="@FONT='ArialNarrow'">
									<xsl:text>font-family: Arial Narrow;</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<!-- nic -->
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- Hodnota oddělovače - asi zbytečný 
		<xsl:variable name="delimiter">
			<xsl:choose>
				<xsl:when test="@CONTENT=',' or @CONTENT=';' or @CONTENT=':' or @CONTENT='–' or @CONTENT='.' or @CONTENT='-'">
				</xsl:when>
			</xsl:choose>
		</xsl:variable>-->
		<!-- 
Část2
Mezera PŘED
		<xsl:choose> -->
		<!-- Hodnoty znaků
			<xsl:when test="@CONTENT='*' or @CONTENT='(' or @CONTENT='[' or @CONTENT='{' or @CONTENT='+'">
				<xsl:element name="span">
					<xsl:attribute name="class"><xsl:text>space</xsl:text></xsl:attribute>
					<xsl:attribute name="style"><xsl:value-of select="$spanstyle"/><xsl:text>width: 10px; </xsl:text></xsl:attribute>
					<xsl:text>&#032;</xsl:text>
				</xsl:element>
			</xsl:when>
		</xsl:choose> -->
		<xsl:element name="span">
			<!--<xsl:if test="$style and $style!=''">-->
			<xsl:attribute name="style"><xsl:value-of select="$spanstyle"/><xsl:value-of select="$style"/><xsl:text> </xsl:text><xsl:value-of select="$size"/><xsl:text> </xsl:text><xsl:value-of select="$font"/><!-- Delimiter <xsl:text> </xsl:text><xsl:value-of select="$delimiter"/> --></xsl:attribute>
			<!--</xsl:if>-->
			<!-- SSL_ZAHLAVI NEP - Začátek -->
			<xsl:if test="@nepresne">
				<xsl:text>[</xsl:text>
			</xsl:if>
			<!-- Úprava podivného znaku -->
			<xsl:variable name="content">
				<xsl:call-template name="string-replace-all">
					<xsl:with-param name="text" select="@CONTENT"/>
					<xsl:with-param name="replace">≻</xsl:with-param>
					<xsl:with-param name="by">></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<!-- Vypíše hodnotu Stringu -->
			<xsl:choose>
				<xsl:when test="@aip-index='horni'">
					<xsl:element name="sup">
						<xsl:value-of select="normalize-space($content)"/>
					</xsl:element>
				</xsl:when>
				<xsl:when test="@aip-index='dolni'">
					<xsl:element name="sub">
						<xsl:value-of select="normalize-space($content)"/>
					</xsl:element>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="normalize-space($content)"/>
				</xsl:otherwise>
			</xsl:choose>
			<!-- SSL_ZAHLAVI NEP - Konec -->
			<xsl:if test="@nepresne">
				<xsl:text>]</xsl:text>
			</xsl:if>
			<!-- Část2
Mezery - jsou POUZE na stejné úrovni stringu
			<xsl:choose> -->
			<!-- 1 - znaky
				<xsl:when test="following-sibling::*[1]/@CONTENT=',' or following-sibling::*[1]/@CONTENT='.' or following-sibling::*[1]/@CONTENT=':' or following-sibling::*[1]/@CONTENT=';' or following-sibling::*[1]/@CONTENT='!' or following-sibling::*[1]/@CONTENT='?' or following-sibling::*[1]/@CONTENT='×'">
					 -->
			<!-- nic
				</xsl:when> -->
			<!-- Horní a dolní indexy
				<xsl:when test="following-sibling::*[1]/@aip-index='dolni' or following-sibling::*[1]/@aip-index='horni'"> -->
			<!-- nic
				</xsl:when> -->
			<!-- 3. Závorky a ostatní
				<xsl:when test="following-sibling::*[1]/@CONTENT='*' or following-sibling::*[1]/@CONTENT='(' or following-sibling::*[1]/@CONTENT='[' or following-sibling::*[1]/@CONTENT='{' or following-sibling::*[1]/@CONTENT='+' or following-sibling::*[1]/@CONTENT=')' or following-sibling::*[1]/@CONTENT=']' or following-sibling::*[1]/@CONTENT='}'">
					 -->
			<!-- nic 
				</xsl:when>-->
			<!-- Jinak mezera
				<xsl:otherwise>
					<xsl:text> </xsl:text>
				</xsl:otherwise>
			</xsl:choose> -->
			<!-- Mezery ZA 
			<xsl:choose>-->
			<!-- Mezera za indexem
				<xsl:when test="@aip-index and @aip-index!=''">
					<xsl:element name="span">
						<xsl:attribute name="class"><xsl:text>space</xsl:text></xsl:attribute>
						<xsl:attribute name="style"><xsl:value-of select="$spanstyle"/><xsl:text>width: 10px; </xsl:text></xsl:attribute>
						<xsl:text>&#032;</xsl:text>
					</xsl:element>
				</xsl:when> -->
			<!-- Hodnoty znaků
				<xsl:when test="@CONTENT=',' or @CONTENT=';' or @CONTENT=':' or @CONTENT='!' or @CONTENT='.' or @CONTENT='?' or @CONTENT='¹' or @CONTENT='²' or @CONTENT='³' or @CONTENT='×' or @CONTENT='}' or @CONTENT=']' or @CONTENT=')' or @CONTENT='...' or @CONTENT='..'">
					<xsl:element name="span">
						<xsl:attribute name="class"><xsl:text>space</xsl:text></xsl:attribute>
						<xsl:attribute name="style"><xsl:value-of select="$spanstyle"/><xsl:text>width: 10px; </xsl:text></xsl:attribute>
						<xsl:text>&#032;</xsl:text>
					</xsl:element>
				</xsl:when>
			</xsl:choose> -->
		</xsl:element>
	</xsl:template>
	<!-- Pro každou instanci hledá String -->
	<xsl:template name="zpracujGXML-snsp">
		<xsl:for-each select="*">
			<xsl:choose>
				<!-- Nalezení Stringu -->
				<xsl:when test="name()='String'">
					<xsl:call-template name="radek-snsp"/>
				</xsl:when>
				<!-- Komentáře zde nepatří -->
				<xsl:when test="name()='komentar'">
				</xsl:when>
				<!-- Vytvoří element a přejde na další úroveň -->
				<xsl:otherwise>
					<xsl:call-template name="zpracujGXML-snsp"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<!-- Pro každý String vytvoř span s atributy -->
	<xsl:template name="radek-snsp">
		<!-- Hodnota stylu -->
		<!-- 16-06-2017 Úplně nově jako CSS -->
		<xsl:variable name="style">
			<xsl:choose>
				<xsl:when test="@CONTENT='≻' or @CONTENT='•' or @CONTENT='♦' or @CONTENT='⚫' or @CONTENT='◼' or @CONTENT='—' or @CONTENT='→'">
					<!--normal-->
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="@STYLE='bold'">
							<xsl:text>font-weight: 900;</xsl:text>
						</xsl:when>
						<xsl:when test="@STYLE='italics'">
							<xsl:text>font-style: italic;</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<!--normal-->
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- Hodnota velikosti písma -->
		<xsl:variable name="size">
			<xsl:choose>
				<xsl:when test="@CONTENT='≻' or @CONTENT='•' or @CONTENT='♦' or @CONTENT='⚫' or @CONTENT='◼' or @CONTENT='—' or @CONTENT='→'">
					<xsl:text>font-size: 10.pt;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<!-- @FONTSIZE>@aip-size -->
					<xsl:choose>
						<xsl:when test="@FONTSIZE and @FONTSIZE!=''">
							<xsl:choose>
								<xsl:when test="@FONTSIZE='normal'">
									<xsl:text>font-size: 10.pt;</xsl:text>
								</xsl:when>
								<xsl:when test="@FONTSIZE='small'">
									<xsl:text>font-size: 8.pt;</xsl:text>
								</xsl:when>
								<xsl:when test="@FONTSIZE='big'">
									<xsl:text>font-size: 16.pt;</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>font-size: 10.pt;</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="@aip-size='16'">
							<xsl:text>font-size: 8.pt;</xsl:text>
						</xsl:when>
						<xsl:when test="@aip-size='24'">
							<xsl:text>font-size: 10.pt;</xsl:text>
						</xsl:when>
						<xsl:when test="@aip-size='32'">
							<xsl:text>font-size: 16.pt;</xsl:text>
						</xsl:when>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- Hodnota fontu -->
		<xsl:variable name="font">
			<xsl:choose>
				<xsl:when test="@CONTENT='≻' or @CONTENT='♦' or @CONTENT='⚫' or @CONTENT='◼' or @CONTENT='—' or @CONTENT='→'">
					<xsl:text>font-family: FreeSerif;</xsl:text>
				</xsl:when>
				<xsl:when test="@CONTENT='•'">
					<xsl:text>font-family: CyrillicaBulgarian10U;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="@aip-font='FreeSerif'">
							<xsl:text>font-family: FreeSerif;</xsl:text>
						</xsl:when>
						<xsl:when test="@aip-font='CyrillicaBulgarian10U'">
							<xsl:text>font-family: CyrillicaBulgarian10U;</xsl:text>
						</xsl:when>
						<xsl:when test="@aip-font='ArialNarrow'">
							<xsl:text>font-family: Arial Narrow;</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<!-- nic -->
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- Hodnota oddělovače - asi zbytečný 
		<xsl:variable name="delimiter">
			<xsl:choose>
				<xsl:when test="@CONTENT=',' or @CONTENT=';' or @CONTENT=':' or @CONTENT='–' or @CONTENT='.' or @CONTENT='-'">
				</xsl:when>
			</xsl:choose>
		</xsl:variable>-->
		<!-- Část2 -->
		<!-- Mezera PŘED 
		<xsl:choose>-->
		<!-- Hodnoty znaků 
			<xsl:when test="@CONTENT='*' or @CONTENT='(' or @CONTENT='[' or @CONTENT='{' or @CONTENT='+'">
				<xsl:element name="span">
					<xsl:attribute name="class"><xsl:text>space</xsl:text></xsl:attribute>
					<xsl:attribute name="style"><xsl:value-of select="$spanstyle"/><xsl:text>width: 10px; </xsl:text></xsl:attribute>
					<xsl:text>&#032;</xsl:text>
				</xsl:element>
			</xsl:when>
		</xsl:choose>-->
		<xsl:element name="span">
			<xsl:attribute name="style"><xsl:value-of select="$spanstyle"/><xsl:value-of select="$style"/><xsl:text> </xsl:text><xsl:value-of select="$size"/><xsl:text> </xsl:text><xsl:value-of select="$font"/><!-- Delimiter <xsl:text> </xsl:text><xsl:value-of select="$delimiter"/> --></xsl:attribute>
			<!-- Úprava podivného znaku -->
			<xsl:variable name="content">
				<xsl:call-template name="string-replace-all">
					<xsl:with-param name="text" select="@CONTENT"/>
					<xsl:with-param name="replace">≻</xsl:with-param>
					<xsl:with-param name="by">></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<!-- Vypíše hodnotu Stringu -->
			<xsl:choose>
				<xsl:when test="@aip-index='horni'">
					<xsl:element name="sup">
						<xsl:value-of select="normalize-space($content)"/>
					</xsl:element>
				</xsl:when>
				<xsl:when test="@aip-index='dolni'">
					<xsl:element name="sub">
						<xsl:value-of select="normalize-space($content)"/>
					</xsl:element>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="normalize-space($content)"/>
				</xsl:otherwise>
			</xsl:choose>
			<!-- Část2
			<xsl:choose> -->
			<!-- 1 - znaky 
				<xsl:when test="following-sibling::*[1]/@CONTENT=',' or following-sibling::*[1]/@CONTENT='.' or following-sibling::*[1]/@CONTENT=':' or following-sibling::*[1]/@CONTENT=';' or following-sibling::*[1]/@CONTENT='!' or following-sibling::*[1]/@CONTENT='?' or following-sibling::*[1]/@CONTENT='×'">
					-->
			<!-- nic
				</xsl:when> -->
			<!-- Horní a dolní indexy
				<xsl:when test="following-sibling::*[1]/@aip-index='dolni' or following-sibling::*[1]/@aip-index='horni'"> -->
			<!-- nic
				</xsl:when> -->
			<!-- 3. Závorky a ostatní
				<xsl:when test="following-sibling::*[1]/@CONTENT='*' or following-sibling::*[1]/@CONTENT='(' or following-sibling::*[1]/@CONTENT='[' or following-sibling::*[1]/@CONTENT='{' or following-sibling::*[1]/@CONTENT='+' or following-sibling::*[1]/@CONTENT=')' or following-sibling::*[1]/@CONTENT=']' or following-sibling::*[1]/@CONTENT='}'">
					 -->
			<!-- nic
				</xsl:when> -->
			<!-- Jinak mezera
				<xsl:otherwise>
					<xsl:text> </xsl:text>
				</xsl:otherwise>
			</xsl:choose> -->
		</xsl:element>
		<!-- Mezery ZA 
		<xsl:choose>-->
		<!-- Mezera za indexem 
			<xsl:when test="@aip-index and @aip-index!=''">
				<xsl:element name="span">
					<xsl:attribute name="class"><xsl:text>space</xsl:text></xsl:attribute>
					<xsl:attribute name="style"><xsl:value-of select="$spanstyle"/><xsl:text>width: 10px; </xsl:text></xsl:attribute>
					<xsl:text>&#032;</xsl:text>
				</xsl:element>
			</xsl:when>-->
		<!-- Hodnoty znaků 
			<xsl:when test="@CONTENT=',' or @CONTENT=';' or @CONTENT=':' or @CONTENT='!' or @CONTENT='.' or @CONTENT='?' or @CONTENT='¹' or @CONTENT='²' or @CONTENT='³' or @CONTENT='×' or @CONTENT='}' or @CONTENT=']' or @CONTENT=')' or @CONTENT='...' or @CONTENT='..'">
				<xsl:element name="span">
					<xsl:attribute name="class"><xsl:text>space</xsl:text></xsl:attribute>
					<xsl:attribute name="style"><xsl:value-of select="$spanstyle"/><xsl:text>width: 10px; </xsl:text></xsl:attribute>
					<xsl:text>&#032;</xsl:text>
				</xsl:element>
			</xsl:when>
		</xsl:choose>-->
	</xsl:template>
	<!-- Šablona pro nahrazení znaků -->
	<xsl:template name="string-replace-all">
		<xsl:param name="text"/>
		<xsl:param name="replace"/>
		<xsl:param name="by"/>
		<xsl:choose>
			<xsl:when test="contains($text, $replace)">
				<xsl:value-of select="substring-before($text,$replace)"/>
				<xsl:value-of select="$by"/>
				<xsl:call-template name="string-replace-all">
					<xsl:with-param name="text" select="substring-after($text,$replace)"/>
					<xsl:with-param name="replace" select="$replace"/>
					<xsl:with-param name="by" select="$by"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
