<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl" xmlns:alto="http://www.loc.gov/standards/alto/ns-v3#">
	<xsl:output indent="yes" method="html" omit-xml-declaration="yes"/>
	<xsl:template match="text()"/>
	<xsl:template match="/">
	<xsl:element name="meta"> <!-- Neměl jsem tam dávat HTML tagy -->
	<xsl:attribute name="http-equiv">content-type</xsl:attribute>
	<xsl:attribute name="content">text/html</xsl:attribute>
<xsl:attribute name="charset">UTF-8</xsl:attribute>
</xsl:element><!-- Styly přímo definované v HTML --> <!--
	<xsl:element name="style"> 
<xsl:text>
body {font-family: Arial;}
h2   {font-family: Arial;}
div.TAB   {display: inline-block;}
div.global    {padding: 1px;
border: 1px solid gray;}
div.odsazene    {padding-top: 10px;
padding-left: 20px;
padding-right: 10px;
padding-bottom: 10px;
border: 1px solid gray;}</xsl:text>
</xsl:element> -->
<xsl:for-each select="//heslo">
		<xsl:element name="div">
			<xsl:attribute name="class">global</xsl:attribute>
			<xsl:for-each select="*">
			<xsl:call-template name="proceselement"/>
			</xsl:for-each>
		</xsl:element>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="proceselement">
	<xsl:choose>
				<xsl:when test="name(.)='String'">
				<xsl:call-template name="string"/>
</xsl:when>
<xsl:when test="name(.)='TAB'">
				<xsl:call-template name="tab"/>
</xsl:when>
<xsl:when test="ancestor::metadata">
</xsl:when>
<xsl:when test="name(.)='BIGSKIP'">
</xsl:when>
<xsl:when test="name(.)='metadata'">
</xsl:when>
<xsl:otherwise>
<xsl:variable name="nazev">
				<xsl:call-template name="uprava"> <!-- Tohle přejmenuje element -->
					<xsl:with-param name="text" select="name(.)"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="name(.) !=  name(preceding-sibling::*[position()=1])"> <!-- Nepovolí výskyt více stejných elementů za sebou -->
			<xsl:if test="name(.) !=  'text_hesla'"><!-- Odstraní String text_hesla -->
			<xsl:element name="h2">
					<xsl:value-of select="$nazev"/>
				</xsl:element>
			</xsl:if>
			</xsl:if>	
		<xsl:element name="div">
			<xsl:attribute name="class">odsazene</xsl:attribute>
			<xsl:for-each select="*">
<xsl:call-template name="proceselement"/>
</xsl:for-each>
		</xsl:element>
</xsl:otherwise>
			</xsl:choose>
</xsl:template>
	<xsl:template name="string">
	<xsl:choose>
		<xsl:when test="name(..)='text_hesla' and string-length(@CONTENT)=1 and count(..//@CONTENT)=1"></xsl:when> <!-- Podmínka pro samostatné znaky v elementu -->
	<xsl:otherwise>
		<xsl:element name="span">
			<xsl:value-of select="@CONTENT"/> <!-- Vypíše atribut CONTENT -->
			<xsl:text> </xsl:text>
		</xsl:element></xsl:otherwise></xsl:choose>
	</xsl:template>
	<xsl:template name="tab">
		<xsl:element name="br"> </xsl:element>
		<xsl:element name="span"> <!-- Přejde na další řádku a udělá block -->
			<xsl:attribute name="class">TAB</xsl:attribute>
		</xsl:element>
	</xsl:template>
	<xsl:template name="uprava">
		<xsl:param name="text"/>
		<xsl:choose>
			<xsl:when test="$text = 'hlavicka'">
				<xsl:text>Hlavička</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'vyskyt'">
				<xsl:text>Výskyt</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'zahlavi'">
				<xsl:text>Záhlaví</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'pamatka'">
				<xsl:text>Památka</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'slovni_druh'">
				<xsl:text>Slovní druh</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'moderni_jazyky'">
				<xsl:text>Moderní jazyky</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'stare_jazyky'">
				<xsl:text>Staré jazyky</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'cestina'">
				<xsl:text>Čeština</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'nemcina'">
				<xsl:text>Němčina</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'rustina'">
				<xsl:text>Ruština</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'rectina'">
				<xsl:text>Řečtina</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'odstavec'">
				<xsl:text>Odstavec</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'confer'">
				<xsl:text>Confer</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'exh'">
				<xsl:text>Exh</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'anglictina'">
				<xsl:text>Angličtina</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'latina'">
				<xsl:text>Latina</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'gramaticke_zarazeni'">
				<xsl:text>Gramatické zařazení</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'staronemcina'">
				<xsl:text>Staroněmčina</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'slovni_druh'">
				<xsl:text>Slovní druh</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'odkaz'">
				<xsl:text>Odkaz</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'nasobne_zahlavi'">
				<xsl:text>Násobné záhlaví</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'latina_predloha'">
				<xsl:text>Latina předloha</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'latina_preklad'">
				<xsl:text>Latina překlad</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
