<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl" xmlns:alto="http://www.loc.gov/standards/alto/ns-v3#">
	<xsl:output indent="yes" method="html" omit-xml-declaration="yes"/>
	<xsl:template match="text()"/>
	<xsl:template match="/">
		<xsl:element name="div">
			<xsl:attribute name="class">global</xsl:attribute>
			<xsl:element name="h2">Preview metadat hesla (gXML - strukturované).</xsl:element>
			<xsl:element name="p">V přípravě.</xsl:element>
		</xsl:element>
	</xsl:template>
<!--
	<xsl:template match="heslo">
	FUNGUJE 1
	</xsl:template>
	<xsl:template match="node()[name(.)!='String' and name(.)!='TAB' and name(.)!='BIGSKIP' and name(.)!='metadata' and not(ancestor::metadata)]">
	FUNGUJE 2
	</xsl:template>
	<xsl:template match="*[name(.)!='String' and name(.)!='TAB' and name(.)!='BIGSKIP' and name(.)!='metadata' and not(ancestor::metadata)]">
	FUNGUJE 3
	</xsl:template>
	<xsl:template match="//*[name(.)!='String' and name(.)!='TAB' and name(.)!='BIGSKIP' and name(.)!='metadata' and not(ancestor::metadata)]">
	FUNGUJE 4
	</xsl:template>
-->
	<xsl:template match="//*[name(.)!='String' and name(.)!='TAB' and name(.)!='BIGSKIP' and name(.)!='metadata' and not(ancestor::metadata)]">
<!--
	<xsl:template match="*[name(.)!='String' and name(.)!='TAB' and name(.)!='BIGSKIP' and name(.)!='metadata' and name(.)!='heslo' and not(ancestor::metadata) and //String/@CONTENT!=';']">
-->
		<!-- Nepovolit mu jiné elementy -->
		<xsl:variable name="nazev">
			<xsl:call-template name="uprava">
				<!-- Tohle přejmenuje element -->
				<xsl:with-param name="text" select="name(.)"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:if test="name(.) !=  name(preceding-sibling::*[position()=1])">
			<!-- Nepovolí výskyt více stejných elementů za sebou -->
			<xsl:if test="name(.) !=  'text_hesla'">
				<!-- Odstraní String text_hesla -->
				<xsl:element name="h2">
					<xsl:value-of select="$nazev"/>
				</xsl:element>
			</xsl:if>
		</xsl:if>
		<xsl:element name="div">
			<xsl:attribute name="class">odsazene</xsl:attribute>
			<xsl:apply-templates select="*"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="//String">
		<xsl:choose>
			<xsl:when test="name(..)='text_hesla' and string-length(@CONTENT)=1 and count(..//@CONTENT)=1"/>
			<!-- Podmínka pro samostatné znaky v elementu -->
			<xsl:otherwise>
				<xsl:element name="span">
					<xsl:value-of select="@CONTENT"/>
					<!-- Vypíše atribut CONTENT -->
					<xsl:text> </xsl:text>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="//TAB">
		<xsl:element name="br"> </xsl:element>
		<xsl:element name="span">
			<!-- Přejde na další řádku a udělá block -->
			<xsl:attribute name="class">TAB</xsl:attribute>
		</xsl:element>
	</xsl:template>
	<xsl:template name="uprava">
		<xsl:param name="text"/>
		<xsl:choose>
			<xsl:when test="$text = 'hlavicka'">
				<xsl:text>Hlavička</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'vyskyt'">
				<xsl:text>Výskyt</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'zahlavi'">
				<xsl:text>Záhlaví</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'pamatka'">
				<xsl:text>Památka</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'slovni_druh'">
				<xsl:text>Slovní druh</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'moderni_jazyky'">
				<xsl:text>Moderní jazyky</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'stare_jazyky'">
				<xsl:text>Staré jazyky</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'cestina'">
				<xsl:text>Čeština</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'nemcina'">
				<xsl:text>Němčina</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'rustina'">
				<xsl:text>Ruština</xsl:text>
			</xsl:when>
			<xsl:when test="$text = 'rectina'">
				<xsl:text>Řečtina</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
