<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl">
	<xsl:output indent="yes" method="xml" omit-xml-declaration="yes" encoding="utf-8"/>
	<xsl:variable name="imgPathRoot"/>
	<!-- exsl: !!!! -->
	<!--
<xsl:variable name="gXML_file_path">test</xsl:variable>
-->
	<xsl:template match="/heslo">
		<xsl:call-template name="heslo"/>
	</xsl:template>
	<xsl:template match="/slovnik/heslo">
		<xsl:call-template name="heslo"/>
	</xsl:template>
	<xsl:template name="heslo">
		<!--<xsl:for-each select="heslo">-->
		<xsl:element name="record">
			<!-- spolecne pro vsechny typy hesel -->
			<!-- spolecne pro vsechny typy hesel -->
			<!-- spolecne pro vsechny typy hesel -->
			<!-- 035 a -->
            <xsl:element name="datafield">
                <xsl:attribute name="tag">035</xsl:attribute>
                <xsl:attribute name="ind1"></xsl:attribute>
                <xsl:attribute name="ind2"></xsl:attribute>
                <xsl:element name="subfield">
                    <xsl:attribute name="code">a</xsl:attribute>
                    <xsl:value-of select="metadata/alto/@id"/> <!-- bere se prvni stranka -->
                    <xsl:text>|</xsl:text>
                    <xsl:value-of select="metadata/id_heslo/text()"/>
                </xsl:element>
            </xsl:element>
			<!-- specificke podle typu hesla -->
			<xsl:choose>
				<xsl:when test="@typ='hlavni'">
					<!-- 150 ac  // zahlavi -->
					<xsl:element name="datafield">
						<xsl:attribute name="tag">150</xsl:attribute>
						<xsl:attribute name="ind1"></xsl:attribute>
						<xsl:attribute name="ind2"></xsl:attribute>
						<xsl:element name="subfield">
							<xsl:attribute name="code">a</xsl:attribute>
							<xsl:for-each select="hlavicka/zahlavi/String/@CONTENT">
								<xsl:if test="position()>1">
									<xsl:text> </xsl:text>
								</xsl:if>
								<xsl:value-of select="."/>
							</xsl:for-each>
						</xsl:element>
						<xsl:if test="hlavicka/zahlavi/sloveso[String/@CONTENT!=0]">
							<xsl:for-each select="hlavicka/zahlavi/sloveso[String/@CONTENT!=0]">
								<xsl:element name="subfield">
									<xsl:attribute name="code">c</xsl:attribute>
									<xsl:for-each select="String/@CONTENT">
										<xsl:if test="position()>1">
											<xsl:text> </xsl:text>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</xsl:element>
							</xsl:for-each>
						</xsl:if>
						<xsl:choose>
							<xsl:when test="count(hlavicka/slovni_druh)=1">
								<xsl:element name="subfield">
									<xsl:attribute name="code">v</xsl:attribute>
									<xsl:for-each select="hlavicka/slovni_druh/String/@CONTENT">
										<xsl:if test="position()>1">
											<xsl:text> </xsl:text>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</xsl:element>
							</xsl:when>
							<xsl:when test="count(hlavicka/slovni_druh)>1">
								<xsl:if test="hlavicka/slovni_druh[not(preceding-sibling::nasobne_zahlavi)]">
									<xsl:element name="subfield">
										<xsl:attribute name="code">v</xsl:attribute>
										<xsl:for-each select="hlavicka/slovni_druh[not(preceding-sibling::nasobne_zahlavi)]/String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
								</xsl:if>
							</xsl:when>
						</xsl:choose>
					</xsl:element>
					<!-- 550 ac  // nasobne_zahlavi -->
					<xsl:for-each select="hlavicka/nasobne_zahlavi">
						<xsl:element name="datafield">
							<xsl:attribute name="tag">550</xsl:attribute>
							<xsl:attribute name="ind1"></xsl:attribute>
							<xsl:attribute name="ind2"></xsl:attribute>
							<xsl:element name="subfield">
								<xsl:attribute name="code">a</xsl:attribute>
								<xsl:for-each select="String/@CONTENT">
									<xsl:if test="position()>1">
										<xsl:text> </xsl:text>
									</xsl:if>
									<xsl:value-of select="."/>
								</xsl:for-each>
							</xsl:element>
							<xsl:if test="sloveso[String/@CONTENT!=0]">
								<xsl:for-each select="sloveso[String/@CONTENT!=0]">
									<xsl:element name="subfield">
										<xsl:attribute name="code">c</xsl:attribute>
										<xsl:for-each select="String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
								</xsl:for-each>
							</xsl:if>
						</xsl:element>
					</xsl:for-each>
					<!--  750 a // odstavec/ssl_zahlavi/ -->
					<xsl:for-each select="odstavec/ssl_zahlavi">
						<xsl:element name="datafield">
							<xsl:attribute name="tag">750</xsl:attribute>
							<xsl:attribute name="ind1"></xsl:attribute>
							<xsl:attribute name="ind2"></xsl:attribute>
							<xsl:element name="subfield">
								<xsl:attribute name="code">a</xsl:attribute>
								<xsl:for-each select="String/@CONTENT">
									<xsl:if test="position()>1">
										<xsl:text> </xsl:text>
									</xsl:if>
									<xsl:value-of select="."/>
								</xsl:for-each>
							</xsl:element>
							<xsl:element name="subfield">
								<xsl:attribute name="code">l</xsl:attribute>
								<xsl:text>staroslověnština</xsl:text>
							</xsl:element>
						</xsl:element>
					</xsl:for-each>
					<!-- 750 a // podvyznam/recke_podzahlavi/odstavec/ssl_zahlavi -->
					<xsl:for-each select="podvyznam/podzahlavi/odstavec/ssl_zahlavi">
						<xsl:element name="datafield">
							<xsl:attribute name="tag">750</xsl:attribute>
							<xsl:attribute name="ind1"></xsl:attribute>
							<xsl:attribute name="ind2"></xsl:attribute>
							<xsl:element name="subfield">
								<xsl:attribute name="code">a</xsl:attribute>
								<xsl:for-each select="String/@CONTENT">
									<xsl:if test="position()>1">
										<xsl:text> </xsl:text>
									</xsl:if>
									<xsl:value-of select="."/>
								</xsl:for-each>
							</xsl:element>
							<xsl:element name="subfield">
								<xsl:attribute name="code">l</xsl:attribute>
								<xsl:text>staroslověnština</xsl:text>
							</xsl:element>
						</xsl:element>
					</xsl:for-each>
					<!-- 750 a // odkaz -->
					<xsl:for-each select="odstavec/text_hesla/odkaz">
						<xsl:element name="datafield">
							<xsl:attribute name="tag">750</xsl:attribute>
							<xsl:attribute name="ind1"></xsl:attribute>
							<xsl:attribute name="ind2"></xsl:attribute>
							<xsl:element name="subfield">
								<xsl:attribute name="code">a</xsl:attribute>
								<xsl:for-each select="String/@CONTENT">
									<xsl:if test="position()>1">
										<xsl:text> </xsl:text>
									</xsl:if>
									<xsl:value-of select="."/>
								</xsl:for-each>
							</xsl:element>
							<xsl:element name="subfield">
								<xsl:attribute name="code">l</xsl:attribute>
								<xsl:text>řečtina</xsl:text>
							</xsl:element>
						</xsl:element>
					</xsl:for-each>
					<!-- 750 a // podvyznam/text_hesla/odkaz -->
					<xsl:for-each select="podvyznam/podzahlavi/odstavec/text_hesla/odkaz">
						<xsl:element name="datafield">
							<xsl:attribute name="tag">750</xsl:attribute>
							<xsl:attribute name="ind1"></xsl:attribute>
							<xsl:attribute name="ind2"></xsl:attribute>
							<xsl:element name="subfield">
								<xsl:attribute name="code">a</xsl:attribute>
								<xsl:for-each select="String/@CONTENT">
									<xsl:if test="position()>1">
										<xsl:text> </xsl:text>
									</xsl:if>
									<xsl:value-of select="."/>
								</xsl:for-each>
							</xsl:element>
							<xsl:element name="subfield">
								<xsl:attribute name="code">l</xsl:attribute>
								<xsl:text>řečtina</xsl:text>
							</xsl:element>
						</xsl:element>
					</xsl:for-each>
					<!-- 750 a // podvyznam/recke_podzahlavi/odkaz -->
					<xsl:for-each select="podvyznam/podzahlavi/odkaz">
						<xsl:element name="datafield">
							<xsl:attribute name="tag">750</xsl:attribute>
							<xsl:attribute name="ind1"></xsl:attribute>
							<xsl:attribute name="ind2"></xsl:attribute>
							<xsl:element name="subfield">
								<xsl:attribute name="code">a</xsl:attribute>
								<xsl:for-each select="String/@CONTENT">
									<xsl:if test="position()>1">
										<xsl:text> </xsl:text>
									</xsl:if>
									<xsl:value-of select="."/>
								</xsl:for-each>
							</xsl:element>
							<xsl:element name="subfield">
								<xsl:attribute name="code">l</xsl:attribute>
								<xsl:text>řečtina</xsl:text>
							</xsl:element>
						</xsl:element>
					</xsl:for-each>
					<!-- 750 a // podvyznam/recke_podzahlavi/odkaz -->
					<xsl:for-each select="podvyznam/podzahlavi/text_hesla/odkaz">
						<xsl:element name="datafield">
							<xsl:attribute name="tag">750</xsl:attribute>
							<xsl:attribute name="ind1"></xsl:attribute>
							<xsl:attribute name="ind2"></xsl:attribute>
							<xsl:element name="subfield">
								<xsl:attribute name="code">a</xsl:attribute>
								<xsl:for-each select="String/@CONTENT">
									<xsl:if test="position()>1">
										<xsl:text> </xsl:text>
									</xsl:if>
									<xsl:value-of select="."/>
								</xsl:for-each>
							</xsl:element>
							<xsl:element name="subfield">
								<xsl:attribute name="code">l</xsl:attribute>
								<xsl:text>řečtina</xsl:text>
							</xsl:element>
						</xsl:element>
					</xsl:for-each>
					<!-- 790 a -->
					<xsl:for-each select="podvyznam/podzahlavi">
						<xsl:element name="datafield">
							<xsl:attribute name="tag">790</xsl:attribute>
							<xsl:attribute name="ind1"></xsl:attribute>
							<xsl:attribute name="ind2"></xsl:attribute>
							<xsl:element name="subfield">
								<xsl:attribute name="code">a</xsl:attribute>
								<xsl:for-each select="String/@CONTENT">
									<xsl:if test="position()>1">
										<xsl:text> </xsl:text>
									</xsl:if>
									<xsl:value-of select="."/>
								</xsl:for-each>
							</xsl:element>
						</xsl:element>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<!-- 150 ac  // zahlavi -->
					<xsl:element name="datafield">
						<xsl:attribute name="tag">150</xsl:attribute>
						<xsl:attribute name="ind1"></xsl:attribute>
						<xsl:attribute name="ind2"></xsl:attribute>
						<xsl:element name="subfield">
							<xsl:attribute name="code">a</xsl:attribute>
							<xsl:for-each select="hlavicka/zahlavi/String/@CONTENT">
								<xsl:if test="position()>1">
									<xsl:text> </xsl:text>
								</xsl:if>
								<xsl:value-of select="."/>
							</xsl:for-each>
						</xsl:element>
					</xsl:element>
					<!-- 550 ac  // nasobne_zahlavi -->
					<xsl:for-each select="hlavicka/nasobne_zahlavi">
						<xsl:element name="datafield">
							<xsl:attribute name="tag">550</xsl:attribute>
							<xsl:attribute name="ind1"></xsl:attribute>
							<xsl:attribute name="ind2"></xsl:attribute>
							<xsl:element name="subfield">
								<xsl:attribute name="code">a</xsl:attribute>
								<xsl:for-each select="String/@CONTENT">
									<xsl:if test="position()>1">
										<xsl:text> </xsl:text>
									</xsl:if>
									<xsl:value-of select="."/>
								</xsl:for-each>
							</xsl:element>
						</xsl:element>
					</xsl:for-each>
					<!-- 750 a // odkaz -->
					<xsl:for-each select="hlavicka/odkaz">
						<xsl:element name="datafield">
							<xsl:attribute name="tag">750</xsl:attribute>
							<xsl:attribute name="ind1"></xsl:attribute>
							<xsl:attribute name="ind2"></xsl:attribute>
							<xsl:element name="subfield">
								<xsl:attribute name="code">a</xsl:attribute>
								<xsl:for-each select="String/@CONTENT">
									<xsl:if test="position()>1">
										<xsl:text> </xsl:text>
									</xsl:if>
									<xsl:value-of select="."/>
								</xsl:for-each>
							</xsl:element>
							<xsl:element name="subfield">
								<xsl:attribute name="code">l</xsl:attribute>
								<xsl:text>řečtina</xsl:text>
							</xsl:element>
						</xsl:element>
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>
			<!-- opet spolecne pro vsechny typy hesel -->
			<!-- opet spolecne pro vsechny typy hesel -->
			<!-- opet spolecne pro vsechny typy hesel -->
			<!-- 980 a // heslo@typ -->
			<xsl:element name="datafield">
				<xsl:attribute name="tag">980</xsl:attribute>
				<xsl:attribute name="ind1"></xsl:attribute>
				<xsl:attribute name="ind2"></xsl:attribute>
				<xsl:element name="subfield">
					<xsl:attribute name="code">a</xsl:attribute>
					<xsl:value-of select="@typ"/>
				</xsl:element>
				<!-- 980 b // heslo@slovnik -->
				<xsl:element name="subfield">
					<xsl:attribute name="code">b</xsl:attribute>
					<xsl:value-of select="@slovnik"/>
				</xsl:element>
			</xsl:element>
			<!-- 990 a // text() -->
			<xsl:element name="datafield">
				<xsl:attribute name="tag">990</xsl:attribute>
				<xsl:attribute name="ind1"></xsl:attribute>
				<xsl:attribute name="ind2"></xsl:attribute>
				<xsl:element name="subfield">
					<xsl:attribute name="code">a</xsl:attribute>
					<xsl:for-each select="descendant::*[@CONTENT]/@CONTENT">
						<xsl:value-of select="."/>
						<xsl:text> </xsl:text>
					</xsl:for-each>
				</xsl:element>
			</xsl:element>
			<!-- kod priynaku stavu -->
			<!-- 9XX a // priznakXY -->
			<xsl:element name="datafield">
				<xsl:attribute name="tag">950</xsl:attribute>
				<xsl:attribute name="ind1"></xsl:attribute>
				<xsl:attribute name="ind2"></xsl:attribute>
				<xsl:element name="subfield">
					<xsl:attribute name="code">s</xsl:attribute>
					<!-- predpokladam, ze priznak do pole 9XX dava pavel treba do metadata/priznakXY, tak ho proste vypisu -->
					<xsl:choose>
						<xsl:when test="string-length(metadata/status)!=0">
							<xsl:value-of select="metadata/status"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>1</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
			<xsl:element name="datafield">
				<xsl:attribute name="tag">FFT</xsl:attribute>
				<xsl:attribute name="ind1"></xsl:attribute>
				<xsl:attribute name="ind2"></xsl:attribute>
				<xsl:element name="subfield">
					<xsl:attribute name="code">a</xsl:attribute>
					<xsl:value-of select="$gXML_file_path"/>
				</xsl:element>
				<xsl:element name="subfield">
					<xsl:attribute name="code">n</xsl:attribute>
					<xsl:text>gorazdXML</xsl:text>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
