<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl">
	<xsl:output indent="yes" method="xml" omit-xml-declaration="yes" encoding="utf-8"/>
	<xsl:variable name="imgPathRoot"/>
	<!-- exsl: !!!! -->
	<!--
<xsl:variable name="gXML_file_path">test</xsl:variable>
-->
	<xsl:template match="/heslo">
		<xsl:call-template name="heslo"/>
	</xsl:template>
	<xsl:template match="/slovnik/heslo">
		<xsl:call-template name="heslo"/>
	</xsl:template>
	<xsl:template name="heslo">
		<xsl:variable name="slovnik">
			<xsl:choose>
				<xsl:when test="@slovnik='RSI'">
					<xsl:value-of select="@slovnik"/>
				</xsl:when>
				<xsl:when test="@slovnik='SJS'">
					<xsl:value-of select="@slovnik"/>
				</xsl:when>
				<xsl:when test="@slovnik='SNSP'">
					<xsl:value-of select="@slovnik"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>SJS</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="not(hlavicka/zahlavi/String/@CONTENT)">
			<xsl:message terminate="yes">Zaznam neobsahuje zahlavi, tudiz je neplatny. Jedna se o zaznam  '<xsl:value-of select="metadata/alto/@id"/>
				<xsl:text>|</xsl:text>
				<xsl:value-of select="metadata/id_heslo/text()"/>'.</xsl:message>
		</xsl:if>
		<xsl:variable name="p035">
			<!-- spolecne pro vsechny typy hesel -->
			<!-- 035 a -->
			<xsl:element name="datafield">
				<xsl:attribute name="tag">035</xsl:attribute>
				<xsl:attribute name="ind1"></xsl:attribute>
				<xsl:attribute name="ind2"></xsl:attribute>
				<xsl:element name="subfield">
					<xsl:attribute name="code">a</xsl:attribute>
					<xsl:value-of select="metadata/alto/@id"/>
					<!-- bere se prvni stranka -->
					<xsl:text>|</xsl:text>
					<xsl:value-of select="metadata/id_heslo/text()"/>
				</xsl:element>
			</xsl:element>
		</xsl:variable>
		<xsl:variable name="p980">
			<!-- opet spolecne pro vsechny typy hesel -->
			<!-- 980 a // heslo@typ -->
			<xsl:element name="datafield">
				<xsl:attribute name="tag">980</xsl:attribute>
				<xsl:attribute name="ind1"></xsl:attribute>
				<xsl:attribute name="ind2"></xsl:attribute>
				<xsl:element name="subfield">
					<xsl:attribute name="code">a</xsl:attribute>
					<xsl:value-of select="@typ"/>
				</xsl:element>
				<!-- 980 b // heslo@slovnik -->
				<xsl:element name="subfield">
					<xsl:attribute name="code">b</xsl:attribute>
					<xsl:value-of select="$slovnik"/>
				</xsl:element>
			</xsl:element>
		</xsl:variable>
		<xsl:variable name="p990">
			<!-- opet spolecne pro vsechny typy hesel -->
			<!-- 990 a // text() -->
			<xsl:element name="datafield">
				<xsl:attribute name="tag">990</xsl:attribute>
				<xsl:attribute name="ind1"></xsl:attribute>
				<xsl:attribute name="ind2"></xsl:attribute>
				<xsl:element name="subfield">
					<xsl:attribute name="code">a</xsl:attribute>
					<xsl:for-each select="descendant::*[@CONTENT]/@CONTENT">
						<xsl:value-of select="."/>
						<xsl:text> </xsl:text>
					</xsl:for-each>
				</xsl:element>
			</xsl:element>
		</xsl:variable>
		<xsl:variable name="p950">
			<!-- opet spolecne pro vsechny typy hesel -->
			<!-- kod priynaku stavu -->
			<!-- 9XX a // priznakXY -->
			<xsl:element name="datafield">
				<xsl:attribute name="tag">950</xsl:attribute>
				<xsl:attribute name="ind1"></xsl:attribute>
				<xsl:attribute name="ind2"></xsl:attribute>
				<xsl:element name="subfield">
					<xsl:attribute name="code">s</xsl:attribute>
					<!-- predpokladam, ze priznak do pole 9XX dava pavel treba do metadata/priznakXY, tak ho proste vypisu -->
					<xsl:choose>
						<xsl:when test="string-length(metadata/status)!=0">
							<xsl:value-of select="metadata/status"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>1</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
		</xsl:variable>
		<!--<xsl:for-each select="heslo">-->
		<xsl:element name="record">
			<!-- spolecne pro vsechny typy hesel -->
			<!-- spolecne pro vsechny typy hesel -->
			<!-- specificke podle typu hesla -->
			<xsl:copy-of select="$p980"/>
			<xsl:copy-of select="$p990"/>
			<xsl:copy-of select="$p035"/>
			<xsl:copy-of select="$p950"/>
			<xsl:choose>
				<xsl:when test="$slovnik='SJS'">
					<!-- 150 ab  // zahlavi -->
					<xsl:element name="datafield">
						<xsl:attribute name="tag">150</xsl:attribute>
						<xsl:attribute name="ind1"></xsl:attribute>
						<xsl:attribute name="ind2"></xsl:attribute>
						<xsl:element name="subfield">
							<xsl:attribute name="code">a</xsl:attribute>
							<xsl:for-each select="descendant::zahlavi/String/@CONTENT">
								<xsl:if test="position()>1">
									<xsl:text> </xsl:text>
								</xsl:if>
								<xsl:value-of select="."/>
							</xsl:for-each>
						</xsl:element>
						<xsl:if test="descendant::zahlavi/gramaticke_zarazeni[String/@CONTENT!=0]">
							<xsl:for-each select="descendant::zahlavi/gramaticke_zarazeni[String/@CONTENT!=0]">
								<xsl:element name="subfield">
									<xsl:attribute name="code">b</xsl:attribute>
									<xsl:for-each select="String/@CONTENT">
										<xsl:if test="position()>1">
											<xsl:text> </xsl:text>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</xsl:element>
							</xsl:for-each>
						</xsl:if>
						<xsl:choose>
							<xsl:when test="count(descendant::slovni_druh)=1">
								<xsl:element name="subfield">
									<xsl:attribute name="code">v</xsl:attribute>
									<xsl:for-each select="descendant::slovni_druh/String/@CONTENT">
										<xsl:if test="position()>1">
											<xsl:text> </xsl:text>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</xsl:element>
							</xsl:when>
							<xsl:when test="count(descendant::slovni_druh)>1">
								<xsl:if test="descendant::slovni_druh[not(preceding-sibling::nasobne_zahlavi)]">
									<xsl:element name="subfield">
										<xsl:attribute name="code">v</xsl:attribute>
										<xsl:for-each select="descendant::slovni_druh[not(preceding-sibling::nasobne_zahlavi)]/String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
								</xsl:if>
							</xsl:when>
						</xsl:choose>
					</xsl:element>
					<!-- 550 ab  // nasobne_zahlavi -->
					<xsl:for-each select="descendant::nasobne_zahlavi">
						<xsl:element name="datafield">
							<xsl:attribute name="tag">550</xsl:attribute>
							<xsl:attribute name="ind1"></xsl:attribute>
							<xsl:attribute name="ind2"></xsl:attribute>
							<xsl:element name="subfield">
								<xsl:attribute name="code">a</xsl:attribute>
								<xsl:for-each select="String/@CONTENT">
									<xsl:if test="position()>1">
										<xsl:text> </xsl:text>
									</xsl:if>
									<xsl:value-of select="."/>
								</xsl:for-each>
							</xsl:element>
							<xsl:if test="gramaticke_zarazeni[String/@CONTENT!=0]">
								<xsl:for-each select="gramaticke_zarazeni[String/@CONTENT!=0]">
									<xsl:element name="subfield">
										<xsl:attribute name="code">b</xsl:attribute>
										<xsl:for-each select="String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
								</xsl:for-each>
							</xsl:if>
							<xsl:choose>
								<xsl:when test="count(../descendant::slovni_druh)=1">
									<xsl:element name="subfield">
										<xsl:attribute name="code">v</xsl:attribute>
										<xsl:for-each select="../descendant::slovni_druh/String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
								</xsl:when>
								<xsl:when test="count(../descendant::slovni_druh)>1">
									<xsl:if test="following-sibling::slovni_druh">
										<xsl:element name="subfield">
											<xsl:attribute name="code">v</xsl:attribute>
											<xsl:for-each select="following-sibling::slovni_druh[position()=1]/String/@CONTENT">
												<xsl:if test="position()>1">
													<xsl:text> </xsl:text>
												</xsl:if>
												<xsl:value-of select="."/>
											</xsl:for-each>
										</xsl:element>
									</xsl:if>
								</xsl:when>
							</xsl:choose>
						</xsl:element>
					</xsl:for-each>
					<!-- 750 a // odkaz -->
					<xsl:for-each select="//odkaz">
						<xsl:element name="datafield">
							<xsl:attribute name="tag">750</xsl:attribute>
							<xsl:attribute name="ind1"></xsl:attribute>
							<xsl:attribute name="ind2"></xsl:attribute>
							<xsl:element name="subfield">
								<xsl:attribute name="code">a</xsl:attribute>
								<xsl:for-each select="String/@CONTENT">
									<xsl:if test="position()>1">
										<xsl:text> </xsl:text>
									</xsl:if>
									<xsl:value-of select="."/>
								</xsl:for-each>
							</xsl:element>
						</xsl:element>
					</xsl:for-each>
					<!-- 956 u  -->
					<xsl:for-each select="metadata/alto">
						<xsl:element name="datafield">
							<xsl:attribute name="tag">956</xsl:attribute>
							<xsl:attribute name="ind1"></xsl:attribute>
							<xsl:attribute name="ind2"></xsl:attribute>
							<xsl:element name="subfield">
								<xsl:attribute name="code">u</xsl:attribute>
								<xsl:text>UC/</xsl:text>
								<xsl:text>SUAVCR</xsl:text>
								<xsl:value-of select="substring(@id,1,19)"/>
								<xsl:text>/N1/</xsl:text>
								<xsl:value-of select="substring(@id,1,19)"/>
								<xsl:text>N1</xsl:text>
								<xsl:value-of select="substring(@id,22)"/>
								<xsl:text>.JPG</xsl:text>
							</xsl:element>
							<xsl:element name="subfield">
								<xsl:attribute name="code">t</xsl:attribute>
								<xsl:text>N1</xsl:text>
							</xsl:element>
						</xsl:element>
					</xsl:for-each>
					<xsl:for-each select="metadata/alto">
						<xsl:element name="datafield">
							<xsl:attribute name="tag">956</xsl:attribute>
							<xsl:attribute name="ind1"></xsl:attribute>
							<xsl:attribute name="ind2"></xsl:attribute>
							<xsl:element name="subfield">
								<xsl:attribute name="code">u</xsl:attribute>
								<xsl:text>MC/</xsl:text>
								<xsl:text>SUAVCR</xsl:text>
								<xsl:value-of select="substring(@id,1,19)"/>
								<xsl:text>/EX/</xsl:text>
								<xsl:value-of select="substring(@id,1,19)"/>
								<xsl:text>EX</xsl:text>
								<xsl:value-of select="substring(@id,22)"/>
								<xsl:text>.JPG</xsl:text>
							</xsl:element>
							<xsl:element name="subfield">
								<xsl:attribute name="code">t</xsl:attribute>
								<xsl:text>EX</xsl:text>
							</xsl:element>
						</xsl:element>
					</xsl:for-each>
				</xsl:when>
				<xsl:when test="$slovnik='RSI'">
					<xsl:choose>
						<xsl:when test="@typ='hlavni'">
							<!-- 150 ac  // zahlavi -->
							<xsl:element name="datafield">
								<xsl:attribute name="tag">150</xsl:attribute>
								<xsl:attribute name="ind1"></xsl:attribute>
								<xsl:attribute name="ind2"></xsl:attribute>
								<xsl:element name="subfield">
									<xsl:attribute name="code">a</xsl:attribute>
									<xsl:for-each select="hlavicka/zahlavi/String/@CONTENT">
										<xsl:if test="position()>1">
											<xsl:text> </xsl:text>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</xsl:element>
								<xsl:if test="hlavicka/zahlavi/sloveso[String/@CONTENT!=0]">
									<xsl:for-each select="hlavicka/zahlavi/sloveso[String/@CONTENT!=0]">
										<xsl:element name="subfield">
											<xsl:attribute name="code">c</xsl:attribute>
											<xsl:for-each select="String/@CONTENT">
												<xsl:if test="position()>1">
													<xsl:text> </xsl:text>
												</xsl:if>
												<xsl:value-of select="."/>
											</xsl:for-each>
										</xsl:element>
									</xsl:for-each>
								</xsl:if>
								<xsl:choose>
									<xsl:when test="count(hlavicka/slovni_druh)=1">
										<xsl:element name="subfield">
											<xsl:attribute name="code">v</xsl:attribute>
											<xsl:for-each select="hlavicka/slovni_druh/String/@CONTENT">
												<xsl:if test="position()>1">
													<xsl:text> </xsl:text>
												</xsl:if>
												<xsl:value-of select="."/>
											</xsl:for-each>
										</xsl:element>
									</xsl:when>
									<xsl:when test="count(hlavicka/slovni_druh)>1">
										<xsl:if test="hlavicka/slovni_druh[not(preceding-sibling::nasobne_zahlavi)]">
											<xsl:element name="subfield">
												<xsl:attribute name="code">v</xsl:attribute>
												<xsl:for-each select="hlavicka/slovni_druh[not(preceding-sibling::nasobne_zahlavi)]/String/@CONTENT">
													<xsl:if test="position()>1">
														<xsl:text> </xsl:text>
													</xsl:if>
													<xsl:value-of select="."/>
												</xsl:for-each>
											</xsl:element>
										</xsl:if>
									</xsl:when>
								</xsl:choose>
							</xsl:element>
							<!-- 550 ac  // nasobne_zahlavi -->
							<xsl:for-each select="hlavicka/nasobne_zahlavi">
								<xsl:element name="datafield">
									<xsl:attribute name="tag">550</xsl:attribute>
									<xsl:attribute name="ind1"></xsl:attribute>
									<xsl:attribute name="ind2"></xsl:attribute>
									<xsl:element name="subfield">
										<xsl:attribute name="code">a</xsl:attribute>
										<xsl:for-each select="String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
									<xsl:if test="sloveso[String/@CONTENT!=0]">
										<xsl:for-each select="sloveso[String/@CONTENT!=0]">
											<xsl:element name="subfield">
												<xsl:attribute name="code">c</xsl:attribute>
												<xsl:for-each select="String/@CONTENT">
													<xsl:if test="position()>1">
														<xsl:text> </xsl:text>
													</xsl:if>
													<xsl:value-of select="."/>
												</xsl:for-each>
											</xsl:element>
										</xsl:for-each>
									</xsl:if>
								</xsl:element>
							</xsl:for-each>
							<!--  750 a // odstavec/ssl_zahlavi/ -->
							<xsl:for-each select="odstavec/ssl_zahlavi">
								<xsl:element name="datafield">
									<xsl:attribute name="tag">750</xsl:attribute>
									<xsl:attribute name="ind1"></xsl:attribute>
									<xsl:attribute name="ind2"></xsl:attribute>
									<xsl:element name="subfield">
										<xsl:attribute name="code">a</xsl:attribute>
										<xsl:for-each select="String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
									<xsl:element name="subfield">
										<xsl:attribute name="code">l</xsl:attribute>
										<xsl:text>staroslověnština</xsl:text>
									</xsl:element>
								</xsl:element>
							</xsl:for-each>
							<!-- 750 a // podvyznam/recke_podzahlavi/odstavec/ssl_zahlavi -->
							<xsl:for-each select="podvyznam/podzahlavi/odstavec/ssl_zahlavi">
								<xsl:element name="datafield">
									<xsl:attribute name="tag">750</xsl:attribute>
									<xsl:attribute name="ind1"></xsl:attribute>
									<xsl:attribute name="ind2"></xsl:attribute>
									<xsl:element name="subfield">
										<xsl:attribute name="code">a</xsl:attribute>
										<xsl:for-each select="String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
									<xsl:element name="subfield">
										<xsl:attribute name="code">l</xsl:attribute>
										<xsl:text>staroslověnština</xsl:text>
									</xsl:element>
								</xsl:element>
							</xsl:for-each>
							<!-- 750 a // odkaz -->
							<xsl:for-each select="odstavec/text_hesla/odkaz">
								<xsl:element name="datafield">
									<xsl:attribute name="tag">750</xsl:attribute>
									<xsl:attribute name="ind1"></xsl:attribute>
									<xsl:attribute name="ind2"></xsl:attribute>
									<xsl:element name="subfield">
										<xsl:attribute name="code">a</xsl:attribute>
										<xsl:for-each select="String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
									<xsl:element name="subfield">
										<xsl:attribute name="code">l</xsl:attribute>
										<xsl:text>řečtina</xsl:text>
									</xsl:element>
								</xsl:element>
							</xsl:for-each>
							<!-- 750 a // podvyznam/text_hesla/odkaz -->
							<xsl:for-each select="podvyznam/podzahlavi/odstavec/text_hesla/odkaz">
								<xsl:element name="datafield">
									<xsl:attribute name="tag">750</xsl:attribute>
									<xsl:attribute name="ind1"></xsl:attribute>
									<xsl:attribute name="ind2"></xsl:attribute>
									<xsl:element name="subfield">
										<xsl:attribute name="code">a</xsl:attribute>
										<xsl:for-each select="String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
									<xsl:element name="subfield">
										<xsl:attribute name="code">l</xsl:attribute>
										<xsl:text>řečtina</xsl:text>
									</xsl:element>
								</xsl:element>
							</xsl:for-each>
							<!-- 750 a // podvyznam/recke_podzahlavi/odkaz -->
							<xsl:for-each select="podvyznam/podzahlavi/odkaz">
								<xsl:element name="datafield">
									<xsl:attribute name="tag">750</xsl:attribute>
									<xsl:attribute name="ind1"></xsl:attribute>
									<xsl:attribute name="ind2"></xsl:attribute>
									<xsl:element name="subfield">
										<xsl:attribute name="code">a</xsl:attribute>
										<xsl:for-each select="String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
									<xsl:element name="subfield">
										<xsl:attribute name="code">l</xsl:attribute>
										<xsl:text>řečtina</xsl:text>
									</xsl:element>
								</xsl:element>
							</xsl:for-each>
							<!-- 750 a // podvyznam/recke_podzahlavi/odkaz -->
							<xsl:for-each select="podvyznam/podzahlavi/text_hesla/odkaz">
								<xsl:element name="datafield">
									<xsl:attribute name="tag">750</xsl:attribute>
									<xsl:attribute name="ind1"></xsl:attribute>
									<xsl:attribute name="ind2"></xsl:attribute>
									<xsl:element name="subfield">
										<xsl:attribute name="code">a</xsl:attribute>
										<xsl:for-each select="String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
									<xsl:element name="subfield">
										<xsl:attribute name="code">l</xsl:attribute>
										<xsl:text>řečtina</xsl:text>
									</xsl:element>
								</xsl:element>
							</xsl:for-each>
							<!-- 790 a -->
							<xsl:for-each select="podvyznam/podzahlavi">
								<xsl:element name="datafield">
									<xsl:attribute name="tag">790</xsl:attribute>
									<xsl:attribute name="ind1"></xsl:attribute>
									<xsl:attribute name="ind2"></xsl:attribute>
									<xsl:element name="subfield">
										<xsl:attribute name="code">a</xsl:attribute>
										<xsl:for-each select="String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
								</xsl:element>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<!-- 150 ac  // zahlavi -->
							<xsl:element name="datafield">
								<xsl:attribute name="tag">150</xsl:attribute>
								<xsl:attribute name="ind1"></xsl:attribute>
								<xsl:attribute name="ind2"></xsl:attribute>
								<xsl:element name="subfield">
									<xsl:attribute name="code">a</xsl:attribute>
									<xsl:for-each select="hlavicka/zahlavi/String/@CONTENT">
										<xsl:if test="position()>1">
											<xsl:text> </xsl:text>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</xsl:element>
							</xsl:element>
							<!-- 550 ac  // nasobne_zahlavi -->
							<xsl:for-each select="hlavicka/nasobne_zahlavi">
								<xsl:element name="datafield">
									<xsl:attribute name="tag">550</xsl:attribute>
									<xsl:attribute name="ind1"></xsl:attribute>
									<xsl:attribute name="ind2"></xsl:attribute>
									<xsl:element name="subfield">
										<xsl:attribute name="code">a</xsl:attribute>
										<xsl:for-each select="String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
								</xsl:element>
							</xsl:for-each>
							<!-- 750 a // odkaz -->
							<xsl:for-each select="hlavicka/odkaz">
								<xsl:element name="datafield">
									<xsl:attribute name="tag">750</xsl:attribute>
									<xsl:attribute name="ind1"></xsl:attribute>
									<xsl:attribute name="ind2"></xsl:attribute>
									<xsl:element name="subfield">
										<xsl:attribute name="code">a</xsl:attribute>
										<xsl:for-each select="String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
									<xsl:element name="subfield">
										<xsl:attribute name="code">l</xsl:attribute>
										<xsl:text>řečtina</xsl:text>
									</xsl:element>
								</xsl:element>
							</xsl:for-each>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="$slovnik='SNSP'">
					<!-- 150 ab  // zahlavi -->
					<xsl:element name="datafield">
						<xsl:attribute name="tag">150</xsl:attribute>
						<xsl:attribute name="ind1"></xsl:attribute>
						<xsl:attribute name="ind2"></xsl:attribute>
						<xsl:element name="subfield">
							<xsl:attribute name="code">a</xsl:attribute>
							<xsl:for-each select="descendant::zahlavi/String/@CONTENT">
								<xsl:if test="position()>1">
									<xsl:text> </xsl:text>
								</xsl:if>
								<xsl:value-of select="."/>
							</xsl:for-each>
						</xsl:element>
						<xsl:if test="descendant::zahlavi/gramaticke_zarazeni[String/@CONTENT!=0]">
							<xsl:for-each select="descendant::zahlavi/gramaticke_zarazeni[String/@CONTENT!=0]">
								<xsl:element name="subfield">
									<xsl:attribute name="code">b</xsl:attribute>
									<xsl:for-each select="String/@CONTENT">
										<xsl:if test="position()>1">
											<xsl:text> </xsl:text>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</xsl:element>
							</xsl:for-each>
						</xsl:if>
						<xsl:choose>
							<xsl:when test="count(descendant::slovni_druh)=1">
								<xsl:element name="subfield">
									<xsl:attribute name="code">v</xsl:attribute>
									<xsl:for-each select="descendant::slovni_druh/String/@CONTENT">
										<xsl:if test="position()>1">
											<xsl:text> </xsl:text>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</xsl:element>
							</xsl:when>
							<xsl:when test="count(descendant::slovni_druh)>1">
								<xsl:if test="descendant::slovni_druh[not(preceding-sibling::nasobne_zahlavi)]">
									<xsl:element name="subfield">
										<xsl:attribute name="code">v</xsl:attribute>
										<xsl:for-each select="descendant::slovni_druh[not(preceding-sibling::nasobne_zahlavi)]/String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
								</xsl:if>
							</xsl:when>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test="count(descendant::gramaticke_zarazeni)=1">
								<xsl:element name="subfield">
									<xsl:attribute name="code">b</xsl:attribute>
									<xsl:for-each select="descendant::gramaticke_zarazeni/String/@CONTENT">
										<xsl:if test="position()>1">
											<xsl:text> </xsl:text>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</xsl:element>
							</xsl:when>
							<xsl:when test="count(descendant::gramaticke_zarazeni)>1">
								<xsl:if test="descendant::gramaticke_zarazeni[not(preceding-sibling::nasobne_zahlavi)]">
									<xsl:element name="subfield">
										<xsl:attribute name="code">b</xsl:attribute>
										<xsl:for-each select="descendant::gramaticke_zarazeni[not(preceding-sibling::nasobne_zahlavi)]/String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
								</xsl:if>
							</xsl:when>
						</xsl:choose>
						<xsl:choose>
							<xsl:when test="count(descendant::frekvence)=1">
								<xsl:element name="subfield">
									<xsl:attribute name="code">f</xsl:attribute>
									<xsl:for-each select="descendant::frekvence/String/@CONTENT">
										<xsl:if test="position()>1">
											<xsl:text> </xsl:text>
										</xsl:if>
										<xsl:value-of select="."/>
									</xsl:for-each>
								</xsl:element>
							</xsl:when>
							<xsl:when test="count(descendant::frekvence)>1">
								<xsl:if test="descendant::frekvence[not(preceding-sibling::nasobne_zahlavi)]">
									<xsl:element name="subfield">
										<xsl:attribute name="code">f</xsl:attribute>
										<xsl:for-each select="descendant::frekvence[not(preceding-sibling::nasobne_zahlavi)]/String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
								</xsl:if>
							</xsl:when>
						</xsl:choose>
					</xsl:element>
					<!-- 550 ab  // nasobne_zahlavi -->
					<xsl:for-each select="descendant::nasobne_zahlavi">
						<xsl:element name="datafield">
							<xsl:attribute name="tag">550</xsl:attribute>
							<xsl:attribute name="ind1"></xsl:attribute>
							<xsl:attribute name="ind2"></xsl:attribute>
							<xsl:element name="subfield">
								<xsl:attribute name="code">a</xsl:attribute>
								<xsl:for-each select="String/@CONTENT">
									<xsl:if test="position()>1">
										<xsl:text> </xsl:text>
									</xsl:if>
									<xsl:value-of select="."/>
								</xsl:for-each>
							</xsl:element>
							<xsl:if test="gramaticke_zarazeni[String/@CONTENT!=0]">
								<xsl:for-each select="gramaticke_zarazeni[String/@CONTENT!=0]">
									<xsl:element name="subfield">
										<xsl:attribute name="code">b</xsl:attribute>
										<xsl:for-each select="String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
								</xsl:for-each>
							</xsl:if>
							<xsl:choose>
								<xsl:when test="count(../descendant::slovni_druh)=1">
									<xsl:element name="subfield">
										<xsl:attribute name="code">v</xsl:attribute>
										<xsl:for-each select="../descendant::slovni_druh/String/@CONTENT">
											<xsl:if test="position()>1">
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="."/>
										</xsl:for-each>
									</xsl:element>
								</xsl:when>
								<xsl:when test="count(../descendant::slovni_druh)>1">
									<xsl:if test="following-sibling::slovni_druh">
										<xsl:element name="subfield">
											<xsl:attribute name="code">v</xsl:attribute>
											<xsl:for-each select="following-sibling::slovni_druh[position()=1]/String/@CONTENT">
												<xsl:if test="position()>1">
													<xsl:text> </xsl:text>
												</xsl:if>
												<xsl:value-of select="."/>
											</xsl:for-each>
										</xsl:element>
									</xsl:if>
								</xsl:when>
							</xsl:choose>
						</xsl:element>
					</xsl:for-each>
					<!-- 750 a // odkaz -->
					<xsl:for-each select="//odkaz">
						<xsl:element name="datafield">
							<xsl:attribute name="tag">750</xsl:attribute>
							<xsl:attribute name="ind1"></xsl:attribute>
							<xsl:attribute name="ind2"></xsl:attribute>
							<xsl:element name="subfield">
								<xsl:attribute name="code">a</xsl:attribute>
								<xsl:for-each select="String/@CONTENT">
									<xsl:if test="position()>1">
										<xsl:text> </xsl:text>
									</xsl:if>
									<xsl:value-of select="."/>
								</xsl:for-each>
							</xsl:element>
						</xsl:element>
					</xsl:for-each>
				</xsl:when>
			</xsl:choose>
			<xsl:element name="datafield">
				<xsl:attribute name="tag">FFT</xsl:attribute>
				<xsl:attribute name="ind1"></xsl:attribute>
				<xsl:attribute name="ind2"></xsl:attribute>
				<xsl:element name="subfield">
					<xsl:attribute name="code">a</xsl:attribute>
					<xsl:value-of select="$gXML_file_path"/>
				</xsl:element>
				<xsl:element name="subfield">
					<xsl:attribute name="code">n</xsl:attribute>
					<xsl:text>gorazdXML</xsl:text>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
