<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl" xmlns:alto="http://www.loc.gov/standards/alto/ns-v3#">

	<xsl:output indent="yes" method="xml" omit-xml-declaration="yes" encoding="utf-8"/>

	<xsl:template match="/slovnik">

		<xsl:for-each select="heslo">
			<xsl:call-template name="heslo"/>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="/heslo">
<!--
alternativni yacatek - dle parseru / rezimu pouziti XSL -->
		<xsl:call-template name="heslo">
			<xsl:with-param name="normHeslo">
				<xsl:element name="heslo">
					<xsl:for-each select="@*">
						<xsl:copy-of select="."/>
					</xsl:for-each>
					<xsl:for-each select="*">
						<xsl:choose>
							<xsl:when test="name()='String'">
								<xsl:element name="odstavec">
									<xsl:copy-of select="."/>
								</xsl:element>
							</xsl:when>
							<xsl:when test="name()='confer'">
								<xsl:element name="odstavec">
									<xsl:copy-of select="."/>
								</xsl:element>
							</xsl:when>
							<xsl:otherwise>
								<xsl:copy-of select="."/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</xsl:element>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="heslo-x">
		<xsl:param name="normHeslo"/>
		<xsl:copy-of select="$normHeslo/heslo"/>
	</xsl:template>

	<xsl:template name="heslo">
		<xsl:param name="normHeslo"/>
		<xsl:variable name="normHeslo2">
<!--
			<xsl:for-each select="$normHeslo/heslo">
-->
			<xsl:for-each select="exsl:node-set($normHeslo)/heslo">
				<xsl:comment>nove heslo</xsl:comment>
				<xsl:element name="div">
					<xsl:attribute name="aip-type"><xsl:value-of select="@typ"/></xsl:attribute>
					<xsl:if test="@slovnik">
					<xsl:attribute name="slovnik"><xsl:value-of select="@slovnik"/></xsl:attribute>
					</xsl:if>
					<!-- sekce obsahove elementy -->
					<xsl:call-template name="process"/>
					<!-- sekce metadat -->
					<xsl:element name="metadata">
						<xsl:for-each select="@*"><xsl:copy-of select="."></xsl:copy-of></xsl:for-each>
						<xsl:element name="pageInfo">
							<xsl:for-each select="metadata/alto">
								<xsl:element name="page">
									<xsl:copy-of select="@id"/>
									<xsl:copy-of select="alto:Layout/alto:Page/@HEIGHT"/>
									<xsl:copy-of select="alto:layout/alto:page/@height"/>
									<xsl:copy-of select="alto:Layout/alto:Page/@WIDTH"/>
									<xsl:copy-of select="alto:layout/alto:page/@width"/>
								</xsl:element>
							</xsl:for-each>
						</xsl:element>
						<!-- doplneni povinnnych spanu -->
						<xsl:if test="not(metadata/autor_slovniku)"><xsl:element name="autor_slovniku"/></xsl:if>
						<xsl:if test="not(metadata/autor_dodatku)"><xsl:element name="autor_dodatku"/></xsl:if>
						<xsl:if test="not(metadata/redaktor_hesla)"><xsl:element name="redaktor_hesla"/></xsl:if>
						<!-- kopirovani existujicich metadat -->
						<xsl:for-each select="metadata/*">
							<xsl:copy-of select="."/>
						</xsl:for-each>
					</xsl:element>
				</xsl:element>
			</xsl:for-each>
		</xsl:variable>
		<!-- jeste narovnam ID start/end bloku -->
<!--
		<xsl:for-each select="$normHeslo2/div">
-->
		<xsl:for-each select="exsl:node-set($normHeslo2)/div">
			<xsl:element name="div">
				<xsl:for-each select="@*">
					<xsl:copy-of select="."/>
				</xsl:for-each>
				<xsl:for-each select="*">
					<xsl:choose>
						<xsl:when test="name()='end'">
							<xsl:element name="end">
								<xsl:attribute name="block"><xsl:value-of select="preceding-sibling::start[position()=1]/@block"/></xsl:attribute>
							</xsl:element>
						</xsl:when>
						<xsl:otherwise>
							<xsl:copy-of select="."/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="process">
		<xsl:for-each select="*">
			<xsl:choose>
				<xsl:when test="name()='Error'"/>
				<xsl:when test="name()='metadata'"/>
				<xsl:when test="name()='NEWLINE'">
					<xsl:variable name="temp"><![CDATA[<NEWLINE></NEWLINE>]]></xsl:variable>
					<xsl:value-of select="$temp" disable-output-escaping="yes"/>
				</xsl:when>
				<xsl:when test="name()='BIGSKIP'">
					<xsl:variable name="temp"><![CDATA[<BIGSKIP></BIGSKIP>]]></xsl:variable>
					<xsl:value-of select="$temp" disable-output-escaping="yes"/>
				</xsl:when>
				<xsl:when test="name()='TAB'">
					<!-- pokud tab nekde vevnitr, pak se ma se vygenerovat blok -->
					<xsl:comment>beru tab <xsl:value-of select="count(preceding-sibling::*[name()!='BIGSKIP' and name()!='NEWLINE'])!=0"/><xsl:text> </xsl:text><xsl:value-of select="count(following-sibling::*[name()!='BIGSKIP' and name()!='NEWLINE'])!=0"/> </xsl:comment>
					<xsl:if test="count(preceding-sibling::*[name()!='BIGSKIP' and name()!='NEWLINE'])!=0 and count(following-sibling::*[name()!='BIGSKIP' and name()!='NEWLINE'])!=0">
						<xsl:comment>jdu na to</xsl:comment>
						<xsl:call-template name="add-block-mark">
							<xsl:with-param name="type">end</xsl:with-param>
							<xsl:with-param name="forceOnTAB">yes</xsl:with-param>
						</xsl:call-template>
						<xsl:call-template name="add-block-mark">
							<xsl:with-param name="type">start</xsl:with-param>
							<xsl:with-param name="forceOnTAB">yes</xsl:with-param>
						</xsl:call-template>
					</xsl:if>
					<xsl:variable name="temp"><![CDATA[<TAB></TAB>]]></xsl:variable>
					<xsl:value-of select="$temp" disable-output-escaping="yes"/>
				</xsl:when>
				<xsl:when test="name()='String'">
					<xsl:element name="span">
						<xsl:attribute name="aip-type">
							<xsl:choose>
								<xsl:when test="name(..)='la_preklad' and name(../..)='anglictina'">anglictina</xsl:when>
								<xsl:when test="name(..)='la_preklad' and name(../..)='cestina'">cestina</xsl:when>
								<xsl:when test="name(..)='ru_preklad' and name(../..)='rustina'">rustina</xsl:when>
								<xsl:when test="name(..)='la_preklad' and name(../..)='nemcina'">nemcina</xsl:when>
								<xsl:when test="name(..)='la_preklad' and name(../..)='latina_predloha'">latina_predloha</xsl:when>
								<xsl:when test="name(..)='la_preklad' and name(../..)='latina_preklad'">latina_preklad</xsl:when>
								<xsl:when test="name(..)='la_preklad' and name(../..)='stara_horni_nemcina'">stara_horni_nemcina</xsl:when>
								<xsl:when test="name(..)='el_preklad' and name(../..)='rectina'">rectina</xsl:when>
								<xsl:when test="name(..)='gramaticke_zarazeni'"><xsl:value-of select="name(..)"/></xsl:when>
								<xsl:when test="name(..)='text_hesla'"><xsl:value-of select="name(..)"/></xsl:when>
								<xsl:when test="name(..)='slovni_druh'"><xsl:value-of select="name(..)"/></xsl:when>
								<xsl:when test="name(..)='odkaz'"><xsl:value-of select="name(..)"/></xsl:when>
								<xsl:when test="name(..)='pamatka'"><xsl:value-of select="name(..)"/></xsl:when>
								<xsl:when test="name(..)='exh'"><xsl:value-of select="name(..)"/></xsl:when>
								<xsl:when test="name(..)='odstavec'">text_hesla</xsl:when>
								<xsl:when test="name(..)='zahlavi'">zahlavi</xsl:when>
								<xsl:when test="name(..)='komentar'"><xsl:value-of select="name(..)"/></xsl:when> <!-- Možná tam stačí dát <xsl:value-of select="name(..)"/> -->
								<xsl:when test="name(..)='nasobne_zahlavi'">nasobne_zahlavi</xsl:when>
								<xsl:otherwise>
									<xsl:text>text_hesla</xsl:text>
<!--
									<xsl:value-of select="name(..)"/>
-->
								</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
<!--
						<xsl:call-template name="add-parents"/>
-->
						<xsl:call-template name="add-subtypes"/>
						<xsl:attribute name="aip-editable">
							<xsl:choose>
								<xsl:when test="ancestor::vyskyt">false</xsl:when>
								<xsl:otherwise>
									<xsl:text>true</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
						<xsl:if test="string-length(@STYLE)!=0">
							<xsl:attribute name="aip-style"><xsl:value-of select="@STYLE"/></xsl:attribute>
						</xsl:if>
						<xsl:for-each select="@*">
							<xsl:choose>
								<xsl:when test="name()='FONT'">
									<xsl:attribute name="{name()}"><xsl:value-of select="translate(., ' ','')"/></xsl:attribute>
								</xsl:when>
								<xsl:when test="name()='aip-font'">
									<xsl:attribute name="{name()}"><xsl:value-of select="translate(., ' ','')"/></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:copy-of select="."/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
						<!-- dogenerovani chzbejicich povinnzch, pokud tyto chybi -->
						<xsl:if test="not(@aip-font)">
							<xsl:attribute name="aip-font"></xsl:attribute>
						</xsl:if>
						<xsl:if test="not(@aip-font)">
							<xsl:attribute name="aip-style"></xsl:attribute>
						</xsl:if>
						<xsl:if test="not(@aip-size)">
							<xsl:attribute name="aip-size"></xsl:attribute>
						</xsl:if>
						<xsl:choose>
							<xsl:when test="@CONTENT=' '"><xsl:text
        disable-output-escaping="yes">&amp;nbsp;</xsl:text></xsl:when>
							<xsl:otherwise><xsl:value-of select="@CONTENT"/></xsl:otherwise>
						</xsl:choose>
					</xsl:element>
				</xsl:when>
				<xsl:when test="name(..)='heslo'">
					<xsl:call-template name="add-block-mark">
						<xsl:with-param name="type">start</xsl:with-param>
					</xsl:call-template>
					<xsl:call-template name="process"/>
					<xsl:call-template name="add-block-mark">
						<xsl:with-param name="type">end</xsl:with-param>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="count(*)!=0">
						<xsl:call-template name="process"/>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="add-block-mark">
		<xsl:param name="type"/>
		<xsl:param name="forceOnTAB"/>
		<xsl:if test="(name()!='NEWLINE' and name()!='BIGSKIP' and name()!='TAB') or $forceOnTAB='yes'">
			<xsl:variable name="nameNum">
				<xsl:choose>
					<xsl:when test="name()='xxxxxx'"></xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="position()"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:element name="{$type}">
				<xsl:attribute name="block">
					<xsl:for-each select="ancestor-or-self::*[name()!='']">
						<xsl:if test="position()!=1">
							<xsl:text>-</xsl:text>
						</xsl:if>
<!--
						<xsl:value-of select="name()"/>
-->
						<xsl:value-of select="$nameNum"/>
						<xsl:text>-</xsl:text>
						<xsl:value-of select="count(preceding-sibling::*)"/>
					</xsl:for-each>
				</xsl:attribute>
			</xsl:element>
		</xsl:if>
	</xsl:template>

	<xsl:template name="add-subtypes">
		<xsl:choose>
			<xsl:when test="name(..)='gramaticke_zarazeni'">
				<xsl:choose>
					<xsl:when test="ancestor::*[name()='zahlavi']">
						<xsl:attribute name="aip-subtype">zahlavi</xsl:attribute>
					</xsl:when>
					<xsl:when test="ancestor::*[name()='nasobne_zahlavi']">
						<xsl:attribute name="aip-subtype">nasobne_zahlavi</xsl:attribute>
					</xsl:when>
				</xsl:choose>
			</xsl:when>
<!--
			<xsl:when test="name(..)='text_hesla' and name(../..)='text_hesla'">
				<xsl:attribute name="aip-subtype"><xsl:value-of select="name(../../..)"/></xsl:attribute>
			</xsl:when>
-->
			<xsl:when test="name(..)='text_hesla'">
				<xsl:attribute name="aip-subtype"><xsl:value-of select="name(../..)"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="name(..)='odkaz'">
				<xsl:attribute name="aip-subtype"><xsl:value-of select="name(../..)"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="name(..)='komentar'">
				<xsl:attribute name="aip-subtype"><xsl:value-of select="name(../..)"/></xsl:attribute>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="add-parents">
		<xsl:choose>
			<xsl:when test="name(..)='text_hesla' and name(../..)='text_hesla'">
				<xsl:attribute name="aip-parent"><xsl:value-of select="name(../../..)"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="name(../../..)='heslo'">
						<xsl:attribute name="aip-grand-parent">slovnik</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="aip-grand-parent"><xsl:value-of select="name(ancestor::*[name(..)='heslo'])"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="name(..)='text_hesla'">
				<xsl:attribute name="aip-parent"><xsl:value-of select="name(../..)"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="name(../..)='heslo'">
						<xsl:attribute name="aip-grand-parent">slovnik</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="aip-grand-parent"><xsl:value-of select="name(ancestor::*[name(..)='heslo'])"/></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
<!--
odkaz poznám podle kontextu kontextu ostatního
			<xsl:when test="name(..)='odkaz'">
				<xsl:attribute name="aip-parent"><xsl:value-of select="name(../..)"/></xsl:attribute>
				<xsl:attribute name="aip-grand-parent"><xsl:value-of select="name(ancestor::*[name(..)='heslo'])"/></xsl:attribute>
			</xsl:when>
-->
			<xsl:otherwise>
<!--
pro elementz s jednim mistem vzskztu to nepotrebuju
				<xsl:attribute name="aip-parent"><xsl:value-of select="name(..)"/></xsl:attribute>
-->
			</xsl:otherwise>
		</xsl:choose>
<!--
		<xsl:attribute name="aip-parent"><xsl:value-of select="name(ancestor::*[name()!='text_odstavce'])"/></xsl:attribute>
-->
	</xsl:template>

</xsl:stylesheet>
