<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl" xmlns:alto="http://alto">
	<xsl:output indent="yes" method="xml" omit-xml-declaration="yes" encoding="utf-8"/>
	<xsl:variable name="zobak-start"><![CDATA[<]]></xsl:variable>
	<xsl:variable name="lomitko"><![CDATA[/]]></xsl:variable>
	<xsl:variable name="zobak-end"><![CDATA[>]]></xsl:variable>
	<xsl:template match="/heslo">
		<!--
		<xsl:element name="slovnik">
-->
		<xsl:call-template name="heslo"/>
		<!--
		</xsl:element>
-->
	</xsl:template>
	<xsl:template name="heslo">
		<!-- provedu predbezne testy na chyby -->
		<xsl:variable name="errorHtml">
			<!--
			<xsl:if test="descendant::zahlavi and descendant::nasobne_zahlavi">
				<xsl:element name="p">Fatální chyba: heslo obsahuje Záhlaví i Násobné záhlaví. Prosím opravte.</xsl:element>
			</xsl:if>
-->
			<xsl:if test="count(descendant::zahlavi)>1">
				<xsl:element name="p">Fatální chyba: heslo obsahuje <xsl:value-of select="count(descendant::zahlavi)"/>x Záhlaví. Prosím opravte (použijte Násobné záhlaví).</xsl:element>
			</xsl:if>
			<xsl:if test="count(descendant::zahlavi)=0">
				<xsl:element name="p">Fatální chyba: heslo neobsahuje Záhlaví. Prosím opravte.</xsl:element>
			</xsl:if>
			<xsl:if test="count(block[descendant::zahlavi or descendant::nasobne_zahlavi or descendant::gramaticke_zarazeni or descendant::slovni_druh or descendant::frekvence])>1">
				<xsl:element name="p">Fatální chyba: v hesle se vyskytuje více odstavců se záhlavím, vícenásobným záhlavím, gramatickým zařazením nebo slovními druhy nebo frekvencí. Zpracování počítá s tím, že záhlaví, násobná záhlaví, gramatická zařazení a slovní druhy jsou uváděny pouze v úvodním bloku textu. Prosím, upravte heslo podle této logiky. <xsl:element name="b">Pokud je to ale mylný předpoklad, prosím kontaktujte OČ.</xsl:element>
				</xsl:element>
			</xsl:if>
			<xsl:if test="count(block[count(odkaz)+count(text_hesla)+count(String)=count(*) and count(odkaz)>0])>1">
				<xsl:element name="p">Fatální chyba: odkaz a exh pohromadě v jednom bloku!</xsl:element>
			</xsl:if>
			<!-- <xsl:if test="count(block[descendant::gramaticke_zarazeni or descendant::slovni_druh])>1">
				<xsl:element name="p">Fatální chyba: heslo obsahuje více bloků/odstavců textu s gramatickým zařazením či slovním druhem. Zpracování počítá s tím, že gramatická zařazení a slovní druhy jsou uváděny v jednom bloku textu - prosím spojte. <xsl:element name="b">Pokud je to ale mylný předpoklad, prosím kontaktujte OČ.</xsl:element>
				</xsl:element>
			</xsl:if> -->
			<xsl:variable name="testTemp1">
				<xsl:for-each select="block[(descendant::zahlavi or descendant::nasobne_zahlavi)]">
					<xsl:for-each select="descendant::*">
						<xsl:choose>
							<!-- povolene elementy -->
							<xsl:when test="name()='text_hesla'"/>
							<xsl:when test="name()='zahlavi'"/>
							<xsl:when test="name()='nasobne_zahlavi'"/>
							<xsl:when test="name()='gramaticke_zarazeni'"/>
							<xsl:when test="name()='slovni_druh'"/>
							<xsl:when test="name()='frekvence'"/>
							<xsl:when test="name()='String'"/>
							<xsl:when test="name()='odkaz'"/>
							<xsl:when test="name()='komentar'"/>
							<xsl:when test="name()='TAB'"/>
							<!-- nepovolene elementy -->
							<xsl:otherwise>
								<xsl:element name="li">
									<xsl:for-each select="String">
										<xsl:value-of select="@CONTENT"/>
										<xsl:text> </xsl:text>
									</xsl:for-each>
									<xsl:text> (</xsl:text>
									<xsl:value-of select="name()"/>)</xsl:element>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
				</xsl:for-each>
			</xsl:variable>
			<xsl:if test="$testTemp1!=''">
				<xsl:element name="p">Fatální chyba: heslo obsahuje blok se záhlavím, ale ve stejném bloku jsou i další elementy, které tam nemají být:</xsl:element>
				<xsl:element name="ul">
					<!--
					<xsl:copy-of select="$testTemp1"/>
-->
					<xsl:copy-of select="exsl:node-set($testTemp1)"/>
				</xsl:element>
				<xsl:element name="p">Dle metodiky by toto nemělo nastat. Prosím opravte. <xsl:element name="b">Pokud je to ale mylný předpoklad, prosím kontaktujte OČ.</xsl:element>
				</xsl:element>
			</xsl:if>
			<!--
			<xsl:element name="p">Varování: tohle varování je jenom na zkoušku.</xsl:element>
-->
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$errorHtml!='' and contains($errorHtml,'Fatální chyba')">
				<xsl:element name="error">
					<xsl:attribute name="type">fatal</xsl:attribute>
					<xsl:element name="h2">Chyba, záznam nelze uložit.</xsl:element>
					<!--
<xsl:copy-of select="$errorHtml"/>
-->
					<xsl:copy-of select="exsl:node-set($errorHtml)"/>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="$errorHtml!=''">
					<xsl:element name="error">
						<xsl:attribute name="type">warning</xsl:attribute>
						<xsl:element name="h2">Varování</xsl:element>
						<!--
					<xsl:copy-of select="$errorHtml"/>
-->
						<xsl:copy-of select="exsl:node-set($errorHtml)"/>
					</xsl:element>
				</xsl:if>
				<xsl:element name="heslo">
					<xsl:attribute name="typ"><xsl:value-of select="@typ"/></xsl:attribute>
					<xsl:if test="@slovnik">
						<xsl:attribute name="slovnik"><xsl:value-of select="@slovnik"/></xsl:attribute>
					</xsl:if>
					<!-- pripadne zkopirujeme BIGSKIP, je vzdy na prvnim miste -->
					<xsl:if test="BIGSKIP">
						<xsl:element name="BIGSKIP"/>
					</xsl:if>
					<!-- nejprve zpracujeme hlavicku -->
					<xsl:for-each select="block[descendant::zahlavi or descendant::nasobne_zahlavi]">
						<xsl:element name="hlavicka">
							<xsl:variable name="tempHlavicka">
								<xsl:for-each select="*">
									<xsl:choose>
										<xsl:when test="name()='xxxxx'">
										</xsl:when>
										<xsl:when test="name()='text_hesla' and @aip-subtype='text_hesla'">
											<xsl:element name="{name()}">
												<xsl:call-template name="cleanCopy-innerStrings"/>
											</xsl:element>
										</xsl:when>
										<!-- pokud SP zamitne druhou roletku, pak predelat @aip-subtype na prev important sibling -->
										<xsl:when test="(name()='text_hesla' or name()='String') and @aip-subtype='hlavicka'">
											<xsl:choose>
												<xsl:when test="name()='text_hesla'">
													<xsl:call-template name="cleanCopy"/>
												</xsl:when>
												<xsl:when test="name()='String'">
													<xsl:call-template name="cleanCopy-singleString"/>
												</xsl:when>
											</xsl:choose>
										</xsl:when>
										<!-- pokud SP zamitne druhou roletku, pak predelat @aip-subtype na prev important sibling -->
										<xsl:when test="name()='text_hesla' and (string-length(@aip-subtype)!=0 and @aip-subtype!='text_hesla' and @aip-subtype!='zahlavi') and preceding-sibling::zahlavi and not(preceding-sibling::nasobne_zahlavi) and not(preceding-sibling::slovni_druh) and not(preceding-sibling::frekvence)">
											<xsl:element name="{name()}">
												<xsl:choose>
													<xsl:when test="name()='text_hesla' or name()='gramaticke_zarazeni'">
														<xsl:call-template name="cleanCopy-innerStrings"/>
													</xsl:when>
													<xsl:when test="name()='String'">
														<xsl:call-template name="cleanCopy-singleString"/>
													</xsl:when>
												</xsl:choose>
											</xsl:element>
										</xsl:when>
										<xsl:when test="name()='text_hesla' and (string-length(@aip-subtype)!=0 and @aip-subtype='zahlavi') and preceding-sibling::zahlavi and not(preceding-sibling::nasobne_zahlavi) and not(preceding-sibling::slovni_druh) and not(preceding-sibling::frekvence)">
											<xsl:element name="zahlavi">
												<xsl:element name="{name()}">
													<xsl:choose>
														<xsl:when test="name()='text_hesla' or name()='gramaticke_zarazeni'">
															<xsl:call-template name="cleanCopy-innerStrings"/>
														</xsl:when>
														<xsl:when test="name()='String'">
															<xsl:call-template name="cleanCopy-singleString"/>
														</xsl:when>
													</xsl:choose>
												</xsl:element>
											</xsl:element>
										</xsl:when>
										<xsl:when test="name()='text_hesla' and (string-length(@aip-subtype)!=0 and @aip-subtype!='text_hesla') and preceding-sibling::nasobne_zahlavi and not(preceding-sibling::slovni_druh) and not(preceding-sibling::frekvence)">
											<xsl:element name="nasobne_zahlavi">
												<xsl:element name="{name()}">
													<xsl:choose>
														<xsl:when test="name()='text_hesla' or name()='gramaticke_zarazeni'">
															<xsl:call-template name="cleanCopy-innerStrings"/>
														</xsl:when>
														<xsl:when test="name()='String'">
															<xsl:call-template name="cleanCopy-singleString"/>
														</xsl:when>
													</xsl:choose>
												</xsl:element>
											</xsl:element>
										</xsl:when>
										<xsl:when test="name()='text_hesla' and (string-length(@aip-subtype)!=0 and @aip-subtype!='text_hesla') and preceding-sibling::slovni_druh">
											<xsl:element name="{name()}">
												<xsl:choose>
													<xsl:when test="name()='text_hesla' or name()='gramaticke_zarazeni'">
														<xsl:call-template name="cleanCopy-innerStrings"/>
													</xsl:when>
													<xsl:when test="name()='String'">
														<xsl:call-template name="cleanCopy-singleString"/>
													</xsl:when>
												</xsl:choose>
											</xsl:element>
										</xsl:when>
										<xsl:when test="name()='text_hesla' and (string-length(@aip-subtype)!=0 and @aip-subtype!='text_hesla') and preceding-sibling::frekvence">
											<xsl:element name="frekvence">
												<xsl:element name="{name()}">
													<xsl:choose>
														<xsl:when test="name()='text_hesla'">
															<xsl:call-template name="cleanCopy-innerStrings"/>
														</xsl:when>
														<xsl:when test="name()='String'">
															<xsl:call-template name="cleanCopy-singleString"/>
														</xsl:when>
													</xsl:choose>
												</xsl:element>
											</xsl:element>
										</xsl:when>
										<xsl:when test="(name()='gramaticke_zarazeni' or name()='String') and (string-length(@aip-subtype)!=0 and @aip-subtype!='text_hesla') and (@aip-subtype!='frekvence') and (@aip-subtype!='gramaticke_zarazeni')">
											<xsl:element name="{@aip-subtype}">
												<xsl:element name="{name()}">
													<xsl:choose>
														<xsl:when test="name()='text_hesla' or name()='gramaticke_zarazeni'">
															<xsl:call-template name="cleanCopy-innerStrings"/>
														</xsl:when>
														<xsl:when test="name()='String'">
															<xsl:call-template name="cleanCopy-singleString"/>
														</xsl:when>
													</xsl:choose>
												</xsl:element>
											</xsl:element>
										</xsl:when>
										<xsl:when test="(name()='gramaticke_zarazeni' or name()='String') and (string-length(@aip-subtype)!=0 and @aip-subtype='gramaticke_zarazeni')">
											<xsl:element name="{name()}">
												<xsl:choose>
													<xsl:when test="name()='text_hesla' or name()='gramaticke_zarazeni'">
														<xsl:call-template name="cleanCopy-innerStrings"/>
													</xsl:when>
													<xsl:when test="name()='String'">
														<xsl:call-template name="cleanCopy-singleString"/>
													</xsl:when>
												</xsl:choose>
											</xsl:element>
										</xsl:when>
										<xsl:when test="(name()='gramaticke_zarazeni' or name()='String') and (string-length(@aip-subtype)!=0 and @aip-subtype='text_hesla') and preceding-sibling::zahlavi and not(preceding-sibling::nasobne_zahlavi)">
											<xsl:element name="{name()}">
												<xsl:choose>
													<xsl:when test="name()='text_hesla' or name()='gramaticke_zarazeni'">
														<xsl:call-template name="cleanCopy-innerStrings"/>
													</xsl:when>
													<xsl:when test="name()='String'">
														<xsl:call-template name="cleanCopy-singleString"/>
													</xsl:when>
												</xsl:choose>
											</xsl:element>
										</xsl:when>
										<xsl:when test="(name()='gramaticke_zarazeni' or name()='String') and (string-length(@aip-subtype)!=0 and @aip-subtype='text_hesla') and preceding-sibling::nasobne_zahlavi">
											<xsl:element name="nasobne_zahlavi">
												<xsl:element name="{name()}">
													<xsl:choose>
														<xsl:when test="name()='text_hesla' or name()='gramaticke_zarazeni'">
															<xsl:call-template name="cleanCopy-innerStrings"/>
														</xsl:when>
														<xsl:when test="name()='String'">
															<xsl:call-template name="cleanCopy-singleString"/>
														</xsl:when>
													</xsl:choose>
												</xsl:element>
											</xsl:element>
										</xsl:when>
										<xsl:when test="name()='odkaz' or name()='zahlavi' or name()='nasobne_zahlavi' or name()='slovni_druh' or name()='frekvence' or name()='komentar'">
											<xsl:element name="{name()}">
												<xsl:call-template name="cleanCopy-innerStrings"/>
											</xsl:element>
										</xsl:when>
									</xsl:choose>
								</xsl:for-each>
							</xsl:variable>
							<!--
<xsl:comment>TEST</xsl:comment>
<xsl:copy-of select="$tempHlavicka"/>
<xsl:comment>TEST</xsl:comment>
-->
							<!--
<xsl:for-each select="$tempHlavicka/*">
-->
							<xsl:for-each select="exsl:node-set($tempHlavicka)/*">
								<xsl:variable name="previousName" select="name(preceding-sibling::*[position()=1])"/>
								<xsl:variable name="nextName" select="name(following-sibling::*[position()=1])"/>
								<xsl:if test="name()!=$previousName">
									<xsl:call-template name="startTag">
										<xsl:with-param name="tag" select="name()"/>
									</xsl:call-template>
								</xsl:if>
								<xsl:for-each select="*">
									<xsl:copy-of select="."/>
								</xsl:for-each>
								<xsl:if test="name()!=$nextName">
									<xsl:call-template name="endTag">
										<xsl:with-param name="tag" select="name()"/>
									</xsl:call-template>
								</xsl:if>
							</xsl:for-each>
						</xsl:element>
					</xsl:for-each>
					<!-- pak variantnte hlavicku s nasobnym zahlavimi -->
					<!-- TODO -->
					<!-- pak ostatni - v poradi, jak byly -->
					<xsl:for-each select="block">
						<xsl:choose>
							<!-- special block/odstavec jen s conferem - pokud takovy je, pak ho dame do hesla primo -->
							<!-- netestujeme na exh, protoze takova kombinace tam byt nemuze -->
							<xsl:when test="descendant::anglictina or descendant::cestina or descendant::rustina or descendant::latina or descendant::rectina">
								<xsl:element name="odstavec">
									<xsl:variable name="temp">
										<xsl:for-each select="*">
											<xsl:choose>
												<!-- cestina anglictina rustina -->
												<xsl:when test="name()='cestina' or name()='anglictina' or name()='rustina'">
													<xsl:element name="moderni_jazyky">
														<xsl:element name="{name()}">
															<xsl:call-template name="cleanCopy-innerStrings-jazyk"/>
														</xsl:element>
													</xsl:element>
												</xsl:when>
												<!-- Bez znaků -->
												<!-- Osetreni 2017-06-06 znaky vytvářejí text_hesla -->
												<xsl:when test="(name()='text_hesla' or name()='String') and (@aip-subtype='cestina' or @aip-subtype='anglictina' or @aip-subtype='rustina')">
													<xsl:element name="moderni_jazyky">
														<xsl:choose>
															<xsl:when test="String[@CONTENT=',' or @CONTENT=';' or @CONTENT='-' or @CONTENT='–' or @CONTENT='.' or @CONTENT=':' or @CONTENT='(!)']">
																<xsl:element name="text_hesla">
																	<xsl:choose>
																		<xsl:when test="name()='text_hesla'">
																			<xsl:call-template name="cleanCopy-innerStrings"/>
																		</xsl:when>
																		<xsl:when test="name()='String'">
																			<xsl:call-template name="cleanCopy-singleString"/>
																		</xsl:when>
																	</xsl:choose>
																</xsl:element>
															</xsl:when>
															<xsl:otherwise>
																<xsl:element name="text_hesla">
																	<xsl:choose>
																		<xsl:when test="name()='text_hesla'">
																			<xsl:call-template name="cleanCopy-innerStrings"/>
																		</xsl:when>
																		<xsl:when test="name()='String'">
																			<xsl:call-template name="cleanCopy-singleString"/>
																		</xsl:when>
																	</xsl:choose>
																</xsl:element>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:element>
												</xsl:when>
												<!-- String text_hesla - mimo pojmenovane jazyky -->
												<xsl:when test="(name()='text_hesla' or name()='String') and (@aip-subtype='moderni_jazyky' or @aip-subtype='stare_jazyky')">
													<xsl:element name="{@aip-subtype}">
														<xsl:choose>
															<xsl:when test="name()='text_hesla'">
																<xsl:call-template name="cleanCopy"/>
																<!--
nebo tohle???																<xsl:call-template name="cleanCopy-innerStrings"/>-->
															</xsl:when>
															<xsl:when test="name()='String'">
																<xsl:call-template name="cleanCopy-singleString"/>
															</xsl:when>
														</xsl:choose>
													</xsl:element>
												</xsl:when>
												<!-- rectina latina -->
												<xsl:when test="name()='rectina' or name()='latina'">
													<xsl:element name="stare_jazyky">
														<xsl:element name="{name()}">
															<xsl:call-template name="cleanCopy-innerStrings-jazyk"/>
														</xsl:element>
													</xsl:element>
												</xsl:when>
												<!-- Bez znaků -->
												<!-- Osetreni 2017-06-06 znaky vytvářejí text_hesla -->
												<xsl:when test="(name()='text_hesla' or name()='String') and (@aip-subtype='rectina' or @aip-subtype='latina')">
													<xsl:element name="stare_jazyky">
														<xsl:choose>
															<xsl:when test="String[@CONTENT=',' or @CONTENT=';' or @CONTENT='-' or @CONTENT='–' or @CONTENT='.' or @CONTENT=':' or @CONTENT='(!)']">
																<xsl:element name="text_hesla">
																	<xsl:choose>
																		<xsl:when test="name()='text_hesla'">
																			<xsl:call-template name="cleanCopy-innerStrings"/>
																		</xsl:when>
																		<xsl:when test="name()='String'">
																			<xsl:call-template name="cleanCopy-singleString"/>
																		</xsl:when>
																	</xsl:choose>
																</xsl:element>
															</xsl:when>
															<xsl:otherwise>
																<xsl:element name="text_hesla">
																	<xsl:choose>
																		<xsl:when test="name()='text_hesla'">
																			<xsl:call-template name="cleanCopy-innerStrings"/>
																		</xsl:when>
																		<xsl:when test="name()='String'">
																			<xsl:call-template name="cleanCopy-singleString"/>
																		</xsl:when>
																	</xsl:choose>
																</xsl:element>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:element>
												</xsl:when>
												<!-- String text_hesla - samostatne stojici -->
												<xsl:when test="(name()='text_hesla' or name()='String') and (@aip-subtype='odstavec')">
													<xsl:choose>
														<xsl:when test="name()='text_hesla'">
															<xsl:call-template name="cleanCopy"/>
														</xsl:when>
														<xsl:when test="name()='String'">
															<xsl:call-template name="cleanCopy-singleString"/>
														</xsl:when>
													</xsl:choose>
												</xsl:when>
												<xsl:otherwise>
													<xsl:comment>TODO - KONTROLA</xsl:comment>
													<xsl:copy-of select="."/>
												</xsl:otherwise>
											</xsl:choose>
										</xsl:for-each>
									</xsl:variable>
									<!--
									<xsl:comment>CHECK KOPIE</xsl:comment>
									<xsl:copy-of select="$temp"/>
									<xsl:comment>CHECK NORM</xsl:comment>
-->
									<!--
<xsl:for-each select="$temp/*">
-->
									<xsl:for-each select="exsl:node-set($temp)/*">
										<xsl:choose>
											<xsl:when test="name()='moderni_jazyky' or name()='stare_jazyky'">
												<xsl:variable name="previousName" select="name(preceding-sibling::*[position()=1])"/>
												<xsl:variable name="nextName" select="name(following-sibling::*[position()=1])"/>
												<xsl:if test="name()!=$previousName">
													<xsl:call-template name="startTag">
														<xsl:with-param name="tag" select="name()"/>
													</xsl:call-template>
												</xsl:if>
												<xsl:for-each select="*">
													<xsl:choose>
														<xsl:when test="name()='odkaz' or name()='latina' or name()='anglictina' or name()='cestina' or name()='rustina' or name()='rectina'">
															<xsl:variable name="previousName2" select="name(preceding-sibling::*[position()=1])"/>
															<xsl:variable name="nextName2" select="name(following-sibling::*[position()=1])"/>
															<xsl:if test="name(../preceding-sibling::*[position()=1]/*[last()])!=name()">
																<xsl:call-template name="startTag">
																	<xsl:with-param name="tag" select="name()"/>
																</xsl:call-template>
															</xsl:if>
															<xsl:for-each select="*">
																<xsl:copy-of select="."/>
															</xsl:for-each>
															<xsl:if test="name(../following-sibling::*[position()=1]/*)!=name()">
																<xsl:call-template name="endTag">
																	<xsl:with-param name="tag" select="name()"/>
																</xsl:call-template>
															</xsl:if>
														</xsl:when>
														<xsl:otherwise>
															<!--
													<xsl:comment>jen kopie 2</xsl:comment>
													<xsl:copy-of select="."/>
												-->
															<xsl:call-template name="cleanCopy-general"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:for-each>
												<xsl:if test="name()!=$nextName">
													<xsl:call-template name="endTag">
														<xsl:with-param name="tag" select="name()"/>
													</xsl:call-template>
												</xsl:if>
											</xsl:when>
											<xsl:otherwise>
												<!--
													<xsl:comment>jen kopie 1</xsl:comment>
													<xsl:copy-of select="."/>
												-->
												<xsl:call-template name="cleanCopy-general"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:for-each>
								</xsl:element>
							</xsl:when>
							<!-- jenom text hesla -->
							<!--OC: doplněn +count(odkaz), otestováno na klonu 829 záznamu 12. Bez odkazu mizel celý odstavec s textem hesla-->
							<xsl:when test="count(text_hesla)+count(exh)+count(TAB)+count(BIGSKIP)+count(odkaz)+count(gramaticke_zarazeni)+count(slovni_druh)+count(frekvence)+count(nasobne_zahlavi)+count(String)+count(komentar)=count(*)">
								<xsl:element name="odstavec">
									<xsl:for-each select="*">
										<xsl:choose>
											<xsl:when test="name()='String'">
												<xsl:call-template name="cleanCopy-singleString"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:call-template name="cleanCopy"/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:for-each>
								</xsl:element>
							</xsl:when>
						</xsl:choose>
					</xsl:for-each>
					<xsl:element name="metadata">
						<xsl:for-each select="metadata/*[name()!='pageinfo' and name()!='pageInfo']">
							<xsl:copy-of select="."/>
						</xsl:for-each>
					</xsl:element>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="cleanCopy">
		<xsl:element name="{name()}">
			<xsl:call-template name="cleanCopy-innerStrings"/>
		</xsl:element>
	</xsl:template>
	<xsl:template name="cleanCopy-general">
		<xsl:element name="{name()}">
			<xsl:for-each select="@*[name()!='aip-subtype']">
				<xsl:copy-of select="."/>
			</xsl:for-each>
			<xsl:for-each select="*">
				<xsl:call-template name="cleanCopy-general"/>
			</xsl:for-each>
		</xsl:element>
	</xsl:template>
	<xsl:template name="cleanCopy-innerStrings">
		<xsl:for-each select="*">
			<xsl:choose>
				<xsl:when test="name()='String'">
					<xsl:call-template name="cleanCopy-singleString"/>
				</xsl:when>
				<xsl:otherwise>
					<!--
					<xsl:copy-of select="."/>
-->
					<xsl:call-template name="cleanCopy"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="cleanCopy-innerStrings-jazyk">
		<xsl:for-each select="*">
			<xsl:choose>
				<xsl:when test="name()='String' and (@CONTENT=',' or @CONTENT=';' or @CONTENT='-' or @CONTENT='–' or @CONTENT='.' or @CONTENT=':' or @CONTENT='(!)')">
					<xsl:element name="text_hesla">
						<xsl:call-template name="cleanCopy-singleString"/>
					</xsl:element>
				</xsl:when>
				<xsl:when test="name()='String' and not(@CONTENT=',' or @CONTENT=';' or @CONTENT='-' or @CONTENT='–' or @CONTENT='.' or @CONTENT=':' or @CONTENT='(!)')">
					<xsl:call-template name="cleanCopy-singleString"/>
				</xsl:when>
				<xsl:otherwise>
					<!--
					<xsl:copy-of select="."/>
-->
					<xsl:call-template name="cleanCopy"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="cleanCopy-singleString">
		<xsl:element name="String">
			<xsl:for-each select="@*">
				<xsl:choose>
					<xsl:when test="name()='aip-subtype'"/>
					<xsl:otherwise>
						<xsl:copy-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</xsl:element>
	</xsl:template>
	<xsl:template name="startTag">
		<xsl:param name="tag"/>
		<xsl:value-of select="$zobak-start" disable-output-escaping="yes"/>
		<xsl:value-of select="$tag"/>
		<xsl:value-of select="$zobak-end" disable-output-escaping="yes"/>
	</xsl:template>
	<xsl:template name="endTag">
		<xsl:param name="tag"/>
		<xsl:value-of select="$zobak-start" disable-output-escaping="yes"/>
		<xsl:value-of select="$lomitko" disable-output-escaping="yes"/>
		<xsl:value-of select="$tag"/>
		<xsl:value-of select="$zobak-end" disable-output-escaping="yes"/>
	</xsl:template>
</xsl:stylesheet>
