<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl" xmlns:alto="http://alto" >

	<xsl:output indent="yes" method="xml" omit-xml-declaration="yes" encoding="utf-8"/>

	<xsl:variable name="zobak-start"><![CDATA[<]]></xsl:variable>
	<xsl:variable name="lomitko"><![CDATA[/]]></xsl:variable>
	<xsl:variable name="zobak-end"><![CDATA[>]]></xsl:variable>

	<xsl:template match="/heslo">
			<xsl:element name="heslo">
				<xsl:copy-of select="@typ"/>
				<xsl:copy-of select="@slovnik"/>
				<xsl:for-each select="*">
					<xsl:choose>
						<xsl:when test="name()='block'">
							<xsl:if test="count(*[name()!='TAB' and name()!='NEWLINE' and name()!='BIGSKIP'])>0">
								<xsl:element name="block">
									<xsl:for-each select="*">
										<xsl:choose>
											<xsl:when test="name()='newline'">
												<xsl:element name="NEWLINE"/>
											</xsl:when>
											<xsl:when test="name()='bigskip'">
												<xsl:element name="BIGSKIP"/>
											</xsl:when>
											<xsl:when test="name()='tab'">
												<xsl:element name="TAB"/>
											</xsl:when>
											<xsl:when test="name()='span'">
												<xsl:variable name="currentAipType" select="@aip-type"/>
												<xsl:variable name="currentAipSubtype" select="string(@aip-subtype)"/>
												<xsl:choose>
													<xsl:when test="@php-previousAipType!=$currentAipType or @php-previousAipSubtype!=$currentAipSubtype">
														<xsl:call-template name="startTag"><xsl:with-param name="tag" select="$currentAipType"/><xsl:with-param name="subtype" select="@aip-subtype"/></xsl:call-template>
													</xsl:when>
													<xsl:when test="@php-previousIsDivider='yes'">
														<xsl:call-template name="startTag"><xsl:with-param name="tag" select="$currentAipType"/><xsl:with-param name="subtype" select="@aip-subtype"/></xsl:call-template>
													</xsl:when>
													<xsl:when test="not(@php-previousAipType)">
														<!-- pro zpetnou kompatibilitu a ladeni s XSL - nemelo by byt pouzivatno v produkcnim, tam je potreba predzpracovani v PHP a melo by to spadnout do predchozich whenu -->
														<xsl:variable name="previousAipType" select="string(preceding-sibling::*[position()=1]/@aip-type)"/>
														<xsl:variable name="nextAipType" select="string(following-sibling::*[position()=1]/@aip-type)"/>
														<xsl:variable name="previousAipSubtype" select="string(preceding-sibling::*[position()=1]/@aip-subtype)"/>
														<xsl:variable name="nextAipSubtype" select="string(following-sibling::*[position()=1]/@aip-subtype)"/>
														<xsl:variable name="previousIsOddelovac">
															<xsl:choose>
																<xsl:when test="name(preceding-sibling::*[position()=1])='divider'">yes</xsl:when>
																<xsl:otherwise>no</xsl:otherwise>
															</xsl:choose>
														</xsl:variable>
														<xsl:variable name="nextIsOddelovac">
															<xsl:choose>
																<xsl:when test="name(following-sibling::*[position()=1])='divider'">yes</xsl:when>
																<xsl:otherwise>no</xsl:otherwise>
															</xsl:choose>
														</xsl:variable>
														<xsl:choose>
															<xsl:when test="$previousAipType!=$currentAipType or $previousAipSubtype!=$currentAipSubtype">
																<xsl:call-template name="startTag"><xsl:with-param name="tag" select="$currentAipType"/><xsl:with-param name="subtype" select="@aip-subtype"/></xsl:call-template>
															</xsl:when>
															<xsl:when test="$previousIsOddelovac='yes'">
																<xsl:call-template name="startTag"><xsl:with-param name="tag" select="$currentAipType"/><xsl:with-param name="subtype" select="@aip-subtype"/></xsl:call-template>
															</xsl:when>
														</xsl:choose>
													</xsl:when>
												</xsl:choose>
												<xsl:call-template name="spanToString"/>
												<xsl:choose>
													<xsl:when test="@php-nextAipType!=$currentAipType or @php-nextAipSubtype!=$currentAipSubtype">
														<xsl:call-template name="endTag"><xsl:with-param name="tag" select="$currentAipType"/><xsl:with-param name="subtype" select="@subtype"/></xsl:call-template>
													</xsl:when>
													<xsl:when test="@php-nextIsDivider='yes'">
														<xsl:call-template name="endTag"><xsl:with-param name="tag" select="$currentAipType"/><xsl:with-param name="subtype" select="@subtype"/></xsl:call-template>
													</xsl:when>
													<xsl:when test="not(@php-previousAipType)">
														<!-- zase pro zpetnou kompatibilitu a ladeni s XSL - nemelo by byt pouzivatno v produkcnim, tam je potreba predzpracovani v PHP a melo by to spadnout do predchozich whenu -->
														<xsl:variable name="previousAipType" select="string(preceding-sibling::*[position()=1]/@aip-type)"/>
														<xsl:variable name="nextAipType" select="string(following-sibling::*[position()=1]/@aip-type)"/>
														<xsl:variable name="previousAipSubtype" select="string(preceding-sibling::*[position()=1]/@aip-subtype)"/>
														<xsl:variable name="nextAipSubtype" select="string(following-sibling::*[position()=1]/@aip-subtype)"/>
														<xsl:variable name="previousIsOddelovac">
															<xsl:choose>
																<xsl:when test="name(preceding-sibling::*[position()=1])='divider'">yes</xsl:when>
																<xsl:otherwise>no</xsl:otherwise>
															</xsl:choose>
														</xsl:variable>
														<xsl:variable name="nextIsOddelovac">
															<xsl:choose>
																<xsl:when test="name(following-sibling::*[position()=1])='divider'">yes</xsl:when>
																<xsl:otherwise>no</xsl:otherwise>
															</xsl:choose>
														</xsl:variable>
														<xsl:choose>
															<xsl:when test="$nextAipType!=$currentAipType or $nextAipSubtype!=$currentAipSubtype">
																<xsl:call-template name="endTag"><xsl:with-param name="tag" select="$currentAipType"/><xsl:with-param name="subtype" select="@subtype"/></xsl:call-template>
															</xsl:when>
															<xsl:when test="$nextIsOddelovac='yes'">
																<xsl:call-template name="endTag"><xsl:with-param name="tag" select="$currentAipType"/><xsl:with-param name="subtype" select="@subtype"/></xsl:call-template>
															</xsl:when>
														</xsl:choose>
													</xsl:when>
												</xsl:choose>
											</xsl:when>
											<xsl:when test="name()='divider'">
												<xsl:call-template name="spanToString"/>
											</xsl:when>
											<xsl:otherwise>
												<xsl:copy-of select="."/>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:for-each>
								</xsl:element>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<xsl:copy-of select="."/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</xsl:element>
	</xsl:template>

	<xsl:template name="startTag">
		<xsl:param name="tag"/>
		<xsl:param name="subtype"/>
		<xsl:value-of select="$zobak-start" disable-output-escaping="yes"/>
		<xsl:value-of select="$tag"/>
		<xsl:if test="$subtype!=''">
			<xsl:text> aip-subtype="</xsl:text>
			<xsl:value-of select="$subtype"/>
			<xsl:text>"</xsl:text>
		</xsl:if>
		<xsl:value-of select="$zobak-end" disable-output-escaping="yes"/>
	</xsl:template>

	<xsl:template name="endTag">
		<xsl:param name="tag"/>
		<xsl:value-of select="$zobak-start" disable-output-escaping="yes"/>
		<xsl:value-of select="$lomitko" disable-output-escaping="yes"/>
		<xsl:value-of select="$tag"/>
		<xsl:value-of select="$zobak-end" disable-output-escaping="yes"/>
	</xsl:template>

	<xsl:template name="spanToString">
				<xsl:element name="String">
					<xsl:for-each select="@*">
						<xsl:choose>
							<!-- odfiltrujeme aip pomocne atributy -->
							<xsl:when test="name()='aip-type'"/>
							<xsl:when test="name()='aip-editable'"/>
							<xsl:when test="name()='aip-path'"/>
							<!-- a zobrazovaci attr -->
							<xsl:when test="name()='class'"/>
							<xsl:when test="name()='style'"/>
							<xsl:when test="name()='title'"/>
							<xsl:when test="name()='img_id'"/>
							<xsl:when test="name()='list_num'"/>
							<xsl:when test="name()='list_num'"/>
							<xsl:when test="name()='list_num'"/>
							<xsl:when test="name()='list_num'"/>
							<xsl:when test="starts-with(name(),'php-')"/>
							<!-- puvodni predelam na velka pismena -->
							<xsl:when test="name()='alphabet'">
								<xsl:attribute name="ALPHABET"><xsl:value-of select="."/></xsl:attribute>
							</xsl:when>
							<xsl:when test="name()='fontsize'">
								<xsl:attribute name="FONTSIZE"><xsl:value-of select="."/></xsl:attribute>
							</xsl:when>
							<xsl:when test="name()='aip-font'">
								<xsl:attribute name="FONT"><xsl:value-of select="."/></xsl:attribute>
								<xsl:attribute name="aip-font"><xsl:value-of select="."/></xsl:attribute>
							</xsl:when>
							<xsl:when test="name()='height'">
								<xsl:attribute name="HEIGHT"><xsl:value-of select="."/></xsl:attribute>
							</xsl:when>
							<xsl:when test="name()='hpos'">
								<xsl:attribute name="HPOS"><xsl:value-of select="."/></xsl:attribute>
							</xsl:when>
							<xsl:when test="name()='lang'">
								<xsl:attribute name="LANG"><xsl:value-of select="."/></xsl:attribute>
							</xsl:when>
							<xsl:when test="name()='page_id'">
								<xsl:attribute name="PAGE_ID"><xsl:value-of select="."/></xsl:attribute>
							</xsl:when>
							<xsl:when test="name()='vpos'">
								<xsl:attribute name="VPOS"><xsl:value-of select="."/></xsl:attribute>
							</xsl:when>
							<xsl:when test="name()='wc'">
								<xsl:attribute name="WC"><xsl:value-of select="."/></xsl:attribute>
							</xsl:when>
							<xsl:when test="name()='width'">
								<xsl:attribute name="WIDTH"><xsl:value-of select="."/></xsl:attribute>
							</xsl:when>
							<!-- aip-style na STYLE -->
							<xsl:when test="name()='aip-style'">
								<xsl:attribute name="STYLE"><xsl:value-of select="."/></xsl:attribute>
							</xsl:when>
							<xsl:when test="name()='origcontent'">
								<xsl:attribute name="ORIGCONTENT"><xsl:value-of select="."/></xsl:attribute>
							</xsl:when>
							<xsl:when test="name()='error'">
								<xsl:attribute name="ERROR"><xsl:value-of select="."/></xsl:attribute>
							</xsl:when>
							<!-- CONTENT bude nasledne vytvoren novy -->
							<xsl:when test="name()='CONTENT'"/>
							<xsl:when test="name()='content'"/>
							<!-- ostatni kopiruji -->
							<xsl:otherwise><xsl:copy-of select="."/></xsl:otherwise>
						</xsl:choose>
					</xsl:for-each>
					<!-- jestlize neni ulozena stara hodnota content, tak ji ulozim ...  co kdyby to k necemu bylo -->
					<xsl:choose>
						<xsl:when test="@origcontent"/>
						<xsl:otherwise><xsl:attribute name="ORIGCONTENT"><xsl:value-of select="@content"/></xsl:attribute></xsl:otherwise>
					</xsl:choose>
					<!-- yapisi aktualni CONTENT -->
					<xsl:attribute name="CONTENT"><xsl:value-of select="."/></xsl:attribute>
				</xsl:element>
	</xsl:template>

</xsl:stylesheet>
