<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:alto="http://alto">
	<xsl:output indent="yes" method="xml" omit-xml-declaration="yes" encoding="utf-8"/>
	<xsl:variable name="zobak-start"><![CDATA[<]]></xsl:variable>
	<xsl:variable name="lomitko"><![CDATA[/]]></xsl:variable>
	<xsl:variable name="zobak-end"><![CDATA[>]]></xsl:variable>
	<xsl:variable name="settings_subtype-context">position</xsl:variable>
	<!-- user = kontext se bere ze zaznamu a pripadne ho meni uzovatel praci s roletkami; position = bere se z kontextu pozice -->
	<xsl:template match="/div[@aip-type]">
		<xsl:call-template name="polotovar-part1"/>
	</xsl:template>
	<xsl:template name="polotovar-part1">
		<!-- nejprve si predpripravim lepsi strukturu - stromecek -->
		<xsl:element name="heslo">
			<xsl:attribute name="typ"><xsl:value-of select="@aip-type"/></xsl:attribute>
			<xsl:if test="@slovnik">
			<xsl:attribute name="slovnik"><xsl:value-of select="@slovnik"/></xsl:attribute>
			</xsl:if>
			<xsl:for-each select="*">
				<xsl:choose>
					<xsl:when test="name()='metadata'">
						<xsl:copy-of select="."/>
					</xsl:when>
					<xsl:when test="name()='newline'">
						<xsl:element name="NEWLINE"/>
					</xsl:when>
					<xsl:when test="name()='bigskip'">
						<xsl:element name="BIGSKIP"/>
					</xsl:when>
					<xsl:when test="name()='tab'">
						<xsl:element name="TAB"/>
					</xsl:when>
					<xsl:when test="name()='start'"/>
					<xsl:when test="name()='end'"/>
					<xsl:otherwise>
						<!-- je to block -->
						<xsl:choose>
							<xsl:when test="name()='metadata'">
								<xsl:copy-of select="."/>
							</xsl:when>
							<xsl:when test="name()='newline'">
								<xsl:element name="NEWLINE"/>
							</xsl:when>
							<xsl:when test="name()='bigskip'">
								<xsl:element name="BIGSKIP"/>
							</xsl:when>
							<xsl:when test="name()='tab'">
								<xsl:element name="TAB"/>
							</xsl:when>
							<xsl:when test="name()='start'"/>
							<xsl:when test="name()='end'"/>
							<xsl:otherwise>
								<xsl:element name="block">
									<xsl:for-each select="*">
										<xsl:choose>
											<xsl:when test="$settings_subtype-context='position'">
<!--
												<xsl:variable name="nearestImportantPreType" select="preceding-sibling::*[name()!='TAB' and name()!='NEWLINE' and name()!='BIGSKIP'][position()=1]/@aip-type"/>
-->
												<xsl:variable name="nearestImportantPreType" select="@php-NIPT"/>
												<xsl:variable name="finalNIPT">
													<xsl:choose>
														<xsl:when test="position()=1">
															<!--<xsl:text>A-</xsl:text>-->
															<xsl:value-of select="@aip-type"/>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="$nearestImportantPreType"/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:variable>
												<xsl:element name="{name()}">
													<xsl:choose>
														<xsl:when test="string-length($nearestImportantPreType)!=0">
															<xsl:attribute name="aip-subtype"><xsl:value-of select="$finalNIPT"/></xsl:attribute>
														</xsl:when>
														<xsl:when test="name(..)!=''">
															<xsl:attribute name="aip-subtype"><xsl:value-of select="name(..)"/></xsl:attribute>
														</xsl:when>
													</xsl:choose>
													<xsl:for-each select="@*[name()!='aip-subtype']">
														<xsl:choose>
															<xsl:when test="contains(.,'&amp;nbsp;')">
																<xsl:attribute name="{name()}"><xsl:call-template name="pevnamezera"><xsl:with-param name="text" select="."/></xsl:call-template></xsl:attribute>
															</xsl:when>
															<xsl:otherwise>
																<xsl:copy-of select="."/>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:for-each>
													<xsl:choose>
														<xsl:when test="contains(.,'&amp;nbsp;')">
															<xsl:call-template name="pevnamezera">
																<xsl:with-param name="text" select="."/>
															</xsl:call-template>
														</xsl:when>
														<xsl:otherwise>
															<xsl:value-of select="."/>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:element>
											</xsl:when>
											<xsl:otherwise>
												<xsl:choose>
													<xsl:when test="contains(.,'&amp;nbsp;')">
														<xsl:attribute name="{name()}"><xsl:call-template name="pevnamezera"><xsl:with-param name="text" select="."/></xsl:call-template></xsl:attribute>
													</xsl:when>
													<xsl:otherwise>
														<xsl:copy-of select="."/>
													</xsl:otherwise>
												</xsl:choose>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:for-each>
								</xsl:element>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</xsl:element>
	</xsl:template>

	<xsl:template name="startTag">
		<xsl:value-of select="$zobak-start" disable-output-escaping="yes"/>
		<xsl:text>block</xsl:text>
		<xsl:value-of select="$zobak-end" disable-output-escaping="yes"/>
	</xsl:template>

	<xsl:template name="endTag">
		<xsl:value-of select="$zobak-start" disable-output-escaping="yes"/>
		<xsl:value-of select="$lomitko" disable-output-escaping="yes"/>
		<xsl:text>block</xsl:text>
		<xsl:value-of select="$zobak-end" disable-output-escaping="yes"/>
	</xsl:template>

	<xsl:template name="pevnamezera">
		<xsl:param name="text"/>
		<xsl:choose>
			<xsl:when test="contains($text,'&amp;nbsp;')">
				<xsl:value-of select="substring-before($text,'&amp;nbsp;')"/>
				<xsl:text>&#0160;</xsl:text>
				<xsl:call-template name="pevnamezera">
					<xsl:with-param name="text" select="substring-after($text,'&amp;nbsp;')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
