
var basic_latin = [
{code:'U+0021',char:'!',description:'Exclamation mark'},
{code:'U+0022',char:'"',description:'Quotation mark'},
{code:'U+0023',char:'#',description:'Number sign'},
{code:'U+0024',char:'$',description:'Dollar sign'},
{code:'U+0025',char:'%',description:'Percent sign'},
{code:'U+0026',char:'&',description:'Ampersand'},
{code:"U+0027",char:"'",description:'Apostrophe'},
{code:'U+0028',char:'(',description:'Left parenthesis'},
{code:'U+0029',char:')',description:'Right parenthesis'},
{code:'U+002A',char:'*',description:'Asterisk'},
{code:'U+002B',char:'+',description:'Plus sign'},
{code:'U+002C',char:',',description:'Comma'},
{code:'U+002D',char:'-',description:'Hyphen-minus'},
{code:'U+002E',char:'.',description:'Full stop '},
{code:'U+002F',char:'/',description:'Slash'},
{code:'U+0030',char:'0',description:'Digit Zero'},
{code:'U+0031',char:'1',description:'Digit One'},
{code:'U+0032',char:'2',description:'Digit Two'},
{code:'U+0033',char:'3',description:'Digit Three'},
{code:'U+0034',char:'4',description:'Digit Four'},
{code:'U+0035',char:'5',description:'Digit Five'},
{code:'U+0036',char:'6',description:'Digit Six'},
{code:'U+0037',char:'7',description:'Digit Seven'},
{code:'U+0038',char:'8',description:'Digit Eight'},
{code:'U+0039',char:'9',description:'Digit Nine'},
{code:'U+003A',char:':',description:'Colon'},
{code:'U+003B',char:';',description:'Semicolon'},
{code:'U+003C',char:'<',description:'Less-than sign'},
{code:'U+003D',char:'=',description:'Equal sign'},
{code:'U+003E',char:'>',description:'Greater-than sign'},
{code:'U+003F',char:'?',description:'Question mark'},
{code:'U+0040',char:'@',description:'At sign'},
{code:'U+0041',char:'A',description:'Latin Capital letter A'},
{code:'U+0042',char:'B',description:'Latin Capital letter B'},
{code:'U+0043',char:'C',description:'Latin Capital letter C'},
{code:'U+0044',char:'D',description:'Latin Capital letter D'},
{code:'U+0045',char:'E',description:'Latin Capital letter E'},
{code:'U+0046',char:'F',description:'Latin Capital letter F'},
{code:'U+0047',char:'G',description:'Latin Capital letter G'},
{code:'U+0048',char:'H',description:'Latin Capital letter H'},
{code:'U+0049',char:'I',description:'Latin Capital letter I'},
{code:'U+004A',char:'J',description:'Latin Capital letter J'},
{code:'U+004B',char:'K',description:'Latin Capital letter K'},
{code:'U+004C',char:'L',description:'Latin Capital letter L'},
{code:'U+004D',char:'M',description:'Latin Capital letter M'},
{code:'U+004E',char:'N',description:'Latin Capital letter N'},
{code:'U+004F',char:'O',description:'Latin Capital letter O'},
{code:'U+0050',char:'P',description:'Latin Capital letter P'},
{code:'U+0051',char:'Q',description:'Latin Capital letter Q'},
{code:'U+0052',char:'R',description:'Latin Capital letter R'},
{code:'U+0053',char:'S',description:'Latin Capital letter S'},
{code:'U+0054',char:'T',description:'Latin Capital letter T'},
{code:'U+0055',char:'U',description:'Latin Capital letter U'},
{code:'U+0056',char:'V',description:'Latin Capital letter V'},
{code:'U+0057',char:'W',description:'Latin Capital letter W'},
{code:'U+0058',char:'X',description:'Latin Capital letter X'},
{code:'U+0059',char:'Y',description:'Latin Capital letter Y'},
{code:'U+005A',char:'Z',description:'Latin Capital letter Z'},
{code:'U+005B',char:'[',description:'Left Square Bracket'},
{code:'U+005C',char:'\\',description:'Backslash [A]'},
{code:'U+005D',char:']',description:'Right Square Bracket'},
{code:'U+005E',char:'^',description:'Circumflex accent'},
{code:'U+005F',char:'_',description:'Low line'},
{code:'U+0060',char:'`',description:'Grave accent'},
{code:'U+0061',char:'a',description:'Latin Small Letter A'},
{code:'U+0062',char:'b',description:'Latin Small Letter B'},
{code:'U+0063',char:'c',description:'Latin Small Letter C'},
{code:'U+0064',char:'d',description:'Latin Small Letter D'},
{code:'U+0065',char:'e',description:'Latin Small Letter E'},
{code:'U+0066',char:'f',description:'Latin Small Letter F'},
{code:'U+0067',char:'g',description:'Latin Small Letter G'},
{code:'U+0068',char:'h',description:'Latin Small Letter H'},
{code:'U+0069',char:'i',description:'Latin Small Letter I'},
{code:'U+006A',char:'j',description:'Latin Small Letter J'},
{code:'U+006B',char:'k',description:'Latin Small Letter K'},
{code:'U+006C',char:'l',description:'Latin Small Letter L'},
{code:'U+006D',char:'m',description:'Latin Small Letter M'},
{code:'U+006E',char:'n',description:'Latin Small Letter N'},
{code:'U+006F',char:'o',description:'Latin Small Letter O'},
{code:'U+0070',char:'p',description:'Latin Small Letter P'},
{code:'U+0071',char:'q',description:'Latin Small Letter Q'},
{code:'U+0072',char:'r',description:'Latin Small Letter R'},
{code:'U+0073',char:'s',description:'Latin Small Letter S'},
{code:'U+0074',char:'t',description:'Latin Small Letter T'},
{code:'U+0075',char:'u',description:'Latin Small Letter U'},
{code:'U+0076',char:'v',description:'Latin Small Letter V'},
{code:'U+0077',char:'w',description:'Latin Small Letter W'},
{code:'U+0078',char:'x',description:'Latin Small Letter X'},
{code:'U+0079',char:'y',description:'Latin Small Letter Y'},
{code:'U+007A',char:'z',description:'Latin Small Letter Z'},
{code:'U+007B',char:'{',description:'Left Curly Bracket'},
{code:'U+007C',char:'|',description:'Vertical bar'},
{code:'U+007D',char:'}',description:'Right Curly Bracket'},
{code:'U+007E',char:'~',description:'Tilde'},
];

var latin_1_supplement = [
{code:'U+00A1',char:'¡',description:'Inverted Exclamation Mark'},
{code:'U+00A2',char:'¢',description:'Cent sign'},
{code:'U+00A3',char:'£',description:'Pound sign'},
{code:'U+00A4',char:'¤',description:'Currency sign'},
{code:'U+00A5',char:'¥',description:'Yen sign'},
{code:'U+00A6',char:'¦',description:'Broken bar'},
{code:'U+00A7',char:'§',description:'Section sign'},
{code:'U+00A8',char:'¨',description:'Diaeresis'},
{code:'U+00A9',char:'©',description:'Copyright sign'},
{code:'U+00AA',char:'ª',description:'Feminine Ordinal Indicator'},
{code:'U+00AB',char:'«',description:'Left-pointing double angle quotation mark'},
{code:'U+00AC',char:'¬',description:'Not sign'},
{code:'U+00AD',char:'',description:'Soft hyphen'},
{code:'U+00AE',char:'®',description:'Registered sign'},
{code:'U+00AF',char:'¯',description:'Macron'},
{code:'U+00B0',char:'°',description:'Degree symbol'},
{code:'U+00B1',char:'±',description:'Plus-minus sign'},
{code:'U+00B2',char:'²',description:'Superscript two'},
{code:'U+00B3',char:'³',description:'Superscript three'},
{code:'U+00B4',char:'´',description:'Acute accent'},
{code:'U+00B5',char:'µ',description:'Micro sign'},
{code:'U+00B6',char:'¶',description:'Pilcrow sign'},
{code:'U+00B7',char:'·',description:'Middle dot'},
{code:'U+00B8',char:'¸',description:'Cedilla'},
{code:'U+00B9',char:'¹',description:'Superscript one'},
{code:'U+00BA',char:'º',description:'Masculine ordinal indicator'},
{code:'U+00BB',char:'»',description:'Right-pointing double-angle quotation mark'},
{code:'U+00BC',char:'¼',description:'Vulgar fraction one quarter'},
{code:'U+00BD',char:'½',description:'Vulgar fraction one half'},
{code:'U+00BE',char:'¾',description:'Vulgar fraction three quarters'},
{code:'U+00BF',char:'¿',description:'Inverted Question Mark'},
{code:'U+00C0',char:'À',description:'Latin Capital Letter A with grave'},
{code:'U+00C1',char:'Á',description:'Latin Capital letter A with acute'},
{code:'U+00C2',char:'Â',description:'Latin Capital letter A with circumflex'},
{code:'U+00C3',char:'Ã',description:'Latin Capital letter A with tilde'},
{code:'U+00C4',char:'Ä',description:'Latin Capital letter A with diaeresis'},
{code:'U+00C5',char:'Å',description:'Latin Capital letter A with ring above'},
{code:'U+00C6',char:'Æ',description:'Latin Capital letter AE'},
{code:'U+00C7',char:'Ç',description:'Latin Capital letter C with cedilla'},
{code:'U+00C8',char:'È',description:'Latin Capital letter E with grave'},
{code:'U+00C9',char:'É',description:'Latin Capital letter E with acute'},
{code:'U+00CA',char:'Ê',description:'Latin Capital letter E with circumflex'},
{code:'U+00CB',char:'Ë',description:'Latin Capital letter E with diaeresis'},
{code:'U+00CC',char:'Ì',description:'Latin Capital letter I with grave'},
{code:'U+00CD',char:'Í',description:'Latin Capital letter I with acute'},
{code:'U+00CE',char:'Î',description:'Latin Capital letter I with circumflex'},
{code:'U+00CF',char:'Ï',description:'Latin Capital letter I with diaeresis'},
{code:'U+00D0',char:'Ð',description:'Latin Capital letter Eth'},
{code:'U+00D1',char:'Ñ',description:'Latin Capital letter N with tilde'},
{code:'U+00D2',char:'Ò',description:'Latin Capital letter O with grave'},
{code:'U+00D3',char:'Ó',description:'Latin Capital letter O with acute'},
{code:'U+00D4',char:'Ô',description:'Latin Capital letter O with circumflex'},
{code:'U+00D5',char:'Õ',description:'Latin Capital letter O with tilde'},
{code:'U+00D6',char:'Ö',description:'Latin Capital letter O with diaeresis'},
{code:'U+00D7',char:'×',description:'Multiplication sign'},
{code:'U+00D8',char:'Ø',description:'Latin Capital letter O with stroke'},
{code:'U+00D9',char:'Ù',description:'Latin Capital letter U with grave'},
{code:'U+00DA',char:'Ú',description:'Latin Capital letter U with acute'},
{code:'U+00DB',char:'Û',description:'Latin Capital Letter U with circumflex'},
{code:'U+00DC',char:'Ü',description:'Latin Capital Letter U with diaeresis'},
{code:'U+00DD',char:'Ý',description:'Latin Capital Letter Y with acute'},
{code:'U+00DE',char:'Þ',description:'Latin Capital Letter Thorn'},
{code:'U+00DF',char:'ß',description:'Latin Small Letter sharp S'},
{code:'U+00E0',char:'à',description:'Latin Small Letter A with grave'},
{code:'U+00E1',char:'á',description:'Latin Small Letter A with acute'},
{code:'U+00E2',char:'â',description:'Latin Small Letter A with circumflex'},
{code:'U+00E3',char:'ã',description:'Latin Small Letter A with tilde'},
{code:'U+00E4',char:'ä',description:'Latin Small Letter A with diaeresis'},
{code:'U+00E5',char:'å',description:'Latin Small Letter A with ring above'},
{code:'U+00E6',char:'æ',description:'Latin Small Letter AE'},
{code:'U+00E7',char:'ç',description:'Latin Small Letter C with cedilla'},
{code:'U+00E8',char:'è',description:'Latin Small Letter E with grave'},
{code:'U+00E9',char:'é',description:'Latin Small Letter E with acute'},
{code:'U+00EA',char:'ê',description:'Latin Small Letter E with circumflex'},
{code:'U+00EB',char:'ë',description:'Latin Small Letter E with diaeresis'},
{code:'U+00EC',char:'ì',description:'Latin Small Letter I with grave'},
{code:'U+00ED',char:'í',description:'Latin Small Letter I with acute'},
{code:'U+00EE',char:'î',description:'Latin Small Letter I with circumflex'},
{code:'U+00EF',char:'ï',description:'Latin Small Letter I with diaeresis'},
{code:'U+00F0',char:'ð',description:'Latin Small Letter Eth'},
{code:'U+00F1',char:'ñ',description:'Latin Small Letter N with tilde'},
{code:'U+00F2',char:'ò',description:'Latin Small Letter O with grave'},
{code:'U+00F3',char:'ó',description:'Latin Small Letter O with acute'},
{code:'U+00F4',char:'ô',description:'Latin Small Letter O with circumflex'},
{code:'U+00F5',char:'õ',description:'Latin Small Letter O with tilde'},
{code:'U+00F6',char:'ö',description:'Latin Small Letter O with diaeresis'},
{code:'U+00F7',char:'÷',description:'Division sign'},
{code:'U+00F8',char:'ø',description:'Latin Small Letter O with stroke'},
{code:'U+00F9',char:'ù',description:'Latin Small Letter U with grave'},
{code:'U+00FA',char:'ú',description:'Latin Small Letter U with acute'},
{code:'U+00FB',char:'û',description:'Latin Small Letter U with circumflex'},
{code:'U+00FC',char:'ü',description:'Latin Small Letter U with diaeresis'},
{code:'U+00FD',char:'ý',description:'Latin Small Letter Y with acute'},
{code:'U+00FE',char:'þ',description:'Latin Small Letter Thorn'},
{code:'U+00FF',char:'ÿ',description:'Latin Small Letter Y with diaeresis'},
];

var latin_extended_a = [
{code:'U+0100',char:'Ā',description:'Latin Capital Letter A with macron'},
{code:'U+0101',char:'ā',description:'Latin Small Letter A with macron'},
{code:'U+0102',char:'Ă',description:'Latin Capital Letter A with breve'},
{code:'U+0103',char:'ă',description:'Latin Small Letter A with breve'},
{code:'U+0104',char:'Ą',description:'Latin Capital Letter A with ogonek'},
{code:'U+0105',char:'ą',description:'Latin Small Letter A with ogonek'},
{code:'U+0106',char:'Ć',description:'Latin Capital Letter C with acute'},
{code:'U+0107',char:'ć',description:'Latin Small Letter C with acute'},
{code:'U+0108',char:'Ĉ',description:'Latin Capital Letter C with circumflex'},
{code:'U+0109',char:'ĉ',description:'Latin Small Letter C with circumflex'},
{code:'U+010A',char:'Ċ',description:'Latin Capital Letter C with dot above'},
{code:'U+010B',char:'ċ',description:'Latin Small Letter C with dot above'},
{code:'U+010C',char:'Č',description:'Latin Capital Letter C with caron'},
{code:'U+010D',char:'č',description:'Latin Small Letter C with caron'},
{code:'U+010E',char:'Ď',description:'Latin Capital Letter D with caron'},
{code:'U+010F',char:'ď',description:'Latin Small Letter D with caron'},
{code:'U+0110',char:'Đ',description:'Latin Capital Letter D with stroke'},
{code:'U+0111',char:'đ',description:'Latin Small Letter D with stroke'},
{code:'U+0112',char:'Ē',description:'Latin Capital Letter E with macron'},
{code:'U+0113',char:'ē',description:'Latin Small Letter E with macron'},
{code:'U+0114',char:'Ĕ',description:'Latin Capital Letter E with breve'},
{code:'U+0115',char:'ĕ',description:'Latin Small Letter E with breve'},
{code:'U+0116',char:'Ė',description:'Latin Capital Letter E with dot above'},
{code:'U+0117',char:'ė',description:'Latin Small Letter E with dot above'},
{code:'U+0118',char:'Ę',description:'Latin Capital Letter E with ogonek'},
{code:'U+0119',char:'ę',description:'Latin Small Letter E with ogonek'},
{code:'U+011A',char:'Ě',description:'Latin Capital Letter E with caron'},
{code:'U+011B',char:'ě',description:'Latin Small Letter E with caron'},
{code:'U+011C',char:'Ĝ',description:'Latin Capital Letter G with circumflex'},
{code:'U+011D',char:'ĝ',description:'Latin Small Letter G with circumflex'},
{code:'U+011E',char:'Ğ',description:'Latin Capital Letter G with breve'},
{code:'U+011F',char:'ğ',description:'Latin Small Letter G with breve'},
{code:'U+0120',char:'Ġ',description:'Latin Capital Letter G with dot above'},
{code:'U+0121',char:'ġ',description:'Latin Small Letter G with dot above'},
{code:'U+0122',char:'Ģ',description:'Latin Capital Letter G with cedilla'},
{code:'U+0123',char:'ģ',description:'Latin Small Letter G with cedilla'},
{code:'U+0124',char:'Ĥ',description:'Latin Capital Letter H with circumflex'},
{code:'U+0125',char:'ĥ',description:'Latin Small Letter H with circumflex'},
{code:'U+0126',char:'Ħ',description:'Latin Capital Letter H with stroke'},
{code:'U+0127',char:'ħ',description:'Latin Small Letter H with stroke'},
{code:'U+0128',char:'Ĩ',description:'Latin Capital Letter I with tilde'},
{code:'U+0129',char:'ĩ',description:'Latin Small Letter I with tilde'},
{code:'U+012A',char:'Ī',description:'Latin Capital Letter I with macron'},
{code:'U+012B',char:'ī',description:'Latin Small Letter I with macron'},
{code:'U+012C',char:'Ĭ',description:'Latin Capital Letter I with breve'},
{code:'U+012D',char:'ĭ',description:'Latin Small Letter I with breve'},
{code:'U+012E',char:'Į',description:'Latin Capital Letter I with ogonek'},
{code:'U+012F',char:'į',description:'Latin Small Letter I with ogonek'},
{code:'U+0130',char:'İ',description:'Latin Capital Letter I with dot above'},
{code:'U+0131',char:'ı',description:'Latin Small Letter dotless I'},
{code:'U+0132',char:'Ĳ',description:'Latin Capital Ligature IJ'},
{code:'U+0133',char:'ĳ',description:'Latin Small Ligature IJ'},
{code:'U+0134',char:'Ĵ',description:'Latin Capital Letter J with circumflex'},
{code:'U+0135',char:'ĵ',description:'Latin Small Letter J with circumflex'},
{code:'U+0136',char:'Ķ',description:'Latin Capital Letter K with cedilla'},
{code:'U+0137',char:'ķ',description:'Latin Small Letter K with cedilla'},
{code:'U+0138',char:'ĸ',description:'Latin Small Letter Kra'},
{code:'U+0139',char:'Ĺ',description:'Latin Capital Letter L with acute'},
{code:'U+013A',char:'ĺ',description:'Latin Small Letter L with acute'},
{code:'U+013B',char:'Ļ',description:'Latin Capital Letter L with cedilla'},
{code:'U+013C',char:'ļ',description:'Latin Small Letter L with cedilla'},
{code:'U+013D',char:'Ľ',description:'Latin Capital Letter L with caron'},
{code:'U+013E',char:'ľ',description:'Latin Small Letter L with caron'},
{code:'U+013F',char:'Ŀ',description:'Latin Capital Letter L with middle dot'},
{code:'U+0140',char:'ŀ',description:'Latin Small Letter L with middle dot'},
{code:'U+0141',char:'Ł',description:'Latin Capital Letter L with stroke'},
{code:'U+0142',char:'ł',description:'Latin Small Letter L with stroke'},
{code:'U+0143',char:'Ń',description:'Latin Capital Letter N with acute'},
{code:'U+0144',char:'ń',description:'Latin Small Letter N with acute'},
{code:'U+0145',char:'Ņ',description:'Latin Capital Letter N with cedilla'},
{code:'U+0146',char:'ņ',description:'Latin Small Letter N with cedilla'},
{code:'U+0147',char:'Ň',description:'Latin Capital Letter N with caron'},
{code:'U+0148',char:'ň',description:'Latin Small Letter N with caron'},
{code:'U+0149',char:'ŉ',description:'Latin Small Letter N preceded by apostrophe'},
{code:'U+014A',char:'Ŋ',description:'Latin Capital Letter Eng'},
{code:'U+014B',char:'ŋ',description:'Latin Small Letter Eng'},
{code:'U+014C',char:'Ō',description:'Latin Capital Letter O with macron'},
{code:'U+014D',char:'ō',description:'Latin Small Letter O with macron'},
{code:'U+014E',char:'Ŏ',description:'Latin Capital Letter O with breve'},
{code:'U+014F',char:'ŏ',description:'Latin Small Letter O with breve'},
{code:'U+0150',char:'Ő',description:'Latin Capital Letter O with double acute'},
{code:'U+0151',char:'ő',description:'Latin Small Letter O with double acute'},
{code:'U+0152',char:'Œ',description:'Latin Capital Ligature OE'},
{code:'U+0153',char:'œ',description:'Latin Small Ligature OE'},
{code:'U+0154',char:'Ŕ',description:'Latin Capital Letter R with acute'},
{code:'U+0155',char:'ŕ',description:'Latin Small Letter R with acute'},
{code:'U+0156',char:'Ŗ',description:'Latin Capital Letter R with cedilla'},
{code:'U+0157',char:'ŗ',description:'Latin Small Letter R with cedilla'},
{code:'U+0158',char:'Ř',description:'Latin Capital Letter R with caron'},
{code:'U+0159',char:'ř',description:'Latin Small Letter R with caron'},
{code:'U+015A',char:'Ś',description:'Latin Capital Letter S with acute'},
{code:'U+015B',char:'ś',description:'Latin Small Letter S with acute'},
{code:'U+015C',char:'Ŝ',description:'Latin Capital Letter S with circumflex'},
{code:'U+015D',char:'ŝ',description:'Latin Small Letter S with circumflex'},
{code:'U+015E',char:'Ş',description:'Latin Capital Letter S with cedilla'},
{code:'U+015F',char:'ş',description:'Latin Small Letter S with cedilla'},
{code:'U+0160',char:'Š',description:'Latin Capital Letter S with caron'},
{code:'U+0161',char:'š',description:'Latin Small Letter S with caron'},
{code:'U+0162',char:'Ţ',description:'Latin Capital Letter T with cedilla'},
{code:'U+0163',char:'ţ',description:'Latin Small Letter T with cedilla'},
{code:'U+0164',char:'Ť',description:'Latin Capital Letter T with caron'},
{code:'U+0165',char:'ť',description:'Latin Small Letter T with caron'},
{code:'U+0166',char:'Ŧ',description:'Latin Capital Letter T with stroke'},
{code:'U+0167',char:'ŧ',description:'Latin Small Letter T with stroke'},
{code:'U+0168',char:'Ũ',description:'Latin Capital Letter U with tilde'},
{code:'U+0169',char:'ũ',description:'Latin Small Letter U with tilde'},
{code:'U+016A',char:'Ū',description:'Latin Capital Letter U with macron'},
{code:'U+016B',char:'ū',description:'Latin Small Letter U with macron'},
{code:'U+016C',char:'Ŭ',description:'Latin Capital Letter U with breve'},
{code:'U+016D',char:'ŭ',description:'Latin Small Letter U with breve'},
{code:'U+016E',char:'Ů',description:'Latin Capital Letter U with ring above'},
{code:'U+016F',char:'ů',description:'Latin Small Letter U with ring above'},
{code:'U+0170',char:'Ű',description:'Latin Capital Letter U with double acute'},
{code:'U+0171',char:'ű',description:'Latin Small Letter U with double acute'},
{code:'U+0172',char:'Ų',description:'Latin Capital Letter U with ogonek'},
{code:'U+0173',char:'ų',description:'Latin Small Letter U with ogonek'},
{code:'U+0174',char:'Ŵ',description:'Latin Capital Letter W with circumflex'},
{code:'U+0175',char:'ŵ',description:'Latin Small Letter W with circumflex'},
{code:'U+0176',char:'Ŷ',description:'Latin Capital Letter Y with circumflex'},
{code:'U+0177',char:'ŷ',description:'Latin Small Letter Y with circumflex'},
{code:'U+0178',char:'Ÿ',description:'Latin Capital Letter Y with diaeresis'},
{code:'U+0179',char:'Ź',description:'Latin Capital Letter Z with acute'},
{code:'U+017A',char:'ź',description:'Latin Small Letter Z with acute'},
{code:'U+017B',char:'Ż',description:'Latin Capital Letter Z with dot above'},
{code:'U+017C',char:'ż',description:'Latin Small Letter Z with dot above'},
{code:'U+017D',char:'Ž',description:'Latin Capital Letter Z with caron'},
{code:'U+017E',char:'ž',description:'Latin Small Letter Z with caron'},
{code:'U+017F',char:'ſ',description:'Latin Small Letter long S'},
];

var latin_extended_b = [
{code:'U+01EA',char:'Ǫ',description:'Latin Capital Letter O with ogonek'},
{code:'U+01EB',char:'ǫ',description:'Latin Small Letter O with ogonek'},
]
/**************************************************************************************/

var cyrillic = [
{description:'CYRILLIC  CAPITAL LETTER IE WITH GRAVE',char:'Ѐ',code:'&#x0400'},
{description:'CYRILLIC  CAPITAL LETTER IO',char:'Ё',code:'&#x0401'},
{description:'CYRILLIC  CAPITAL LETTER DJE (Serbocroatian)',char:'Ђ',code:'&#x0402'},
{description:'CYRILLIC  CAPITAL LETTER GJE',char:'Ѓ',code:'&#x0403'},
{description:'CYRILLIC  CAPITAL LETTER UKRAINIAN IE',char:'Є',code:'&#x0404'},
{description:'CYRILLIC  CAPITAL LETTER DZE',char:'Ѕ',code:'&#x0405'},
{description:'CYRILLIC  CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I',char:'І',code:'&#x0406'},
{description:'CYRILLIC  CAPITAL LETTER YI (Ukrainian)',char:'Ї',code:'&#x0407'},
{description:'CYRILLIC  CAPITAL LETTER JE',char:'Ј',code:'&#x0408'},
{description:'CYRILLIC  CAPITAL LETTER LJE',char:'Љ',code:'&#x0409'},
{description:'CYRILLIC  CAPITAL LETTER NJE',char:'Њ',code:'&#x040A'},
{description:'CYRILLIC  CAPITAL LETTER TSHE (Serbocroatian)',char:'Ћ',code:'&#x040B'},
{description:'CYRILLIC  CAPITAL LETTER KJE',char:'Ќ',code:'&#x040C'},
{description:'CYRILLIC  CAPITAL LETTER I WITH GRAVE',char:'Ѝ',code:'&#x040D'},
{description:'CYRILLIC  CAPITAL LETTER SHORT U (Byelorussian)',char:'Ў',code:'&#x040E'},
{description:'CYRILLIC  CAPITAL LETTER DZHE',char:'Џ',code:'&#x040F'},
{description:'CYRILLIC  CAPITAL LETTER A',char:'А',code:'&#x0410'},
{description:'CYRILLIC  CAPITAL LETTER BE',char:'Б',code:'&#x0411'},
{description:'CYRILLIC  CAPITAL LETTER VE',char:'В',code:'&#x0412'},
{description:'CYRILLIC  CAPITAL LETTER GHE',char:'Г',code:'&#x0413'},
{description:'CYRILLIC  CAPITAL LETTER DE',char:'Д',code:'&#x0414'},
{description:'CYRILLIC  CAPITAL LETTER IE',char:'Е',code:'&#x0415'},
{description:'CYRILLIC  CAPITAL LETTER ZHE',char:'Ж',code:'&#x0416'},
{description:'CYRILLIC  CAPITAL LETTER ZE',char:'З',code:'&#x0417'},
{description:'CYRILLIC  CAPITAL LETTER I',char:'И',code:'&#x0418'},
{description:'CYRILLIC  CAPITAL LETTER SHORT I',char:'Й',code:'&#x0419'},
{description:'CYRILLIC  CAPITAL LETTER KA',char:'К',code:'&#x041A'},
{description:'CYRILLIC  CAPITAL LETTER EL',char:'Л',code:'&#x041B'},
{description:'CYRILLIC  CAPITAL LETTER EM',char:'М',code:'&#x041C'},
{description:'CYRILLIC  CAPITAL LETTER EN',char:'Н',code:'&#x041D'},
{description:'CYRILLIC  CAPITAL LETTER O',char:'О',code:'&#x041E'},
{description:'CYRILLIC  CAPITAL LETTER PE',char:'П',code:'&#x041F'},
{description:'CYRILLIC  CAPITAL LETTER ER',char:'Р',code:'&#x0420'},
{description:'CYRILLIC  CAPITAL LETTER ES',char:'С',code:'&#x0421'},
{description:'CYRILLIC  CAPITAL LETTER TE',char:'Т',code:'&#x0422'},
{description:'CYRILLIC  CAPITAL LETTER U',char:'У',code:'&#x0423'},
{description:'CYRILLIC  CAPITAL LETTER EF',char:'Ф',code:'&#x0424'},
{description:'CYRILLIC  CAPITAL LETTER HA',char:'Х',code:'&#x0425'},
{description:'CYRILLIC  CAPITAL LETTER TSE',char:'Ц',code:'&#x0426'},
{description:'CYRILLIC  CAPITAL LETTER CHE',char:'Ч',code:'&#x0427'},
{description:'CYRILLIC  CAPITAL LETTER SHA',char:'Ш',code:'&#x0428'},
{description:'CYRILLIC  CAPITAL LETTER SHCHA',char:'Щ',code:'&#x0429'},
{description:'CYRILLIC  CAPITAL LETTER HARD SIGN',char:'Ъ',code:'&#x042A'},
{description:'CYRILLIC  CAPITAL LETTER YERU',char:'Ы',code:'&#x042B'},
{description:'CYRILLIC  CAPITAL LETTER SOFT SIGN',char:'Ь',code:'&#x042C'},
{description:'CYRILLIC  CAPITAL LETTER E',char:'Э',code:'&#x042D'},
{description:'CYRILLIC  CAPITAL LETTER YU',char:'Ю',code:'&#x042E'},
{description:'CYRILLIC  CAPITAL LETTER YA',char:'Я',code:'&#x042F'},
{description:'CYRILLIC  SMALL LETTER A',char:'а',code:'&#x0430'},
{description:'CYRILLIC  SMALL LETTER BE',char:'б',code:'&#x0431'},
{description:'CYRILLIC  SMALL LETTER VE',char:'в',code:'&#x0432'},
{description:'CYRILLIC  SMALL LETTER GHE',char:'г',code:'&#x0433'},
{description:'CYRILLIC  SMALL LETTER DE',char:'д',code:'&#x0434'},
{description:'CYRILLIC  SMALL LETTER IE',char:'е',code:'&#x0435'},
{description:'CYRILLIC  SMALL LETTER ZHE',char:'ж',code:'&#x0436'},
{description:'CYRILLIC  SMALL LETTER ZE',char:'з',code:'&#x0437'},
{description:'CYRILLIC  SMALL LETTER I',char:'и',code:'&#x0438'},
{description:'CYRILLIC  SMALL LETTER SHORT I',char:'й',code:'&#x0439'},
{description:'CYRILLIC  SMALL LETTER KA',char:'к',code:'&#x043A'},
{description:'CYRILLIC  SMALL LETTER EL',char:'л',code:'&#x043B'},
{description:'CYRILLIC  SMALL LETTER EM',char:'м',code:'&#x043C'},
{description:'CYRILLIC  SMALL LETTER EN',char:'н',code:'&#x043D'},
{description:'CYRILLIC  SMALL LETTER O',char:'о',code:'&#x043E'},
{description:'CYRILLIC  SMALL LETTER PE',char:'п',code:'&#x043F'},
{description:'CYRILLIC  SMALL LETTER ER',char:'р',code:'&#x0440'},
{description:'CYRILLIC  SMALL LETTER ES',char:'с',code:'&#x0441'},
{description:'CYRILLIC  SMALL LETTER TE',char:'т',code:'&#x0442'},
{description:'CYRILLIC  SMALL LETTER U',char:'у',code:'&#x0443'},
{description:'CYRILLIC  SMALL LETTER EF',char:'ф',code:'&#x0444'},
{description:'CYRILLIC  SMALL LETTER HA',char:'х',code:'&#x0445'},
{description:'CYRILLIC  SMALL LETTER TSE',char:'ц',code:'&#x0446'},
{description:'CYRILLIC  SMALL LETTER CHE',char:'ч',code:'&#x0447'},
{description:'CYRILLIC  SMALL LETTER SHA',char:'ш',code:'&#x0448'},
{description:'CYRILLIC  SMALL LETTER SHCHA',char:'щ',code:'&#x0449'},
{description:'CYRILLIC  SMALL LETTER HARD SIGN',char:'ъ',code:'&#x044A'},
{description:'CYRILLIC  SMALL LETTER YERU',char:'ы',code:'&#x044B'},
{description:'CYRILLIC  SMALL LETTER SOFT SIGN',char:'ь',code:'&#x044C'},
{description:'CYRILLIC  SMALL LETTER E',char:'э',code:'&#x044D'},
{description:'CYRILLIC  SMALL LETTER YU',char:'ю',code:'&#x044E'},
{description:'CYRILLIC  SMALL LETTER YA',char:'я',code:'&#x044F'},
{description:'CYRILLIC  CAPITAL LETTER IE WITH GRAVE',char:'Ѐ',code:'&#x0400'},
{description:'CYRILLIC  CAPITAL LETTER IO',char:'Ё',code:'&#x0401'},
{description:'CYRILLIC  CAPITAL LETTER DJE (Serbocroatian)',char:'Ђ',code:'&#x0402'},
{description:'CYRILLIC  CAPITAL LETTER GJE',char:'Ѓ',code:'&#x0403'},
{description:'CYRILLIC  CAPITAL LETTER UKRAINIAN IE',char:'Є',code:'&#x0404'},
{description:'CYRILLIC  CAPITAL LETTER DZE',char:'Ѕ',code:'&#x0405'},
{description:'CYRILLIC  CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I',char:'І',code:'&#x0406'},
{description:'CYRILLIC  CAPITAL LETTER YI (Ukrainian)',char:'Ї',code:'&#x0407'},
{description:'CYRILLIC  CAPITAL LETTER JE',char:'Ј',code:'&#x0408'},
{description:'CYRILLIC  CAPITAL LETTER LJE',char:'Љ',code:'&#x0409'},
{description:'CYRILLIC  CAPITAL LETTER NJE',char:'Њ',code:'&#x040A'},
{description:'CYRILLIC  CAPITAL LETTER TSHE (Serbocroatian)',char:'Ћ',code:'&#x040B'},
{description:'CYRILLIC  CAPITAL LETTER KJE',char:'Ќ',code:'&#x040C'},
{description:'CYRILLIC  CAPITAL LETTER I WITH GRAVE',char:'Ѝ',code:'&#x040D'},
{description:'CYRILLIC  CAPITAL LETTER SHORT U (Byelorussian)',char:'Ў',code:'&#x040E'},
{description:'CYRILLIC  CAPITAL LETTER DZHE',char:'Џ',code:'&#x040F'},
{description:'CYRILLIC  SMALL LETTER IE WITH GRAVE',char:'ѐ',code:'&#x0450'},
{description:'CYRILLIC  SMALL LETTER IO',char:'ё',code:'&#x0451'},
{description:'CYRILLIC  SMALL LETTER DJE (Serbocroatian)',char:'ђ',code:'&#x0452'},
{description:'CYRILLIC  SMALL LETTER GJE',char:'ѓ',code:'&#x0453'},
{description:'CYRILLIC  SMALL LETTER UKRAINIAN IE',char:'є',code:'&#x0454'},
{description:'CYRILLIC  SMALL LETTER DZE',char:'ѕ',code:'&#x0455'},
{description:'CYRILLIC  SMALL LETTER BYELORUSSIAN-UKRAINIAN I',char:'і',code:'&#x0456'},
{description:'CYRILLIC  SMALL LETTER YI (Ukrainian)',char:'ї',code:'&#x0457'},
{description:'CYRILLIC  SMALL LETTER JE',char:'ј',code:'&#x0458'},
{description:'CYRILLIC  SMALL LETTER LJE',char:'љ',code:'&#x0459'},
{description:'CYRILLIC  SMALL LETTER NJE',char:'њ',code:'&#x045A'},
{description:'CYRILLIC  SMALL LETTER TSHE (Serbocroatian)',char:'ћ',code:'&#x045B'},
{description:'CYRILLIC  SMALL LETTER KJE',char:'ќ',code:'&#x045C'},
{description:'CYRILLIC  SMALL LETTER I WITH GRAVE',char:'ѝ',code:'&#x045D'},
{description:'CYRILLIC  SMALL LETTER SHORT U (Byelorussian)',char:'ў',code:'&#x045E'},
{description:'CYRILLIC  SMALL LETTER DZHE',char:'џ',code:'&#x045F'},
{description:'CYRILLIC  CAPITAL LETTER OMEGA',char:'Ѡ',code:'&#x0460'},
{description:'CYRILLIC  SMALL LETTER OMEGA',char:'ѡ',code:'&#x0461'},
{description:'CYRILLIC  CAPITAL LETTER YAT',char:'Ѣ',code:'&#x0462'},
{description:'CYRILLIC  SMALL LETTER YAT',char:'ѣ',code:'&#x0463'},
{description:'CYRILLIC  CAPITAL LETTER IOTIFIED E',char:'Ѥ',code:'&#x0464'},
{description:'CYRILLIC  SMALL LETTER IOTIFIED E',char:'ѥ',code:'&#x0465'},
{description:'CYRILLIC  CAPITAL LETTER LITTLE YUS',char:'Ѧ',code:'&#x0466'},
{description:'CYRILLIC  SMALL LETTER LITTLE YUS',char:'ѧ',code:'&#x0467'},
{description:'CYRILLIC  CAPITAL LETTER IOTIFIED LITTLE YUS',char:'Ѩ',code:'&#x0468'},
{description:'CYRILLIC  SMALL LETTER IOTIFIED LITTLE YUS',char:'ѩ',code:'&#x0469'},
{description:'CYRILLIC  CAPITAL LETTER BIG YUS',char:'Ѫ',code:'&#x046A'},
{description:'CYRILLIC  SMALL LETTER BIG YUS',char:'ѫ',code:'&#x046B'},
{description:'CYRILLIC  CAPITAL LETTER IOTIFIED BIG YUS',char:'Ѭ',code:'&#x046C'},
{description:'CYRILLIC  SMALL LETTER IOTIFIED BIG YUS',char:'ѭ',code:'&#x046D'},
{description:'CYRILLIC  CAPITAL LETTER KSI',char:'Ѯ',code:'&#x046E'},
{description:'CYRILLIC  SMALL LETTER KSI',char:'ѯ',code:'&#x046F'},
{description:'CYRILLIC  CAPITAL LETTER PSI',char:'Ѱ',code:'&#x0470'},
{description:'CYRILLIC  SMALL LETTER PSI',char:'ѱ',code:'&#x0471'},
{description:'CYRILLIC  CAPITAL LETTER FITA',char:'Ѳ',code:'&#x0472'},
{description:'CYRILLIC  SMALL LETTER FITA',char:'ѳ',code:'&#x0473'},
{description:'CYRILLIC  CAPITAL LETTER IZHITSA',char:'Ѵ',code:'&#x0474'},
{description:'CYRILLIC  SMALL LETTER IZHITSA',char:'ѵ',code:'&#x0475'},
{description:'CYRILLIC  CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT',char:'Ѷ',code:'&#x0476'},
{description:'CYRILLIC  SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT',char:'ѷ',code:'&#x0477'},
{description:'CYRILLIC  CAPITAL LETTER UK',char:'Ѹ',code:'&#x0478'},
{description:'CYRILLIC  SMALL LETTER UK',char:'ѹ',code:'&#x0479'},
{description:'CYRILLIC  CAPITAL LETTER ROUND OMEGA',char:'Ѻ',code:'&#x047A'},
{description:'CYRILLIC  SMALL LETTER ROUND OMEGA',char:'ѻ',code:'&#x047B'},
{description:'CYRILLIC  CAPITAL LETTER OMEGA WITH TITLO',char:'Ѽ',code:'&#x047C'},
{description:'CYRILLIC  SMALL LETTER OMEGA WITH TITLO',char:'ѽ',code:'&#x047D'},
{description:'CYRILLIC  CAPITAL LETTER OT',char:'Ѿ',code:'&#x047E'},
{description:'CYRILLIC  SMALL LETTER OT',char:'ѿ',code:'&#x047F'},
{description:'CYRILLIC  CAPITAL LETTER KOPPA',char:'Ҁ',code:'&#x0480'},
{description:'CYRILLIC  SMALL LETTER KOPPA',char:'ҁ',code:'&#x0481'},
{description:'CYRILLIC  THOUSANDS SIGN',char:'҂',code:'&#x0482'},
{description:'COMBINING CYRILLIC TITLO',char:'҃',code:'&#x0483 '},
{description:'COMBINING CYRILLIC PALATALIZATION',char:'҄',code:'&#x0484 '},
{description:'COMBINING CYRILLIC DASIA PNEUMATA',char:'҅',code:'&#x0485 '},
{description:'COMBINING CYRILLIC PSILI PNEUMATA',char:'҆',code:'&#x0486 '},
{description:'COMBINING CYRILLIC HUNDRED THOUSANDS SIGN',char:'҈',code:'&#x0488 '},
{description:'COMBINING CYRILLIC MILLIONS SIGN',char:'҉',code:'&#x0489 '},
]

var  cyrillic_extended_a = [
{char:'ⷠ',code:'2DE0',description:'COMBINING CYRILLIC LETTER BE (combined with o (о))'},
{char:'ⷡ',code:'2DE1',description:'COMBINING CYRILLIC LETTER VE (combined with o (о))'},
{char:'ⷢ',code:'2DE2',description:'COMBINING CYRILLIC LETTER GHE (combined with o (о))'},
{char:'ⷣ',code:'2DE3',description:'COMBINING CYRILLIC LETTER DE (combined with o (о))'},
{char:'ⷤ',code:'2DE4',description:'COMBINING CYRILLIC LETTER ZHE (combined with o (о))'},
{char:'ⷥ',code:'2DE5',description:'COMBINING CYRILLIC LETTER ZE (combined with o (о))'},
{char:'ⷦ',code:'2DE6',description:'COMBINING CYRILLIC LETTER KA (combined with o (о))'},
{char:'ⷧ',code:'2DE7',description:'COMBINING CYRILLIC LETTER EL (combined with o (о))'},
{char:'ⷨ',code:'2DE8',description:'COMBINING CYRILLIC LETTER EM (combined with o (о))'},
{char:'ⷩ',code:'2DE9',description:'COMBINING CYRILLIC LETTER EN (combined with o (о))'},
{char:'ⷪ',code:'2DEA',description:'COMBINING CYRILLIC LETTER O (combined with o (о))'},
{char:'ⷫ',code:'2DEB',description:'COMBINING CYRILLIC LETTER PE (combined with o (о))'},
{char:'ⷬ',code:'2DEC',description:'COMBINING CYRILLIC LETTER ER (combined with o (о))'},
{char:'ⷭ',code:'2DED',description:'COMBINING CYRILLIC LETTER ES (combined with o (о))'},
{char:'ⷮ',code:'2DEE',description:'COMBINING CYRILLIC LETTER TE (combined with o (о))'},
{char:'ⷯ',code:'2DEF',description:'COMBINING CYRILLIC LETTER HA (combined with o (о))'},
{char:'ⷰ',code:'2DF0',description:'COMBINING CYRILLIC LETTER TSE (combined with o (о))'},
{char:'ⷱ',code:'2DF1',description:'COMBINING CYRILLIC LETTER CHE (combined with o (о))'},
{char:'ⷲ',code:'2DF2',description:'COMBINING CYRILLIC LETTER SHA (combined with o (о))'},
{char:'ⷳ',code:'2DF3',description:'COMBINING CYRILLIC LETTER SHCHA (combined with o (о))'},
{char:'ⷴ',code:'2DF4',description:'COMBINING CYRILLIC LETTER FITA (combined with o (о))'},
{char:'ⷵ',code:'2DF5',description:'COMBINING CYRILLIC LETTER ES-TE (combined with o (о))'},
{char:'ⷶ',code:'2DF6',description:'COMBINING CYRILLIC LETTER A (combined with o (о))'},
{char:'ⷷ',code:'2DF7',description:'COMBINING CYRILLIC LETTER IE (combined with o (о))'},
{char:'ⷸ',code:'2DF8',description:'COMBINING CYRILLIC LETTER DJERV (combined with o (о))'},
{char:'ⷹ',code:'2DF9',description:'COMBINING CYRILLIC LETTER MONOGRAPH UK (combined with o (о))'},
{char:'ⷺ',code:'2DFA',description:'COMBINING CYRILLIC LETTER YAT (combined with o (о))'},
{char:'ⷻ',code:'2DFB',description:'COMBINING CYRILLIC LETTER YU (combined with o (о))'},
{char:'ⷼ',code:'2DFC',description:'COMBINING CYRILLIC LETTER IOTIFIED A (combined with o (о))'},
{char:'ⷽ',code:'2DFD',description:'COMBINING CYRILLIC LETTER LITTLE YUS (combined with o (о))'},
{char:'ⷾ',code:'2DFE',description:'COMBINING CYRILLIC LETTER BIG YUS (combined with o (о))'},
{char:'ⷿ',code:'2DFF',description:'COMBINING CYRILLIC LETTER IOTIFIED BIG YUS (combined with o (о))'},
];

var  cyrillic_extended_b = [
{char:'Ꙁ',code:'A640',description:'CYRILLIC CAPITAL LETTER ZEMLYA'},
{char:'ꙁ',code:'A641',description:'CYRILLIC SMALL LETTER ZEMLYA'},
{char:'Ꙃ',code:'A642',description:'CYRILLIC CAPITAL LETTER DZELO'},
{char:'ꙃ',code:'A643',description:'CYRILLIC SMALL LETTER DZELO'},
{char:'Ꙅ',code:'A644',description:'CYRILLIC CAPITAL LETTER REVERSED DZE'},
{char:'ꙅ',code:'A645',description:'CYRILLIC SMALL LETTER REVERSED DZE'},
{char:'Ꙇ',code:'A646',description:'CYRILLIC CAPITAL LETTER IOTA'},
{char:'ꙇ',code:'A647',description:'CYRILLIC SMALL LETTER IOTA'},
{char:'Ꙉ',code:'A648',description:'CYRILLIC CAPITAL LETTER DJERV'},
{char:'ꙉ',code:'A649',description:'CYRILLIC SMALL LETTER DJERV'},
{char:'Ꙋ',code:'A64A',description:'CYRILLIC CAPITAL LETTER MONOGRAPH UK'},
{char:'ꙋ',code:'A64B',description:'CYRILLIC SMALL LETTER MONOGRAPH UK'},
{char:'Ꙍ',code:'A64C',description:'CYRILLIC CAPITAL LETTER BROAD OMEGA'},
{char:'ꙍ',code:'A64D',description:'CYRILLIC SMALL LETTER BROAD OMEGA'},
{char:'Ꙏ',code:'A64E',description:'CYRILLIC CAPITAL LETTER NEUTRAL YER'},
{char:'ꙏ',code:'A64F',description:'CYRILLIC SMALL LETTER NEUTRAL YER'},
{char:'Ꙑ',code:'A650',description:'CYRILLIC CAPITAL LETTER YERU WITH BACK YER'},
{char:'ꙑ',code:'A651',description:'CYRILLIC SMALL LETTER YERU WITH BACK YER'},
{char:'Ꙓ',code:'A652',description:'CYRILLIC CAPITAL LETTER IOTIFIED YAT'},
{char:'ꙓ',code:'A653',description:'CYRILLIC SMALL LETTER IOTIFIED YAT'},
{char:'Ꙕ',code:'A654',description:'CYRILLIC CAPITAL LETTER REVERSED YU'},
{char:'ꙕ',code:'A655',description:'CYRILLIC SMALL LETTER REVERSED YU'},
{char:'Ꙗ',code:'A656',description:'CYRILLIC CAPITAL LETTER IOTIFIED A'},
{char:'ꙗ',code:'A657',description:'CYRILLIC SMALL LETTER IOTIFIED A'},
{char:'Ꙙ',code:'A658',description:'CYRILLIC CAPITAL LETTER CLOSED LITTLE YUS'},
{char:'ꙙ',code:'A659',description:'CYRILLIC SMALL LETTER CLOSED LITTLE YUS'},
{char:'Ꙛ',code:'A65A',description:'CYRILLIC CAPITAL LETTER BLENDED YUS'},
{char:'ꙛ',code:'A65B',description:'CYRILLIC SMALL LETTER BLENDED YUS'},
{char:'Ꙝ',code:'A65C',description:'CYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUS'},
{char:'ꙝ',code:'A65D',description:'CYRILLIC SMALL LETTER IOTIFIED CLOSED LITTLE YUS'},
{char:'Ꙟ',code:'A65E',description:'CYRILLIC CAPITAL LETTER YN'},
{char:'ꙟ',code:'A65F',description:'CYRILLIC SMALL LETTER YN'},
{char:'Ꙡ',code:'A660',description:'CYRILLIC CAPITAL LETTER REVERSED TSE'},
{char:'ꙡ',code:'A661',description:'CYRILLIC SMALL LETTER REVERSED TSE'},
{char:'Ꙣ',code:'A662',description:'CYRILLIC CAPITAL LETTER SOFT DE'},
{char:'ꙣ',code:'A663',description:'CYRILLIC SMALL LETTER SOFT DE'},
{char:'Ꙥ',code:'A664',description:'CYRILLIC CAPITAL LETTER SOFT EL'},
{char:'ꙥ',code:'A665',description:'CYRILLIC SMALL LETTER SOFT EL'},
{char:'Ꙧ',code:'A666',description:'CYRILLIC CAPITAL LETTER SOFT EM'},
{char:'ꙧ',code:'A667',description:'CYRILLIC SMALL LETTER SOFT EM'},
{char:'Ꙩ',code:'A668',description:'CYRILLIC CAPITAL LETTER MONOCULAR O'},
{char:'ꙩ',code:'A669',description:'CYRILLIC SMALL LETTER MONOCULAR O'},
{char:'Ꙫ',code:'A66A',description:'CYRILLIC CAPITAL LETTER BINOCULAR O'},
{char:'ꙫ',code:'A66B',description:'CYRILLIC SMALL LETTER BINOCULAR O'},
{char:'Ꙭ',code:'A66C',description:'CYRILLIC CAPITAL LETTER DOUBLE MONOCULAR O'},
{char:'ꙭ',code:'A66D',description:'CYRILLIC SMALL LETTER DOUBLE MONOCULAR O'},
{char:'ꙮ',code:'A66E',description:'CYRILLIC LETTER MULTIOCULAR O'},
{char:'꙯',code:'A66F',description:'COMBINING CYRILLIC VZMET (combined with o (о))'},
{char:'꙰',code:'A670',description:'COMBINING CYRILLIC TEN MILLIONS SIGN (combined with o (о))'},
{char:'꙱',code:'A671',description:'COMBINING CYRILLIC HUNDRED MILLIONS SIGN (combined with o (о))'},
{char:'꙲',code:'A672',description:'COMBINING CYRILLIC THOUSAND MILLIONS SIGN (combined with o (о))'},
{char:'꙳',code:'A673',description:'SLAVONIC ASTERISK'},
{char:'ꙴ',code:'A674',description:'COMBINING CYRILLIC LETTER UKRAINIAN IE (combined with o (о))'},
{char:'ꙵ',code:'A675',description:'COMBINING CYRILLIC LETTER I (combined with o (о))'},
{char:'ꙶ',code:'A676',description:'COMBINING CYRILLIC LETTER YI (combined with o (о))'},
{char:'ꙷ',code:'A677',description:'COMBINING CYRILLIC LETTER U (combined with o (о))'},
{char:'ꙸ',code:'A678',description:'COMBINING CYRILLIC LETTER HARD SIGN (combined with o (о))'},
{char:'ꙹ',code:'A679',description:'COMBINING CYRILLIC LETTER YERU (combined with o (о))'},
{char:'ꙺ',code:'A67A',description:'COMBINING CYRILLIC LETTER SOFT SIGN (combined with o (о))'},
{char:'ꙻ',code:'A67B',description:'COMBINING CYRILLIC LETTER OMEGA (combined with o (о))'},
{char:'꙼',code:'A67C',description:'COMBINING CYRILLIC KAVYKA (combined with o (о))'},
{char:'꙽',code:'A67D',description:'COMBINING CYRILLIC PAYEROK (combined with o (о))'},
{char:'꙾',code:'A67E',description:'CYRILLIC KAVYKA'},
{char:'ꙿ',code:'A67F',description:'CYRILLIC PAYEROK'},
{char:'ꚜ',code:'A69C',description:'MODIFIER LETTER CYRILLIC HARD SIGN'},
{char:'ꚝ',code:'A69D',description:'MODIFIER LETTER CYRILLIC SOFT SIGN'},
{char:'ꚟ',code:'A69F',description:'COMBINING CYRILLIC LETTER IOTIFIED E (combined with o (о))'},
]



/************************************************************************************/

var greek_and_coptic = [
{char:'Ͱ',code:'0370',description:'GREEK CAPITAL LETTER HETATry it'},
{char:'ͱ',code:'0371',description:'GREEK SMALL LETTER HETATry it'},
{char:'Ͳ',code:'0372',description:'GREEK CAPITAL LETTER	ARCHAIC SAMPITry it'},
{char:'ͳ',code:'0373',description:'GREEK SMALL LETTER ARCHAIC SAMPITry it'},
{char:'ʹ',code:'0374',description:'GREEK NUMERAL SIGNTry it'},
{char:'͵',code:'0375',description:'GREEK LOWER NUMERAL SIGNTry it'},
{char:'Ͷ',code:'0376',description:'GREEK CAPITAL LETTER	PAMPHYLIAN DIGAMMATry it'},
{char:'ͷ',code:'0377',description:'GREEK SMALL LETTER PAMPHYLIAN DIGAMMATry it'},
{char:'ͺ',code:'037A',description:'GREEK YPOGEGRAMMENITry it'},
{char:'ͻ',code:'037B',description:'GREEK SMALL REVERSED LUNATE SIGMA SYMBOLTry it'},
{char:'ͼ',code:'037C',description:'GREEK SMALL DOTTED LUNATE SIGMA SYMBOLTry it'},
{char:'ͽ',code:'037D',description:'GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOLTry it'},
{char:';',code:'037E',description:'GREEK QUESTION MARKTry it'},
{char:'΄',code:'0384',description:'GREEK TONOSTry it'},
{char:'΅',code:'0385',description:'GREEK DIALYTIKA TONOSTry it'},
{char:'Ά',code:'0386',description:'GREEK CAPITAL LETTER ALPHA WITH TONOSTry it'},
{char:'·',code:'0387',description:'GREEK ANO TELEIATry it'},
{char:'Έ',code:'0388',description:'GREEK CAPITAL LETTER	EPSILON WITH TONOSTry it'},
{char:'Ή',code:'0389',description:'GREEK CAPITAL LETTER ETA WITH TONOSTry it'},
{char:'Ί',code:'038A',description:'GREEK CAPITAL LETTER IOTA WITH TONOSTry it'},
{char:'Ό',code:'038C',description:'GREEK CAPITAL LETTER OMICRON WITH TONOSTry it'},
{char:'Ύ',code:'038E',description:'GREEK CAPITAL LETTER UPSILON WITH TONOSTry it'},
{char:'Ώ',code:'038F',description:'GREEK CAPITAL LETTER OMEGA WITH TONOSTry it'},
{char:'ΐ',code:'0390',description:'GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOSTry it'},
{char:'Α',code:'0391',description:'GREEK CAPITAL LETTER ALPHATry it'},
{char:'Β',code:'0392',description:'GREEK CAPITAL LETTER BETATry it'},
{char:'Γ',code:'0393',description:'GREEK CAPITAL LETTER GAMMATry it'},
{char:'Δ',code:'0394',description:'GREEK CAPITAL LETTER DELTATry it'},
{char:'Ε',code:'0395',description:'GREEK CAPITAL LETTER EPSILONTry it'},
{char:'Ζ',code:'0396',description:'GREEK CAPITAL LETTER ZETATry it'},
{char:'Η',code:'0397',description:'GREEK CAPITAL LETTER ETATry it'},
{char:'Θ',code:'0398',description:'GREEK CAPITAL LETTER THETATry it'},
{char:'Ι',code:'0399',description:'GREEK CAPITAL LETTER IOTATry it'},
{char:'Κ',code:'039A',description:'GREEK CAPITAL LETTER KAPPATry it'},
{char:'Λ',code:'039B',description:'GREEK CAPITAL LETTER LAMBDATry it'},
{char:'Μ',code:'039C',description:'GREEK CAPITAL LETTER MUTry it'},
{char:'Ν',code:'039D',description:'GREEK CAPITAL LETTER NUTry it'},
{char:'Ξ',code:'039E',description:'GREEK CAPITAL LETTER XITry it'},
{char:'Ο',code:'039F',description:'GREEK CAPITAL LETTER OMICRONTry it'},
{char:'Π',code:'03A0',description:'GREEK CAPITAL LETTER PITry it'},
{char:'Ρ',code:'03A1',description:'GREEK CAPITAL LETTER RHOTry it'},
{char:'Σ',code:'03A3',description:'GREEK CAPITAL LETTER SIGMATry it'},
{char:'Τ',code:'03A4',description:'GREEK CAPITAL LETTER TAUTry it'},
{char:'Υ',code:'03A5',description:'GREEK CAPITAL LETTER UPSILONTry it'},
{char:'Φ',code:'03A6',description:'GREEK CAPITAL LETTER PHITry it'},
{char:'Χ',code:'03A7',description:'GREEK CAPITAL LETTER CHITry it'},
{char:'Ψ',code:'03A8',description:'GREEK CAPITAL LETTER PSITry it'},
{char:'Ω',code:'03A9',description:'GREEK CAPITAL LETTER OMEGATry it'},
{char:'Ϊ',code:'03AA',description:'GREEK CAPITAL LETTER IOTA WITH DIALYTIKATry it'},
{char:'Ϋ',code:'03AB',description:'GREEK CAPITAL LETTER UPSILON WITH DIALYTIKATry it'},
{char:'ά',code:'03AC',description:'GREEK SMALL LETTER ALPHA WITH TONOSTry it'},
{char:'έ',code:'03AD',description:'GREEK SMALL LETTER EPSILON WITH TONOSTry it'},
{char:'ή',code:'03AE',description:'GREEK SMALL LETTER ETA WITH TONOSTry it'},
{char:'ί',code:'03AF',description:'GREEK SMALL LETTER IOTA WITH TONOSTry it'},
{char:'ΰ',code:'03B0',description:'GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOSTry it'},
{char:'α',code:'03B1',description:'GREEK SMALL LETTER ALPHATry it'},
{char:'β',code:'03B2',description:'GREEK SMALL LETTER BETATry it'},
{char:'γ',code:'03B3',description:'GREEK SMALL LETTER GAMMATry it'},
{char:'δ',code:'03B4',description:'GREEK SMALL LETTER DELTATry it'},
{char:'ε',code:'03B5',description:'GREEK SMALL LETTER EPSILONTry it'},
{char:'ζ',code:'03B6',description:'GREEK SMALL LETTER ZETATry it'},
{char:'η',code:'03B7',description:'GREEK SMALL LETTER ETATry it'},
{char:'θ',code:'03B8',description:'GREEK SMALL LETTER THETATry it'},
{char:'ι',code:'03B9',description:'GREEK SMALL LETTER IOTATry it'},
{char:'κ',code:'03BA',description:'GREEK SMALL LETTER KAPPATry it'},
{char:'λ',code:'03BB',description:'GREEK SMALL LETTER LAMBDATry it'},
{char:'μ',code:'03BC',description:'GREEK SMALL LETTER MUTry it'},
{char:'ν',code:'03BD',description:'GREEK SMALL LETTER NUTry it'},
{char:'ξ',code:'03BE',description:'GREEK SMALL LETTER XITry it'},
{char:'ο',code:'03BF',description:'GREEK SMALL LETTER OMICRONTry it'},
{char:'π',code:'03C0',description:'GREEK SMALL LETTER PITry it'},
{char:'ρ',code:'03C1',description:'GREEK SMALL LETTER RHOTry it'},
{char:'ς',code:'03C2',description:'GREEK SMALL LETTER FINAL SIGMATry it'},
{char:'σ',code:'03C3',description:'GREEK SMALL LETTER SIGMATry it'},
{char:'τ',code:'03C4',description:'GREEK SMALL LETTER TAUTry it'},
{char:'υ',code:'03C5',description:'GREEK SMALL LETTER UPSILONTry it'},
{char:'φ',code:'03C6',description:'GREEK SMALL LETTER PHITry it'},
{char:'χ',code:'03C7',description:'GREEK SMALL LETTER CHITry it'},
{char:'ψ',code:'03C8',description:'GREEK SMALL LETTER PSITry it'},
{char:'ω',code:'03C9',description:'GREEK SMALL LETTER OMEGATry it'},
{char:'ϊ',code:'03CA',description:'GREEK SMALL LETTER IOTA WITH DIALYTIKATry it'},
{char:'ϋ',code:'03CB',description:'GREEK SMALL LETTER UPSILON WITH DIALYTIKATry it'},
{char:'ό',code:'03CC',description:'GREEK SMALL LETTER OMICRON WITH TONOSTry it'},
{char:'ύ',code:'03CD',description:'GREEK SMALL LETTER UPSILON WITH TONOSTry it'},
{char:'ώ',code:'03CE',description:'GREEK SMALL LETTER OMEGA WITH TONOS'},
];


var greek_extended = [
{char:'ἀ',code:'1F00',description:'GREEK SMALL LETTER ALPHA WITH PSILI'},
{char:'ἁ',code:'1F01',description:'GREEK SMALL LETTER ALPHA WITH DASIA'},
{char:'ἂ',code:'1F02',description:'GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA'},
{char:'ἃ',code:'1F03',description:'GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA'},
{char:'ἄ',code:'1F04',description:'GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA'},
{char:'ἅ',code:'1F05',description:'GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA'},
{char:'ἆ',code:'1F06',description:'GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI'},
{char:'ἇ',code:'1F07',description:'GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI'},
{char:'Ἀ',code:'1F08',description:'GREEK CAPITAL LETTER ALPHA WITH PSILI'},
{char:'Ἁ',code:'1F09',description:'GREEK CAPITAL LETTER ALPHA WITH DASIA'},
{char:'Ἂ',code:'1F0A',description:'GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA'},
{char:'Ἃ',code:'1F0B',description:'GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA'},
{char:'Ἄ',code:'1F0C',description:'GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA'},
{char:'Ἅ',code:'1F0D',description:'GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA'},
{char:'Ἆ',code:'1F0E',description:'GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI'},
{char:'Ἇ',code:'1F0F',description:'GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI'},
{char:'ἐ',code:'1F10',description:'GREEK SMALL LETTER EPSILON WITH PSILI'},
{char:'ἑ',code:'1F11',description:'GREEK SMALL LETTER EPSILON WITH DASIA'},
{char:'ἒ',code:'1F12',description:'GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA'},
{char:'ἓ',code:'1F13',description:'GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA'},
{char:'ἔ',code:'1F14',description:'GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA'},
{char:'ἕ',code:'1F15',description:'GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA'},
{char:'Ἐ',code:'1F18',description:'GREEK CAPITAL LETTER EPSILON WITH PSILI'},
{char:'Ἑ',code:'1F19',description:'GREEK CAPITAL LETTER EPSILON WITH DASIA'},
{char:'Ἒ',code:'1F1A',description:'GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA'},
{char:'Ἓ',code:'1F1B',description:'GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA'},
{char:'Ἔ',code:'1F1C',description:'GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA'},
{char:'Ἕ',code:'1F1D',description:'GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA'},
{char:'ἠ',code:'1F20',description:'GREEK SMALL LETTER ETA WITH PSILI'},
{char:'ἡ',code:'1F21',description:'GREEK SMALL LETTER ETA WITH DASIA'},
{char:'ἢ',code:'1F22',description:'GREEK SMALL LETTER ETA WITH PSILI AND VARIA'},
{char:'ἣ',code:'1F23',description:'GREEK SMALL LETTER ETA WITH DASIA AND VARIA'},
{char:'ἤ',code:'1F24',description:'GREEK SMALL LETTER ETA WITH PSILI AND OXIA'},
{char:'ἥ',code:'1F25',description:'GREEK SMALL LETTER ETA WITH DASIA AND OXIA'},
{char:'ἦ',code:'1F26',description:'GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI'},
{char:'ἧ',code:'1F27',description:'GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI'},
{char:'Ἠ',code:'1F28',description:'GREEK CAPITAL LETTER ETA WITH PSILI'},
{char:'Ἡ',code:'1F29',description:'GREEK CAPITAL LETTER ETA WITH DASIA'},
{char:'Ἢ',code:'1F2A',description:'GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA'},
{char:'Ἣ',code:'1F2B',description:'GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA'},
{char:'Ἤ',code:'1F2C',description:'GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA'},
{char:'Ἥ',code:'1F2D',description:'GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA'},
{char:'Ἦ',code:'1F2E',description:'GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI'},
{char:'Ἧ',code:'1F2F',description:'GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI'},
{char:'ἰ',code:'1F30',description:'GREEK SMALL LETTER IOTA WITH PSILI'},
{char:'ἱ',code:'1F31',description:'GREEK SMALL LETTER IOTA WITH DASIA'},
{char:'ἲ',code:'1F32',description:'GREEK SMALL LETTER IOTA WITH PSILI AND VARIA'},
{char:'ἳ',code:'1F33',description:'GREEK SMALL LETTER IOTA WITH DASIA AND VARIA'},
{char:'ἴ',code:'1F34',description:'GREEK SMALL LETTER IOTA WITH PSILI AND OXIA'},
{char:'ἵ',code:'1F35',description:'GREEK SMALL LETTER IOTA WITH DASIA AND OXIA'},
{char:'ἶ',code:'1F36',description:'GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI'},
{char:'ἷ',code:'1F37',description:'GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI'},
{char:'Ἰ',code:'1F38',description:'GREEK CAPITAL LETTER IOTA WITH PSILI'},
{char:'Ἱ',code:'1F39',description:'GREEK CAPITAL LETTER IOTA WITH DASIA'},
{char:'Ἲ',code:'1F3A',description:'GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA'},
{char:'Ἳ',code:'1F3B',description:'GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA'},
{char:'Ἴ',code:'1F3C',description:'GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA'},
{char:'Ἵ',code:'1F3D',description:'GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA'},
{char:'Ἶ',code:'1F3E',description:'GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI'},
{char:'Ἷ',code:'1F3F',description:'GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI'},
{char:'ὀ',code:'1F40',description:'GREEK SMALL LETTER OMICRON WITH PSILI'},
{char:'ὁ',code:'1F41',description:'GREEK SMALL LETTER OMICRON WITH DASIA'},
{char:'ὂ',code:'1F42',description:'GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA'},
{char:'ὃ',code:'1F43',description:'GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA'},
{char:'ὄ',code:'1F44',description:'GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA'},
{char:'ὅ',code:'1F45',description:'GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA'},
{char:'Ὀ',code:'1F48',description:'GREEK CAPITAL LETTER OMICRON WITH PSILI'},
{char:'Ὁ',code:'1F49',description:'GREEK CAPITAL LETTER OMICRON WITH DASIA'},
{char:'Ὂ',code:'1F4A',description:'GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA'},
{char:'Ὃ',code:'1F4B',description:'GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA'},
{char:'Ὄ',code:'1F4C',description:'GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA'},
{char:'Ὅ',code:'1F4D',description:'GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA'},
{char:'ὐ',code:'1F50',description:'GREEK SMALL LETTER UPSILON WITH PSILI'},
{char:'ὑ',code:'1F51',description:'GREEK SMALL LETTER UPSILON WITH DASIA'},
{char:'ὒ',code:'1F52',description:'GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA'},
{char:'ὓ',code:'1F53',description:'GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA'},
{char:'ὔ',code:'1F54',description:'GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA'},
{char:'ὕ',code:'1F55',description:'GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA'},
{char:'ὖ',code:'1F56',description:'GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI'},
{char:'ὗ',code:'1F57',description:'GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI'},
{char:'Ὑ',code:'1F59',description:'GREEK CAPITAL LETTER UPSILON WITH DASIA'},
{char:'Ὓ',code:'1F5B',description:'GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA'},
{char:'Ὕ',code:'1F5D',description:'GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA'},
{char:'Ὗ',code:'1F5F',description:'GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI'},
{char:'ὠ',code:'1F60',description:'GREEK SMALL LETTER OMEGA WITH PSILI'},
{char:'ὡ',code:'1F61',description:'GREEK SMALL LETTER OMEGA WITH DASIA'},
{char:'ὢ',code:'1F62',description:'GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA'},
{char:'ὣ',code:'1F63',description:'GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA'},
{char:'ὤ',code:'1F64',description:'GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA'},
{char:'ὥ',code:'1F65',description:'GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA'},
{char:'ὦ',code:'1F66',description:'GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI'},
{char:'ὧ',code:'1F67',description:'GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI'},
{char:'Ὠ',code:'1F68',description:'GREEK CAPITAL LETTER OMEGA WITH PSILI'},
{char:'Ὡ',code:'1F69',description:'GREEK CAPITAL LETTER OMEGA WITH DASIA'},
{char:'Ὢ',code:'1F6A',description:'GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA'},
{char:'Ὣ',code:'1F6B',description:'GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA'},
{char:'Ὤ',code:'1F6C',description:'GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA'},
{char:'Ὥ',code:'1F6D',description:'GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA'},
{char:'Ὦ',code:'1F6E',description:'GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI'},
{char:'Ὧ',code:'1F6F',description:'GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI'},
{char:'ὰ',code:'1F70',description:'GREEK SMALL LETTER ALPHA WITH VARIA'},
{char:'ά',code:'1F71',description:'GREEK SMALL LETTER ALPHA WITH OXIA'},
{char:'ὲ',code:'1F72',description:'GREEK SMALL LETTER EPSILON WITH VARIA'},
{char:'έ',code:'1F73',description:'GREEK SMALL LETTER EPSILON WITH OXIA'},
{char:'ὴ',code:'1F74',description:'GREEK SMALL LETTER ETA WITH VARIA'},
{char:'ή',code:'1F75',description:'GREEK SMALL LETTER ETA WITH OXIA'},
{char:'ὶ',code:'1F76',description:'GREEK SMALL LETTER IOTA WITH VARIA'},
{char:'ί',code:'1F77',description:'GREEK SMALL LETTER IOTA WITH OXIA'},
{char:'ὸ',code:'1F78',description:'GREEK SMALL LETTER OMICRON WITH VARIA'},
{char:'ό',code:'1F79',description:'GREEK SMALL LETTER OMICRON WITH OXIA'},
{char:'ὺ',code:'1F7A',description:'GREEK SMALL LETTER UPSILON WITH VARIA'},
{char:'ύ',code:'1F7B',description:'GREEK SMALL LETTER UPSILON WITH OXIA'},
{char:'ὼ',code:'1F7C',description:'GREEK SMALL LETTER OMEGA WITH VARIA'},
{char:'ώ',code:'1F7D',description:'GREEK SMALL LETTER OMEGA WITH OXIA'},
{char:'ᾀ',code:'1F80',description:'GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI'},
{char:'ᾁ',code:'1F81',description:'GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI'},
{char:'ᾂ',code:'1F82',description:'GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI'},
{char:'ᾃ',code:'1F83',description:'GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI'},
{char:'ᾄ',code:'1F84',description:'GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI'},
{char:'ᾅ',code:'1F85',description:'GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI'},
{char:'ᾆ',code:'1F86',description:'GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI'},
{char:'ᾇ',code:'1F87',description:'GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI'},
{char:'ᾈ',code:'1F88',description:'GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI'},
{char:'ᾉ',code:'1F89',description:'GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI'},
{char:'ᾊ',code:'1F8A',description:'GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI'},
{char:'ᾋ',code:'1F8B',description:'GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI'},
{char:'ᾌ',code:'1F8C',description:'GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI'},
{char:'ᾍ',code:'1F8D',description:'GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI'},
{char:'ᾎ',code:'1F8E',description:'GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI'},
{char:'ᾏ',code:'1F8F',description:'GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI'},
{char:'ᾐ',code:'1F90',description:'GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI'},
{char:'ᾑ',code:'1F91',description:'GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI'},
{char:'ᾒ',code:'1F92',description:'GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI'},
{char:'ᾓ',code:'1F93',description:'GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI'},
{char:'ᾔ',code:'1F94',description:'GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI'},
{char:'ᾕ',code:'1F95',description:'GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI'},
{char:'ᾖ',code:'1F96',description:'GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI'},
{char:'ᾗ',code:'1F97',description:'GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI'},
{char:'ᾘ',code:'1F98',description:'GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI'},
{char:'ᾙ',code:'1F99',description:'GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI'},
{char:'ᾚ',code:'1F9A',description:'GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI'},
{char:'ᾛ',code:'1F9B',description:'GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI'},
{char:'ᾜ',code:'1F9C',description:'GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI'},
{char:'ᾝ',code:'1F9D',description:'GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI'},
{char:'ᾞ',code:'1F9E',description:'GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI'},
{char:'ᾟ',code:'1F9F',description:'GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI'},
{char:'ᾠ',code:'1FA0',description:'GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI'},
{char:'ᾡ',code:'1FA1',description:'GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI'},
{char:'ᾢ',code:'1FA2',description:'GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI'},
{char:'ᾣ',code:'1FA3',description:'GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI'},
{char:'ᾤ',code:'1FA4',description:'GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI'},
{char:'ᾥ',code:'1FA5',description:'GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI'},
{char:'ᾦ',code:'1FA6',description:'GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI'},
{char:'ᾧ',code:'1FA7',description:'GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI'},
{char:'ᾨ',code:'1FA8',description:'GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI'},
{char:'ᾩ',code:'1FA9',description:'GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI'},
{char:'ᾪ',code:'1FAA',description:'GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI'},
{char:'ᾫ',code:'1FAB',description:'GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI'},
{char:'ᾬ',code:'1FAC',description:'GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI'},
{char:'ᾭ',code:'1FAD',description:'GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI'},
{char:'ᾮ',code:'1FAE',description:'GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI'},
{char:'ᾯ',code:'1FAF',description:'GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI'},
{char:'ᾰ',code:'1FB0',description:'GREEK SMALL LETTER ALPHA WITH VRACHY'},
{char:'ᾱ',code:'1FB1',description:'GREEK SMALL LETTER ALPHA WITH MACRON'},
{char:'ᾲ',code:'1FB2',description:'GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI'},
{char:'ᾳ',code:'1FB3',description:'GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI'},
{char:'ᾴ',code:'1FB4',description:'GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI'},
{char:'ᾶ',code:'1FB6',description:'GREEK SMALL LETTER ALPHA WITH PERISPOMENI'},
{char:'ᾷ',code:'1FB7',description:'GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI'},
{char:'Ᾰ',code:'1FB8',description:'GREEK CAPITAL LETTER ALPHA WITH VRACHY'},
{char:'Ᾱ',code:'1FB9',description:'GREEK CAPITAL LETTER ALPHA WITH MACRON'},
{char:'Ὰ',code:'1FBA',description:'GREEK CAPITAL LETTER ALPHA WITH VARIA'},
{char:'Ά',code:'1FBB',description:'GREEK CAPITAL LETTER ALPHA WITH OXIA'},
{char:'ᾼ',code:'1FBC',description:'GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI'},
{char:'᾽',code:'1FBD',description:'GREEK KORONIS'},
{char:'ι',code:'1FBE',description:'GREEK PROSGEGRAMMENI'},
{char:'᾿',code:'1FBF',description:'GREEK PSILI'},
{char:'῀',code:'1FC0',description:'GREEK PERISPOMENI'},
{char:'῁',code:'1FC1',description:'GREEK DIALYTIKA AND PERISPOMENI'},
{char:'ῂ',code:'1FC2',description:'GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI'},
{char:'ῃ',code:'1FC3',description:'GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI'},
{char:'ῄ',code:'1FC4',description:'GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI'},
{char:'ῆ',code:'1FC6',description:'GREEK SMALL LETTER ETA WITH PERISPOMENI'},
{char:'ῇ',code:'1FC7',description:'GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI'},
{char:'Ὲ',code:'1FC8',description:'GREEK CAPITAL LETTER EPSILON WITH VARIA'},
{char:'Έ',code:'1FC9',description:'GREEK CAPITAL LETTER EPSILON WITH OXIA'},
{char:'Ὴ',code:'1FCA',description:'GREEK CAPITAL LETTER ETA WITH VARIA'},
{char:'Ή',code:'1FCB',description:'GREEK CAPITAL LETTER ETA WITH OXIA'},
{char:'ῌ',code:'1FCC',description:'GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI'},
{char:'῍',code:'1FCD',description:'GREEK PSILI AND VARIA'},
{char:'῎',code:'1FCE',description:'GREEK PSILI AND OXIA'},
{char:'῏',code:'1FCF',description:'GREEK PSILI AND PERISPOMENI'},
{char:'ῐ',code:'1FD0',description:'GREEK SMALL LETTER IOTA WITH VRACHY'},
{char:'ῑ',code:'1FD1',description:'GREEK SMALL LETTER IOTA WITH MACRON'},
{char:'ῒ',code:'1FD2',description:'GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA'},
{char:'ΐ',code:'1FD3',description:'GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA'},
{char:'ῖ',code:'1FD6',description:'GREEK SMALL LETTER IOTA WITH PERISPOMENI'},
{char:'ῗ',code:'1FD7',description:'GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI'},
{char:'Ῐ',code:'1FD8',description:'GREEK CAPITAL LETTER IOTA WITH VRACHY'},
{char:'Ῑ',code:'1FD9',description:'GREEK CAPITAL LETTER IOTA WITH MACRON'},
{char:'Ὶ',code:'1FDA',description:'GREEK CAPITAL LETTER IOTA WITH VARIA'},
{char:'Ί',code:'1FDB',description:'GREEK CAPITAL LETTER IOTA WITH OXIA'},
{char:'῝',code:'1FDD',description:'GREEK DASIA AND VARIA'},
{char:'῞',code:'1FDE',description:'GREEK DASIA AND OXIA'},
{char:'῟',code:'1FDF',description:'GREEK DASIA AND PERISPOMENI'},
{char:'ῠ',code:'1FE0',description:'GREEK SMALL LETTER UPSILON WITH VRACHY'},
{char:'ῡ',code:'1FE1',description:'GREEK SMALL LETTER UPSILON WITH MACRON'},
{char:'ῢ',code:'1FE2',description:'GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA'},
{char:'ΰ',code:'1FE3',description:'GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA'},
{char:'ῤ',code:'1FE4',description:'GREEK SMALL LETTER RHO WITH PSILI'},
{char:'ῥ',code:'1FE5',description:'GREEK SMALL LETTER RHO WITH DASIA'},
{char:'ῦ',code:'1FE6',description:'GREEK SMALL LETTER UPSILON WITH PERISPOMENI'},
{char:'ῧ',code:'1FE7',description:'GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI'},
{char:'Ῠ',code:'1FE8',description:'GREEK CAPITAL LETTER UPSILON WITH VRACHY'},
{char:'Ῡ',code:'1FE9',description:'GREEK CAPITAL LETTER UPSILON WITH MACRON'},
{char:'Ὺ',code:'1FEA',description:'GREEK CAPITAL LETTER UPSILON WITH VARIA'},
{char:'Ύ',code:'1FEB',description:'GREEK CAPITAL LETTER UPSILON WITH OXIA'},
{char:'Ῥ',code:'1FEC',description:'GREEK CAPITAL LETTER RHO WITH DASIA'},
{char:'῭',code:'1FED',description:'GREEK DIALYTIKA AND VARIA'},
{char:'΅',code:'1FEE',description:'GREEK DIALYTIKA AND OXIA'},
{char:'`',code:'1FEF',description:'GREEK VARIA'},
{char:'ῲ',code:'1FF2',description:'GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI'},
{char:'ῳ',code:'1FF3',description:'GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI'},
{char:'ῴ',code:'1FF4',description:'GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI'},
{char:'ῶ',code:'1FF6',description:'GREEK SMALL LETTER OMEGA WITH PERISPOMENI'},
{char:'ῷ',code:'1FF7',description:'GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI'},
{char:'Ὸ',code:'1FF8',description:'GREEK CAPITAL LETTER OMICRON WITH VARIA'},
{char:'Ό',code:'1FF9',description:'GREEK CAPITAL LETTER OMICRON WITH OXIA'},
{char:'Ὼ',code:'1FFA',description:'GREEK CAPITAL LETTER OMEGA WITH VARIA'},
{char:'Ώ',code:'1FFB',description:'GREEK CAPITAL LETTER OMEGA WITH OXIA'},
{char:'ῼ',code:'1FFC',description:'GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI'},
{char:'´',code:'1FFD',description:'GREEK OXIA'},
{char:'῾',code:'1FFE',description:'GREEK DASIA'},
{char:'Ϙ',code:'03D8',description:'GREEK'},
{char:'ϙ',code:'03D9',description:'GREEK'},
{char:'Ϛ',code:'03DA',description:'GREEK'},
{char:'ϛ',code:'03DB',description:'GREEK'},
{char:'Ϝ',code:'03DC',description:'GREEK'},
{char:'ϝ',code:'03DD',description:'GREEK'},
]
/************************************************************************************/

var  general_punctuation = [
{char:'—',code:'2014',description:'EM DASH'},
{char:'‘',code:'2018',description:'LEFT SINGLE QUOTATION MARKTry it'},
{char:'’',code:'2019',description:'RIGHT SINGLE QUOTATION MARKTry it'},
{char:'‚',code:'201A',description:'SINGLE LOW-9 QUOTATION MARKTry it'},
{char:'‛',code:'201B',description:'SINGLE HIGH-REVERSED-9 QUOTATION MARKTry it'},
{char:'“',code:'201C',description:'LEFT DOUBLE QUOTATION MARKTry it'},
{char:'”',code:'201D',description:'RIGHT DOUBLE QUOTATION MARKTry it'},
{char:'„',code:'201E',description:'DOUBLE LOW-9 QUOTATION MARKTry it'},
{char:'‟',code:'201F',description:'DOUBLE HIGH-REVERSED-9 QUOTATION MARKTry it'},
{char:'†',code:'2020',description:'DAGGERTry it'},
{char:'‡',code:'2021',description:'DOUBLE DAGGERTry it'},
{char:'•',code:'2022',description:'BULLETTry it'},
{char:'‣',code:'2023',description:'TRIANGULAR BULLETTry it'},
{char:'․',code:'2024',description:'ONE DOT LEADERTry it'},
{char:'‥',code:'2025',description:'TWO DOT LEADERTry it'},
{char:'…',code:'2026',description:'HORIZONTAL ELLIPSISTry it'},
{char:'‧',code:'2027',description:'HYPHENATION POINTTry it'},
{char:'‰',code:'2030',description:'PER MILLE SIGNTry it'},
{char:'‱',code:'2031',description:'PER TEN THOUSAND SIGNTry it'},
{char:'′',code:'2032',description:'PRIMETry it'},
{char:'″',code:'2033',description:'DOUBLE PRIMETry it'},
{char:'‴',code:'2034',description:'TRIPLE PRIMETry it'},
{char:'‵',code:'2035',description:'REVERSED PRIMETry it'},
{char:'‶',code:'2036',description:'REVERSED DOUBLE PRIMETry it'},
{char:'‷',code:'2037',description:'REVERSED TRIPLE PRIMETry it'},
{char:'‸',code:'2038',description:'CARETTry it'},
{char:'‹',code:'2039',description:'SINGLE LEFT-POINTING ANGLE QUOTATION MARKTry it'},
{char:'›',code:'203A',description:'SINGLE RIGHT-POINTING ANGLE QUOTATION MARK'},
{char:'♦',code:'2666',description:'BLACK DIAMOND SUIT'},
{char:'⚫',code:'26AB',description:'MEDIUM BLACK CIRCLE'},
{char:"◼",code:'25FC',description:'MIsssss'},
{char:"→",code:'2192',description:'Misssss'},
{char:"≻",code:'227B',description:'MISSSSS'},
{char:'&#160;',code:'0020',description:'NON-BREAKING SPACE'}
];
/******************************************************************************************/

var miscellaneous_symbols = [

];


/************************************************************************************/
var glagolitic = [
{code:'2C30',char:'ⰰ',description:' GLAGOLITIC SMALL LETTER AZU'},
{code:'2C31',char:'ⰱ',description:' GLAGOLITIC SMALL LETTER BUKY'},
{code:'2C32',char:'ⰲ',description:' GLAGOLITIC SMALL LETTER VEDE'},
{code:'2C33',char:'ⰳ',description:' GLAGOLITIC SMALL LETTER GLAGOLI'},
{code:'2C34',char:'ⰴ',description:' GLAGOLITIC SMALL LETTER DOBRO'},
{code:'2C35',char:'ⰵ',description:' GLAGOLITIC SMALL LETTER YESTU'},
{code:'2C36',char:'ⰶ',description:' GLAGOLITIC SMALL LETTER ZHIVETE'},
{code:'2C37',char:'ⰷ',description:' GLAGOLITIC SMALL LETTER DZELO'},
{code:'2C38',char:'ⰸ',description:' GLAGOLITIC SMALL LETTER ZEMLJA'},
{code:'2C39',char:'ⰹ',description:' GLAGOLITIC SMALL LETTER IZHE'},
{code:'2C3A',char:'ⰺ',description:' GLAGOLITIC SMALL LETTER INITIAL IZHE'},
{code:'2C3B',char:'ⰻ',description:' GLAGOLITIC SMALL LETTER I'},
{code:'2C3C',char:'ⰼ',description:' GLAGOLITIC SMALL LETTER DJERVI'},
{code:'2C3D',char:'ⰽ',description:' GLAGOLITIC SMALL LETTER KAKO'},
{code:'2C3E',char:'ⰾ',description:' GLAGOLITIC SMALL LETTER LJUDIJE'},
{code:'2C3F',char:'ⰿ',description:' GLAGOLITIC SMALL LETTER MYSLITE'},
{code:'2C40',char:'ⱀ',description:' GLAGOLITIC SMALL LETTER NASHI'},
{code:'2C41',char:'ⱁ',description:' GLAGOLITIC SMALL LETTER ONU'},
{code:'2C42',char:'ⱂ',description:' GLAGOLITIC SMALL LETTER POKOJI'},
{code:'2C43',char:'ⱃ',description:' GLAGOLITIC SMALL LETTER RITSI'},
{code:'2C44',char:'ⱄ',description:' GLAGOLITIC SMALL LETTER SLOVO'},
{code:'2C45',char:'ⱅ',description:' GLAGOLITIC SMALL LETTER TVRIDO'},
{code:'2C46',char:'ⱆ',description:' GLAGOLITIC SMALL LETTER UKU'},
{code:'2C47',char:'ⱇ',description:' GLAGOLITIC SMALL LETTER FRITU'},
{code:'2C48',char:'ⱈ',description:' GLAGOLITIC SMALL LETTER HERU'},
{code:'2C49',char:'ⱉ',description:' GLAGOLITIC SMALL LETTER OTU'},
{code:'2C4A',char:'ⱊ',description:' GLAGOLITIC SMALL LETTER PE'},
{code:'2C4B',char:'ⱋ',description:' GLAGOLITIC SMALL LETTER SHTA'},
{code:'2C4C',char:'ⱌ',description:' GLAGOLITIC SMALL LETTER TSI'},
{code:'2C4D',char:'ⱍ',description:' GLAGOLITIC SMALL LETTER CHRIVI'},
{code:'2C4E',char:'ⱎ',description:' GLAGOLITIC SMALL LETTER SHA'},
{code:'2C4F',char:'ⱏ',description:' GLAGOLITIC SMALL LETTER YERU'},
{code:'2C50',char:'ⱐ',description:' GLAGOLITIC SMALL LETTER YERI'},
{code:'2C51',char:'ⱑ',description:' GLAGOLITIC SMALL LETTER YATI'},
{code:'2C52',char:'ⱒ',description:' GLAGOLITIC SMALL LETTER SPIDERY HA'},
{code:'2C53',char:'ⱓ',description:' GLAGOLITIC SMALL LETTER YU'},
{code:'2C54',char:'ⱔ',description:' GLAGOLITIC SMALL LETTER SMALL YUS'},
{code:'2C55',char:'ⱕ',description:' GLAGOLITIC SMALL LETTER SMALL YUS WITH'},
{code:'2C56',char:'ⱖ',description:' GLAGOLITIC SMALL LETTER YO'},
{code:'2C57',char:'ⱗ',description:' GLAGOLITIC SMALL LETTER IOTATED SMALL'},
{code:'2C58',char:'ⱘ',description:' GLAGOLITIC SMALL LETTER BIG YUS'},
{code:'2C59',char:'ⱙ',description:' GLAGOLITIC SMALL LETTER IOTATED BIG YUS'},
{code:'2C5A',char:'ⱚ',description:' GLAGOLITIC SMALL LETTER FITA'},
{code:'2C5B',char:'ⱛ',description:' GLAGOLITIC SMALL LETTER IZHITSA'},
{code:'2C5C',char:'ⱜ',description:' GLAGOLITIC SMALL LETTER SHTAPIC'},
{code:'2C5D',char:'ⱝ',description:' GLAGOLITIC SMALL LETTER TROKUTASTI A'},
{code:'2C5E',char:'ⱞ',description:' GLAGOLITIC SMALL LETTER LATINATE MYSLITE'},
{code:'2C00',char:'Ⰰ',description:' GLAGOLITIC CAPITAL LETTER AZU'},
{code:'2C01',char:'Ⰱ',description:' GLAGOLITIC CAPITAL LETTER BUKY'},
{code:'2C02',char:'Ⰲ',description:' GLAGOLITIC CAPITAL LETTER VEDE'},
{code:'2C03',char:'Ⰳ',description:' GLAGOLITIC CAPITAL LETTER GLAGOLI'},
{code:'2C04',char:'Ⰴ',description:' GLAGOLITIC CAPITAL LETTER DOBRO'},
{code:'2C05',char:'Ⰵ',description:' GLAGOLITIC CAPITAL LETTER YESTU'},
{code:'2C06',char:'Ⰶ',description:' GLAGOLITIC CAPITAL LETTER ZHIVETE'},
{code:'2C07',char:'Ⰷ',description:' GLAGOLITIC CAPITAL LETTER DZELO'},
{code:'2C08',char:'Ⰸ',description:' GLAGOLITIC CAPITAL LETTER ZEMLJA'},
{code:'2C09',char:'Ⰹ',description:' GLAGOLITIC CAPITAL LETTER IZHE'},
{code:'2C0A',char:'Ⰺ',description:' GLAGOLITIC CAPITAL LETTER INITIAL IZHE'},
{code:'2C0B',char:'Ⰻ',description:' GLAGOLITIC CAPITAL LETTER I'},
{code:'2C0C',char:'Ⰼ',description:' GLAGOLITIC CAPITAL LETTER DJERVI'},
{code:'2C0D',char:'Ⰽ',description:' GLAGOLITIC CAPITAL LETTER KAKO'},
{code:'2C0E',char:'Ⰾ',description:' GLAGOLITIC CAPITAL LETTER LJUDIJE'},
{code:'2C0F',char:'Ⰿ',description:' GLAGOLITIC CAPITAL LETTER MYSLITE'},
{code:'2C10',char:'Ⱀ',description:' GLAGOLITIC CAPITAL LETTER NASHI'},
{code:'2C11',char:'Ⱁ',description:' GLAGOLITIC CAPITAL LETTER ONU'},
{code:'2C12',char:'Ⱂ',description:' GLAGOLITIC CAPITAL LETTER POKOJI'},
{code:'2C13',char:'Ⱃ',description:' GLAGOLITIC CAPITAL LETTER RITSI'},
{code:'2C14',char:'Ⱄ',description:' GLAGOLITIC CAPITAL LETTER SLOVO'},
{code:'2C15',char:'Ⱅ',description:' GLAGOLITIC CAPITAL LETTER TVRIDO'},
{code:'2C16',char:'Ⱆ',description:' GLAGOLITIC CAPITAL LETTER UKU'},
{code:'2C17',char:'Ⱇ',description:' GLAGOLITIC CAPITAL LETTER FRITU'},
{code:'2C18',char:'Ⱈ',description:' GLAGOLITIC CAPITAL LETTER HERU'},
{code:'2C19',char:'Ⱉ',description:' GLAGOLITIC CAPITAL LETTER OTU'},
{code:'2C1A',char:'Ⱊ',description:' GLAGOLITIC CAPITAL LETTER PE'},
{code:'2C1B',char:'Ⱋ',description:' GLAGOLITIC CAPITAL LETTER SHTA'},
{code:'2C1C',char:'Ⱌ',description:' GLAGOLITIC CAPITAL LETTER TSI'},
{code:'2C1D',char:'Ⱍ',description:' GLAGOLITIC CAPITAL LETTER CHRIVI'},
{code:'2C1E',char:'Ⱎ',description:' GLAGOLITIC CAPITAL LETTER SHA'},
{code:'2C1F',char:'Ⱏ',description:' GLAGOLITIC CAPITAL LETTER YERU'},
{code:'2C20',char:'Ⱐ',description:' GLAGOLITIC CAPITAL LETTER YERI'},
{code:'2C21',char:'Ⱑ',description:' GLAGOLITIC CAPITAL LETTER YATI'},
{code:'2C22',char:'Ⱒ',description:' GLAGOLITIC CAPITAL LETTER SPIDERY HA'},
{code:'2C23',char:'Ⱓ',description:' GLAGOLITIC CAPITAL LETTER YU'},
{code:'2C24',char:'Ⱔ',description:' GLAGOLITIC CAPITAL LETTER SMALL YUS'},
{code:'2C25',char:'Ⱕ',description:' GLAGOLITIC CAPITAL LETTER SMALL YUS WITH'},
{code:'2C26',char:'Ⱖ',description:' GLAGOLITIC CAPITAL LETTER YO'},
{code:'2C27',char:'Ⱗ',description:' GLAGOLITIC CAPITAL LETTER IOTATED SMALL'},
{code:'2C28',char:'Ⱘ',description:' GLAGOLITIC CAPITAL LETTER BIG YUS'},
{code:'2C29',char:'Ⱙ',description:' GLAGOLITIC CAPITAL LETTER IOTATED BIG YUS'},
{code:'2C2A',char:'Ⱚ',description:' GLAGOLITIC CAPITAL LETTER FITA'},
{code:'2C2B',char:'Ⱛ',description:' GLAGOLITIC CAPITAL LETTER IZHITSA'},
{code:'2C2C',char:'Ⱜ',description:' GLAGOLITIC CAPITAL LETTER SHTAPIC'},
{code:'2C2D',char:'Ⱝ',description:' GLAGOLITIC CAPITAL LETTER TROKUTASTI A'},
{code:'2C2E',char:'Ⱞ',description:' GLAGOLITIC CAPITAL LETTER LATINATE'},
];
