
function load_record(id, callback) {
  createReq({
    "recID": parseInt(id),
    "deleteRecordCache": 1,
    "requestType": "getRecord"
  }, load_record_callback, true, undefined, handle_lock_on_file);
}

function merge_load_record(id) {
  createReq({
    "recID": parseInt(id),
    "requestType": "getRecord"
  }, merge_load_record_callback, true, undefined);
}

function load_user_info() {
  createReq({
    "requestType": "getUserInfo"
  }, save_user_info);
}

function save_xml(xml) {
  createReq({
    "requestType": "saveXML",
    "gorazdXML": xml.replace(/\r?\n|\r/g, '')
  }, save_xml_response);
}

function submit_xml(xml) {
  createReq({
    "requestType": "submit_gorazdXML",
    "recID": cache.load_record_id,
    "gorazdXML": xml.replace(/\r?\n|\r/g, '')
  }, submit_xml_response);
}

function cancel_xml_edit() {
  createReq({
    "requestType": "cancel",
    "recID": cache.load_record_id
  }, cancel_xml_edit_response, true, undefined, cancel_xml_edit_error);
}

function get_xml_vers() {
  createReq({
    "requestType": 'get_latest_version',
    "recID": cache.load_record_id
  }, get_xml_vers_response, true, undefined, get_xml_vers_error);
}
function change_clone_id(id) {

}

function clone(xml) {
  if (xml == false) {
    set_error_dialog(error_transformation_false, 500, 150, true);
  } else {
    start_full_loader(true);
    createReq({
      "requestType": "submit_gorazdXML",
      "type": "clone",
      recID: cache.load_record_id,
      "gorazdXML": xml.replace(/\r?\n|\r/g, '')
    }, clone_record_response, true, undefined, clone_record_response_error);
  }
}

function recognize(xml) {
  createReq({
    requestType: 'parseXML',
    rule: 'odstavec',
    gorazdXML: xml.replace(/\r?\n|\r/g, '')
  }, recognize_xml_response);
}

function save_backup(html, callback) {
  var user_ = user_json();
  var img_ = JSON.stringify(cache.full_record_json);
  if (user_ !== undefined && user_ !== "" && img_ !== undefined && img_ !== "") {
    $.post(xml_xsl, {
      req: "save_backup",
      id: cache.load_record_id,
      save: 'save',
      html: html,
      user_json: user_,
      img: img_
    }).done(function(data) {
      if (data.resp) {
        show_hint_msg("Uloženo", true);
        if (callback != undefined) {
          callback(data.resp);
        }
      } else {
        set_error_dialog(error_record_backup_save, 500, 150, true);
        if (callback != undefined) {
          callback(false);
        }
      }
    }).fail(function(data) {
      set_error_dialog(error_record_backup_save, 500, 150, true);
      if (callback != undefined) {
        callback(false);
      }
    });
  } else {
    set_error_dialog(error_record_backup_save, 500, 150, true);
    if (callback != undefined) {
      callback(false);
    }
  }
}

function set_backup_status() {
  $.post(xml_xsl, {
    req: "set_saving",
    id: cache.load_record_id
  }).done(function(data) {

  }).fail(function(data) {
    set_error_dialog(error_record_backup_status, 500, 150, true);
  });
}

function remove_user_backup() {
  $.post(xml_xsl, {
    req: "remove_backup",
    uid: cache.user_json.userInfo.uid,
    id: cache.load_record_id
  }).done(function(data) {
    console.log(data);
  }).fail(function(data) {
    set_error_dialog(error_record_backup_remove, 500, 150, true);
  });
}

function load_mysql_backup() {
  $.post(xml_xsl, {
    req: "load_backup",
    id: cache.load_record_id
  }).done(function(data) {
    style_result = false;
    var obj = JSON.parse(data);
    cache.load_mysql_backup = obj;
    load_record_callback(JSON.parse(obj.img_json));
  }).fail(function(data) {
    set_error_dialog(error_record_backup_load, 500, 150, false);
  });
}

function validate_html() {
  var o = $('pageparts div')[0];
  $.post(xml_xsl, {
    req: "html",
    file1: html_xsl1,
    file2: html_xsl2,
    file3: html_xsl3,
    html: nodeToString(o).replace(/\r?\n|\r/g, '').replace(/&nbsp;/g, '&amp;nbsp;')
  }).done(function(data) {
    $.post(xml_xsl, {
      req: "validate_xml_html",
      html: data,
      file1: in_xsd
    }).done(function(data) {
      var obj = data;
      set_confirm_dialog(obj.data, undefined, 1500, 500, "Zavřít");
    });
  });
}

function test_xml_validation() {
  show_hint_msg("Validuji XML", true);
  var o = $('pageparts div')[0];
  $.post(xml_xsl, {
    req: "html",
    file1: html_xsl1,
    file2: html_xsl2,
    file3: html_xsl3,
    html: nodeToString(o).replace(/\r?\n|\r/g, '').replace(/&nbsp;/g, '&amp;nbsp;')
  }).done(function(data) {
    $.post(xml_xsl, {
      req: "validate_xml_html",
      html: data,
      file1: in_xsd
    }).done(function(data) {
      var obj = data;
      set_confirm_dialog(obj.data, undefined, 1500, 500, "Zavřít");
      console.log(obj);
    });
  });
}

function save_send_html_report_confirm() {
  $.post(xml_xsl, {
    req: "save_backup",
    id: cache.load_record_id,
    save: 'save',
    html: nodeToString($('pageparts div')[0]).replace(/\r?\n|\r/g, '').replace(/&nbsp;/g, '&amp;nbsp;'),
    user_json: user_json(),
    img: JSON.stringify(cache.full_record_json)
  }).done(function(data) {
    $.post(xml_xsl, {
      req: "send_backup_report",
      uid: cache.user_json.userInfo.uid,
      id: cache.record_id_temp_mysql,
      email: JSON.stringify(report_email)
    }).done(function(data_) {
      console.log(data_);
    });
  });
}

function send_html_report_confirm() {
  $.post(xml_xsl, {
    req: "send_backup_report",
    uid: cache.user_json.userInfo.uid,
    id: cache.record_id_temp_mysql,
    email: JSON.stringify(report_email)
  }).done(function(data) {
    console.log(data);
  });
}



function cut_clipboard() {
  show_hint_msg("Vyjmout", true);
  var o = $('pageparts div span.selected_span');
  var temp = "";
  for (var i = 0; i < o.length; i++) {
    temp += nodeToString(o[i]).replace(/\r?\n|\r/g, '');
  }
  $.post(xml_xsl, {
    req: "store_clipboard",
    html: temp,
    id: cache.record_id_temp_mysql,
    uid: cache.user_json.userInfo.uid
  }).done(function(data) {
    add_history_step('Cut');
    setTimeout(function() {
      $('pageparts div span.selected_span').remove();
    }, 80);
  });
}

function copy_clipboard() {
  show_hint_msg("Kopírovat", true);
  var o = $('pageparts div span.selected_span');
  var temp = "";
  for (var i = 0; i < o.length; i++) {
    temp += nodeToString(o[i]).replace(/\r?\n|\r/g, '');
  }
  $.post(xml_xsl, {
    req: "store_clipboard",
    html: temp,
    id: cache.record_id_temp_mysql,
    uid: cache.user_json.userInfo.uid
  }).done(function(data) {});
}

function paste_clipboard() {
  show_hint_msg("Vložit", true);
  $.post(xml_xsl, {
    req: "load_clipboard",
    uid: cache.user_json.userInfo.uid
  }).done(function(data) {
    if (data != "") {
      var obj = JSON.parse(data);
      if (obj.time.day > 0) {
        cache.clipboard_temp = $(obj.html);
        set_confirm_dialog("Opravdu chcete vložit text starý <br>" + generate_time_text(obj.time), accept_clipboard_insert, 500, 200, 'Nevkládat', 'Vložit');
      } else {
        var html = $(obj.html);
        var o = $('pageparts div span.selected_span').last();
        add_history_step('Paste');
        html.each(function() {
          cache.i++
          $(this).attr('list_num', cache.i);
          block_part_set_events($(this));
        });
        setTimeout(function() {
          html.insertAfter(o);
          o.removeClass('selected_span');
        }, 20);
        _init_events_render();
      }
    }
  });
}

function generate_time_text(time) {
  return time.day + " den, " + time.hour + " hodin, " + time.minit + " minut, " + time.second + " sekund";
}

function accept_clipboard_insert() {
  var o = $('pageparts div span.selected_span').last();
  add_history_step('Paste');
  var html = $(cache.clipboard_temp);
  html.each(function() {
    cache.i++
    $(this).attr('list_num', cache.i);
    block_part_set_events($(this));
  });
  setTimeout(function() {
    html.insertAfter(o);
    o.removeClass('selected_span');
    _init_start();
    cache.clipboard_temp = "";
  }, 20);
  _init_events_render();
}



function check_mysql_backup_interval() {
  $.post(xml_xsl, {
    req: "check_backup",
    id: cache.record_id_temp_mysql
  }).done(function(data) {
    handle_check_mysql_backup_interval(data)
  });
}

function check_mysql_backup(id) {
  cache.record_id_temp_mysql = id;
  $.post(xml_xsl, {
    req: "check_backup",
    id: id
  }).done(function(data) {
    handle_check_mysql_backup(data)
  });
}
