

function set_confirm_dialog(text, confirm, width = 500, height = 200, one, two, second = undefined, close = false, return_form = false) {
    $('#dialog_uni').remove();
    var buttons;
    if (two == undefined) {
        buttons = {
            [one]: function() {
                $(this).dialog("close");
                if (confirm != undefined) {
                    if (return_form) {
                        confirm(dialog_uni);
                    } else {
                        confirm();
                    }
                }
            }
        }
    } else {
        buttons = {
            [one]: function() {
                $(this).dialog("close");
                if (second != undefined) {
                    second();
                }
            },
            [two]: function() {
                $(this).dialog("close");
                if (return_form) {
                    confirm(dialog_uni);
                } else {
                    confirm();
                }
            }
        }
    }
    dialog_uni = $('<div id="dialog_uni"></div>');
    dialog_uni.dialog({
        width: width,
        height: height,
        modal: true,
        autoOpen: false,
        open: function() {
            dialogs.uni = true;
        },
        close: function() {
            setTimeout(function() {
                dialogs.uni = false;
            }, 100);
        },
        buttons: buttons,
    });
    dialog_uni.append(text);
    if (close) {
        dialog_uni.parent().find('.ui-dialog-titlebar-close').remove();
        dialog_uni.parent().unbind();
    }
    dialog_uni.find('i').css({
        'font-size': '47px',
        'float': 'right',
        'margin-left': '10px',
        'margin-top': '-11px'
    });
    dialog_uni.dialog('open');
}

function set_error_dialog(text, width = 500, height = 200, close = false) {
    dialog_uni = $('<div id="dialog_uni"></div>');
    dialog_uni.dialog({
        width: width,
        height: height,
        modal: true,
        autoOpen: false,
        close: function() {
            $(this).dialog('close');
        }
    });
    dialog_uni.append(text);
    if (!close) {
        dialog_uni.append(loading_image_.css({
            'margin': '0 auto',
            'display': 'block'
        }));
        dialog_uni.parent().find('.ui-button').remove();
        dialog_uni.parent().unbind();
    }
    dialog_uni.parent().css({
        'z-index': 999999999999,
        'box-shadow': 'rgba(0,0,0,.2) 16px 16px 60px'
    })
    dialog_uni.find('i').css({
        'font-size': '47px',
        'float': 'right',
        'margin-left': '10px',
        'margin-top': '-11px'
    });
    dialog_uni.dialog('open');
}

function activate_dialogs() {
    dialog_change_style = $('<div id="dialog_change_style"></div>');
    $('body').append(dialog_change_style);
    dialog_change_style.dialog({
        width: 570,
        height: 300,
        modal: true,
        autoOpen: false,
        open: function() {
            dialogs.change_style = true;
            cache.open_style_change_sel = $('.selected_span');
        },
        close: function() {
            setTimeout(function() {
                dialogs.change_style = false;
                cache.open_style_change_sel.addClass('selected_span');
            }, 100);
        },
        buttons: {
            Zrušit: function() {
                $(this).dialog("close");
                disable_change_block_part_style();
            },
            Uložit: function() {
                $(this).dialog("close");
                dialog_save_block_part_changes();
                disable_change_block_part_style();
            }
        }
    });

    dialog_remove_block_part = $('<div id="dialog_remove_block_part"></div>');
    dialog_remove_block_part.dialog({
        width: 570,
        height: 170,
        modal: true,
        autoOpen: false,
        open: function() {
            dialogs.open_delete_block = true;
        },
        close: function() {
            setTimeout(function() {
                dialogs.open_delete_block = false;
            }, 100);
        },
        buttons: {
            Zrušit: function() {
                $(this).dialog("close");
                disable_remove_block_part();
            },
            Smazat: function() {
                $(this).dialog("close");
                remove_block_part(cache.select_block_part);
                disable_remove_block_part()
            }
        }
    });

    dialog_remove_block_parts = $('<div id="dialog_remove_block_part"></div>');
    dialog_remove_block_parts.dialog({
        width: 570,
        height: 170,
        modal: true,
        autoOpen: false,
        open: function() {
            dialogs.open_delete_blocks = true;
        },
        close: function() {
            setTimeout(function() {
                dialogs.open_delete_blocks = false;
            }, 100);
        },
        buttons: {
            Zrušit: function() {
                $(this).dialog("close");
            },
            Smazat: function() {
                $(this).dialog("close");
                remove_block_parts();
            }
        }
    });

    dialog_virtual_keyboard = $('<div id="dialog_virtual_keyboard"><div id="tabs"><ul></ul><div id="tabs_content"></div></div></div>');
    dialog_virtual_keyboard.dialog({
        width: 750,
        height: 750,
        modal: true,
        autoOpen: false,
        close: function() {
            setTimeout(function() {
                dialogs.open_keyboard = false;
            }, 100);
        },
        open: function() {
            dialogs.open_keyboard = true;
            input_key_pos = $('#keyboard_input').val().length;
        },
        buttons: {
            Zavřít: function() {
                $(this).dialog("close");
                update_input_keyboard();
            },
        }
    });
    dialog_virtual_keyboard.keyup(function(e) {
        if (e.keyCode == 13) {
            dialog_virtual_keyboard.dialog("close");
            update_input_keyboard();
        }
    });




    dialog_select_block_status = $('<div id="dialog_block_status"></div>');
    dialog_select_block_status.dialog({
        width: 400,
        height: 170,
        modal: true,
        autoOpen: false,
        close: function() {
            setTimeout(function() {
                dialogs.block_status = false;
            }, 100);
        },
        open: function() {
            dialogs.block_status = true;
        },
        buttons: {
            Zavřít: function() {
                $(this).dialog("close");
            },
            Odeslat: function() {
                $(this).dialog("close");
                save_record_status($(this).find('option:selected').val());
            },
        }
    });

    dialog_select_block_to_rec = $('<div id="dialog_select_block_to_rec"></div>');
    dialog_select_block_to_rec.dialog({
        width: 400,
        height: 170,
        modal: true,
        autoOpen: false,
        close: function() {
            setTimeout(function() {
                dialogs.rescan_block = false;
            }, 100);
        },
        open: function() {
            dialogs.rescan_block = true;
        },
        buttons: {
            Zavřít: function() {
                $(this).dialog("close");
            },
            Odeslat: function() {
                $(this).dialog("close");
                send_to_control($(this).find('option:selected').val());
            },
        }
    });

    dialog_clone_block = $('<div id="dialog_clone_block"></div>');
    dialog_clone_block.dialog({
        width: 400,
        height: 278,
        modal: true,
        autoOpen: false,
        close: function() {
            setTimeout(function() {
                dialogs.block_clone_success = false;
            }, 100);
        },
        open: function() {
            dialogs.block_clone_success = true;
        },
        buttons: {
            ["Pokračovat v práci"]: function() {
                $(this).dialog("close");
            },
            ["Neukládat a přejít na kopii"]: function() {
                $(this).dialog("close");
                save_not_and_go();

            },
            ["Uložit a přejít na kopii"]: function() {
                $(this).dialog("close");
                save_and_go();

            },
        }
    });

    dialog_unlock_block = $('<div id="dialog_unlock_"></div>');
    dialog_unlock_block.dialog({
        width: 720,
        height: 175,
        modal: true,
        autoOpen: false,
        close: function() {
            setTimeout(function() {
                dialogs.block_unlock = false;
            }, 100);
        },
        open: function() {
            dialogs.block_unlock = true;
        },
        buttons: {
            ["Zrušit"]: function() {
                $(this).dialog("close");
            },
            ["Odemknout a zavřít"]: function() {
                remove_user_backup();
                cancel_xml_edit();
                $(this).dialog("close");

            },
        }
    });

    dialog_select_block_type = $('<div id="dialog_select_block_type"></div>');
    dialog_select_block_type.dialog({
        width: 365,
        height: 166,
        modal: true,
        autoOpen: false,
        close: function() {
            setTimeout(function() {
                dialogs.select_block_type = false;
            }, 100);
        },
        open: function() {
            dialogs.select_block_type = true;
        },
        buttons: {
            Uložit: function() {
                $(this).dialog("close");
                change_block_view();
            },
        }
    });

    dialog_send_report = $('<div id="dialog_send_report"></div>');
    dialog_send_report.dialog({
        width: 600,
        height: 200,
        modal: true,
        autoOpen: false,
        close: function() {
            setTimeout(function() {
                dialogs.send_report = false;
            }, 100);
        },
        open: function() {
            dialogs.send_report = true;
        },
        buttons: {
            ["Zrušit"]: function() {
                $(this).dialog("close");
            },
            ["Uložit a odeslat"]: function() {
                $(this).dialog("close");
                save_send_html_report_confirm();
            },
            ["Odeslat"]: function() {
                $(this).dialog("close");
                send_html_report_confirm();
            },
        }
    });

}
function prepare_dialog_unlock_report() {
    dialog_unlock_block.html('');
    dialog_unlock_block.append("<span>Odemknout soubor a ukončit editaci ?</span><i class='material-icons'>report</i>");
    dialog_unlock_block.find('i').css({
        'font-size': '47px',
        'float': 'right',
        'margin-left': '10px',
        'margin-top': '-11px'
    });
    dialog_unlock_block.dialog('open');
}
function prepare_dialog_send_report() {
    dialog_send_report.append(dialog_send_report_text);
    dialog_send_report.dialog('open')
}
function prepare_dialog_clone_block(json) {
    cache.clone_json = json;
    if (json.clone_warning == undefined) {
        dialog_clone_block.append('<a target="_blank" href="' + get_base_editor_url() + '/record/gorazd_edit/?ln=cs&recid=' + json.newRecID + '">ID kopie je: ' + json.newRecID + '</a>');
        change_clone_id(json.newRecID);
        dialog_clone_block.dialog('open');
    } else {
        set_confirm_dialog(json.clone_warning, undefined, 500, 170, "Zavřít");
    }



}
function load_block_style_change(block) {
    dialog_change_style.html('');
    if ($(pageparts).children().find('.selected_span').length > 1) {
        selected_block = $(pageparts).children().find('.selected_span');
        selected_block_clone = $(pageparts).children().find('.selected_span').clone().removeClass('selected_span');
        dialog_change_style.append(selected_block_clone);
        var select_div = $('<div id="dialog_change_style_selects"></div>');
        var select_type = $(render_style_type_select());
        select_type.keydown(function(e) {
            if (e.keyCode == 13) {
                $(this).parents('.ui-dialog').find('.ui-dialog-buttonset .ui-button').last().click();
                return false;
            }
        })
        select_div.append(select_type);
        dialog_change_style.append(select_div);
        handle_spec_select_type(select_type, selected_block_clone, select_div, 'zahlavi');
        select_type.change(function() {
            if (second_select) {
                handle_spec_select_type($(this), selected_block_clone, select_div, "");
            }
            selected_block_clone.css({
                'background-color': $(this).find('option:selected').attr('color')
            });
            selected_block_clone.attr('aip-type', $(this).find('option:selected').val());
            if ($(this).find('option:selected').val() !== "text_hesla") {
                set_rule(selected_block_clone);
            } else {
            }
            set_nepresne_to_ssl($(this).find('option:selected').val(),selected_block_clone);
            update_el_info(selected_block_clone);
        });
    } else {
        selected_block = block;
        dialog_change_style.html('');
        selected_block_clone = block.clone().removeClass('selected_span');
        dialog_change_style.append(selected_block_clone);
        var select_div = $('<div id="dialog_change_style_selects"></div>')
        var select_type = $(render_style_type_select());
        select_type.keydown(function(e) {
            if (e.keyCode == 13) {
                $(this).parents('.ui-dialog').find('.ui-dialog-buttonset .ui-button').last().click();
                return false;
            }
        })
        select_div.append(select_type);
        select_type.val(block.attr('aip-type'));
        if (block.attr('aip-grka') != "" && block.attr('aip-grka') != undefined && second_select) {
            handle_spec_select_type(select_type, selected_block_clone, select_div, block.attr('aip-grka').split(','));
        }
        switch (block.attr('aip-type')) {
            case "zahlavi":
            case "nasobne_zahlavi":
                handle_spec_select_type(select_type, selected_block_clone, select_div, "");
                break;
        }

        dialog_change_style.append(select_div);
        select_type.change(function() {
            if (second_select) {
                handle_spec_select_type($(this), selected_block_clone, select_div, "");
            }
            selected_block_clone.css({
                'background-color': $(this).find('option:selected').attr('color')
            });
            selected_block_clone.attr('aip-type', $(this).find('option:selected').val());
            if ($(this).find('option:selected').val() !== "text_hesla") {
                set_rule(selected_block_clone);
            } else {

            }
            set_nepresne_to_ssl($(this).find('option:selected').val(),selected_block_clone);
            update_el_info(selected_block_clone);
        });
    }
    dialog_change_style.parents('.ui-dialog').find('.ui-dialog-content').unbind('keyup').keyup(function(e) {
        if (e.keyCode == 13) {
            dialog_change_style.parents('.ui-dialog').find('.ui-dialog-buttonset').find('button').first().next().click();
        }
    });
    dialog_change_style.dialog('open');
}

function handle_spec_select_type(sel, selected_block_clone, select_div, val) {
    switch (sel.find('option:selected').val()) {
        case "zahlavi":
            select_div.find('#spec_type').remove();
            var tmp = $(render_select_specify_type_select(sel.find('option:selected').val()));
            set_sepc_event(tmp, selected_block_clone);
            select_div.append(tmp);
            break;
        case "nasobne_zahlavi":
            select_div.find('#spec_type').remove();
            var tmp = $(render_select_specify_type_select(sel.find('option:selected').val()));
            set_sepc_event(tmp, selected_block_clone);
            select_div.append(tmp);
            break;
        default:
            select_div.find('#spec_type').remove();
            selected_block_clone.attr('aip-grka', '');
            break;
    }
    if (val != undefined && val != "") {
        if (typeof val !== "object") {
            select_div.find('#spec_type').val(val);
        } else {
            setTimeout(function() {
                for (var i in val) {
                    select_div.find('option[value="' + val[i] + '"]').attr("selected", 1);
                    select_div.find('option[value="' + val[i] + '"]').prop('selected', true);
                }
            }, 10);
        }
    }
}

function set_sepc_event(el, clone) {
    el.change(function() {
        var val = "";
        el.find('option:selected').each(function(i, ol) {
            val += $(this).val();
            val += (el.find('option:selected').length != i + 1) ? "," : "";
        });
        clone.attr('aip-grka', val);
    });
}
function prepare_block_select_dialog() {
    dialog_select_block_to_rec.html('');
    dialog_select_block_to_rec.append(select_block_to_rec_text);
    var select = $(prepare_block_select());
    dialog_select_block_to_rec.append(select);
    dialog_select_block_to_rec.dialog('open');
}
function preape_remove_block_part_dialog() {
    dialog_remove_block_part.html('');
    dialog_remove_block_part.append(dialog_remove_part_text)
    dialog_remove_block_part.dialog('open');
}
function dialog_save_block_part_changes() {
    if (selected_block.length > 0) {
        add_history_step('change style part');
        if (selected_block.length > 1) {
            selected_block.each(function(i, el) {
                $(el).replaceWith($(selected_block_clone[i]));
            });
        } else {
            selected_block.replaceWith(selected_block_clone);
        }
        selected_block_clone.each(function() {
            if ($(this).attr('aip-editable') == "true" || $(this).attr('aip-editable') == undefined) {
                block_part_set_events($(this));
            } else {
                block_part_set_events($(this), false);
            }
            $(this).addClass('selected_span');
        });
        refresh_all_info();
    }
}
function prepare_select_block_status_dialog(a) {
    dialog_select_block_status.html('');
    var select_status = $(render_block_status_select());
    var select_div = $('<div id="dialog_change_block_status_select"><span>Stav: </span></div>');
    if (!a) {
        select_status.find('option[value="3"]').remove();
    }
    select_status.val($('metadata status').text());
    select_div.append(select_status);
    dialog_select_block_status.append(select_div);
    dialog_select_block_status.dialog('open');
}
function prepare_select_block_type_dialog() {
    dialog_select_block_type.html('');
    var select_div = $('<div id="dialog_change_block_type_select"></div>');
    var select_type = $(render_block_type_select());
    var end = $('start[aip-block-name=""]');
    var start = $('end[aip-block-name=""]');
    select_div.append(select_type);
    dialog_select_block_type.append(dialog_change_block_type_text).append(select_div);
    select_type.change(function() {
        add_history_step('add block , change style');
        end.attr('aip-block-name', $(this).find('option:selected').text()).text($(this).find('option:selected').text());
        start.attr('aip-block-name', $(this).find('option:selected').text()).text($(this).find('option:selected').text());
    });
    dialog_select_block_type.dialog('open');
}

function load_delete_block_parts(e) {
    if ($(selected_span).length > 0) {
        dialog_remove_block_parts.html('');
        dialog_remove_block_parts.append(dialog_remove_parts_text)
        dialog_remove_block_parts.dialog('open');
    }
}


function check_open_dialogs() {
    var ol = 0;
    for (var i in dialogs) {
        if (dialogs[i]) {
            ol++;
        }
    }
    if (ol == 0) {
        return true;
    }
    return false;
}
