
    function prepare_html(in_html = "") {
        switch (get_url_params().dict) {
            case "MS":
                prepare_html_MS(in_html);
                break;
            case "RSI":
                prepare_html_RSI(in_html);
                break;
            default:
                prepare_html_DEF(in_html);
                break;
        }
    }

    function prepare_html_DEF(in_html = "") {
        if (cache.merge_load_temp_record != undefined) {
            $('.other_block_rep').remove();
        }
        cache.i = 0;
        var html
        if (in_html == "") {
            html = $(String($(pageparts).html()));
        } else {
            html = in_html;
        }
        var open = false;
        html.children().each(function() {
            var el = $(this);
            if (el.is('start')) {
                open = true;
                block_set_events(el);
                el.css('background', block_colors[el.attr('block').split('-').length]);
                el.addClass('start_block');
                el.text(el.attr('aip-block-name'))
                if (el.attr('block').split('-').length == 4) {
                    el.addClass('start_end_notvisible');
                } else {
                    cache.aip_block_store[el.attr('block')] = check_start_end_duplicity_array_short(aip_block_template);
                    el.attr('block', cache.aip_block_store[el.attr('block')]);
                    el.addClass('start_end_notvisible');
                }
                if (block_types.indexOf($(this).attr('aip-block-name')) == -1) {
                    block_types.push($(this).attr('aip-block-name'));
                }
            }
            if (el.is('span')) {

                el.addClass('text_seg');

                el.attr('list_num', cache.i);
                update_el_info(el);
                if (el.attr('aip-editable') == "true") {
                    block_part_set_events(el);
                } else {
                    block_part_set_events(el, false);
                }
                if (el.attr('aip-style') != undefined) {
                    trasnlate_attr_(el.attr('aip-style'), el);
                }



                if (text_styling[el.attr('aip-type')] != undefined && style_result == true && el.attr('aip-type') != "komentar") {
                    if (el.attr('aip-style') == undefined || el.attr('aip-style') == "") {
                        el.attr('aip-style', trasnlate_attr_(text_styling[el.attr('aip-type')][4], el, true));
                    }
                    if (el.css('font-family') == undefined || el.css('font-family') == "") {
                        el.css('font-family', text_styling[el.attr('aip-type')][3]);
                    }
                    if (el.attr('aip-font') == undefined || el.attr('aip-font') == "") {
                        el.attr('aip-font', text_styling[el.attr('aip-type')][3]);
                    }
                    if (el.attr('aip-size') == undefined || el.attr('aip-size') == "") {
                        el.attr('aip-size', text_styling[el.attr('aip-type')][2]);
                    }
                    if (el.css('font-size') == undefined || el.css('font-size') == "") {
                        el.css('font-size', text_styling[el.attr('aip-type')][2] + "px");
                    }
                    if (el.attr('aip-type') != "text_hesla") {
                        el.attr('lang', text_styling[el.attr('aip-type')][6]);
                    }
                }
                if (el.attr('aip-type') == "komentar") {
                    el.css('font-family', el.attr('aip-font'));
                    el.css('font-size', el.attr('aip-size') + "px");
                }
                if (el.attr('fontsize') != "" && el.attr('fontsize') != undefined) {

                }

                if (el.attr('fontsize') != "" && el.attr('fontsize') != undefined) {
                    el.attr('aip-size', translate_font_(el.attr('fontsize')));
                    el.css('font-size', translate_font_(el.attr('fontsize')) + "px");
                }

                if (el.attr('aip-type') == "text_hesla" && el.attr('lang') != "ocs") {
                    el.attr('aip-font', 'FreeSerif');
                    el.css('font-family', 'FreeSerif');
                }

                if (el.attr('aip-type') == "text_hesla") {
                    if (el.attr('lang') == undefined || el.attr('lang') == "") {
                        if (el.attr('alphabet') == "ru") {
                            el.attr('aip-font', 'CyrillicaBulgarian10U');
                            el.css('font-family', 'CyrillicaBulgarian10U');
                        }
                    }
                }

                if (el.attr('aip-type') == "text_hesla" && el.attr('lang') == "ocs") {
                    el.attr('aip-font', 'CyrillicaBulgarian10U');
                    el.css('font-family', 'CyrillicaBulgarian10U');
                }


                el.css({
                    'display': 'inline-block',
                    'background-color': aip_type_colors[$(this).attr('aip-type')]
                });
                cache.i++;

            }
            if (el.is('end')) {
                open = false;
                block_set_events(el);
                el.css('background', block_colors[el.attr('block').split('-').length]);
                el.addClass('end_block');
                el.text(el.attr('aip-block-name'))
                if (el.attr('block').split('-').length == 4) {
                    el.addClass('start_end_notvisible');
                } else {
                    el.attr('block', cache.aip_block_store[el.attr('block')]);
                    el.addClass('start_end_notvisible');
                }
            }
        });
        if (in_html == "") {
            $('pageparts').html(html);
        } else {
            $('pageparts').append(html);
        }
        style_result = true;
        refresh_all_info();
        set_sortable_pageparts();
        _init_events_render();
        if (cache.i < 1500) {
            second_render_text_block();
            active_map_view = true;
        } else {
            active_map_view = false;
        }
    }

    function prepare_html_RSI(in_html = "") {
        cache.i = 0;
        var html
        if (in_html == "") {
            html = $(String($(pageparts).html()));
        } else {
            html = in_html;
        }
        var open = false;
        html.children().each(function() {
            var el = $(this);
            if (el.is('start')) {
                open = true;
                block_set_events(el);
                el.css('background', block_colors[el.attr('block').split('-').length]);
                el.addClass('start_block');
                el.text(el.attr('aip-block-name'))
                if (el.attr('block').split('-').length == 4) {
                    el.addClass('start_end_notvisible');
                } else {
                    cache.aip_block_store[el.attr('block')] = check_start_end_duplicity_array_short(aip_block_template);
                    el.attr('block', cache.aip_block_store[el.attr('block')]);
                    el.addClass('start_end_notvisible');
                }
                if (block_types.indexOf($(this).attr('aip-block-name')) == -1) {
                    block_types.push($(this).attr('aip-block-name'));
                }
            }
            if (el.is('span')) {
                var style__ = el.attr('style');
                if(el.attr('nepresne') == '1'){
                  el.attr('aip-type','ssl_zahlavi_nep');
                }
                el.addClass('text_seg');
                el.attr('list_num', cache.i);
                if (el.attr('aip-editable') == "true") {
                    block_part_set_events(el);
                } else {
                    block_part_set_events(el, false);
                }
                if (el.attr('aip-style') != undefined) {
                    trasnlate_attr_(el.attr('aip-style'), el);
                }
                if (el.attr('aip-type') == "komentar" || el.attr('aip-type') == "text_hesla") {

                    if (el.attr('alphabet') == undefined || el.attr('alphabet') == "") {
                        el.attr('alphabet', text_styling[el.attr('aip-type')][5]);
                    }

                    if (el.attr('lang') == undefined || el.attr('lang') == "") {
                        el.attr('lang', text_styling[el.attr('aip-type')][6]);
                    }

                    if ((el.attr('font') == undefined || el.attr('font') == "") && (el.attr('aip-font') == undefined || el.attr('aip-font') == "" )) {

                        el.attr('aip-font', text_styling[el.attr('aip-type')][3]);
                        el.css('font-family', text_styling[el.attr('aip-type')][3]);
                    } else {
                        if (el.attr('aip-font') == undefined || el.attr('aip-font') == "") {
                            el.css('font-family', el.attr('font').replace(' ', ''));
                            el.attr('aip-font', el.attr('font').replace(' ', ''));
                        }else{
                            el.css('font-family', el.attr('aip-font').replace(' ', ''));
                        }
                    }

                    if (el.attr('fontsize') == undefined || el.attr('fontsize') == "") {
                        el.attr('fontsize', text_styling[el.attr('aip-type')][3]);
                        el.attr('aip-size', translate_font_(el.attr('fontsize')));
                        el.css('font-size', translate_font_(el.attr('fontsize')) + "px");
                    } else {
                        el.css('font-size', (parseInt(translate_font_(el.attr('fontsize'))) + page_zoom_edit) + "px");
                        el.attr('aip-size', translate_font_(el.attr('fontsize')));;
                    }
                    if (style__ == undefined || style__ == "") {
                        el.attr('aip-style', trasnlate_attr_(text_styling[el.attr('aip-type')][4], el, true));
                        el.attr('font-style', el.attr('aip-style'));
                    } else {
                        trasnlate_attr_(style__, el);
                        el.attr('aip-style', trasnlate_attr_(style__, el, true));
                        el.attr('font-style', trasnlate_attr_(el.attr('aip-style'), el, true));
                    }
                    el.css({
                        'background-color': aip_type_colors[el.attr('aip-type')]
                    });

                    if(el.attr('size') == undefined && (el.attr('aip-size') == undefined || el.attr('aip-size') == '')){
                        el.attr('fontsize','normal');
                        el.attr('aip-size', translate_font_(el.attr('fontsize')));
                        el.css('font-size', translate_font_(el.attr('fontsize')) + "px");
                    }

                } else {
                    set_rule(el);
                }
                cache.i++;
            }
            if (el.is('end')) {
                open = false;
                block_set_events(el);
                el.css('background', block_colors[el.attr('block').split('-').length]);
                el.addClass('end_block');
                el.text(el.attr('aip-block-name'))
                if (el.attr('block').split('-').length == 4) {
                    el.addClass('start_end_notvisible');
                } else {
                    el.attr('block', cache.aip_block_store[el.attr('block')]);
                    el.addClass('start_end_notvisible');
                }
            }
        });
        if (in_html == "") {
            $('pageparts').html(html);
        } else {
            $('pageparts').append(html);
        }
        style_result = true;
        refresh_all_info();
        set_sortable_pageparts();
        _init_events_render();
        show_source();
        set_inline_block();
    }

    function prepare_html_MS(in_html = "") {
      cache.i = 0;
      var html
      if (in_html == "") {
          html = $(String($(pageparts).html()));
      } else {
          html = in_html;
      }
      var open = false;
      html.children().each(function() {
          var el = $(this);
          if (el.is('start')) {
              open = true;
              block_set_events(el);
              el.css('background', block_colors[el.attr('block').split('-').length]);
              el.addClass('start_block');
              el.text(el.attr('aip-block-name'))
              if (el.attr('block').split('-').length == 4) {
                  el.addClass('start_end_notvisible');
              } else {
                  cache.aip_block_store[el.attr('block')] = check_start_end_duplicity_array_short(aip_block_template);
                  el.attr('block', cache.aip_block_store[el.attr('block')]);
                  el.addClass('start_end_notvisible');
              }
              if (block_types.indexOf($(this).attr('aip-block-name')) == -1) {
                  block_types.push($(this).attr('aip-block-name'));
              }
          }
          if (el.is('span')) {
              var style__ = el.attr('style');
              el.addClass('text_seg');
              el.attr('list_num', cache.i);
              if (el.attr('aip-editable') == "true") {
                  block_part_set_events(el);
              } else {
                  block_part_set_events(el, false);
              }
              if (el.attr('aip-style') != undefined) {
                  trasnlate_attr_(el.attr('aip-style'), el);
              }
              if (el.attr('aip-type') == "komentar" || el.attr('aip-type') == "text_hesla") {

                  if (el.attr('alphabet') == undefined || el.attr('alphabet') == "") {
                      el.attr('alphabet', text_styling[el.attr('aip-type')][5]);
                  }

                  if (el.attr('lang') == undefined || el.attr('lang') == "") {
                      el.attr('lang', text_styling[el.attr('aip-type')][6]);
                  }

                  if ((el.attr('font') == undefined || el.attr('font') == "") && (el.attr('aip-font') == undefined || el.attr('aip-font') == "" )) {

                      el.attr('aip-font', text_styling[el.attr('aip-type')][3]);
                      el.css('font-family', text_styling[el.attr('aip-type')][3]);
                  } else {
                      if (el.attr('aip-font') == undefined || el.attr('aip-font') == "") {
                          el.css('font-family', el.attr('font').replace(' ', ''));
                          el.attr('aip-font', el.attr('font').replace(' ', ''));
                      }else{
                          el.css('font-family', el.attr('aip-font').replace(' ', ''));
                      }
                  }



                  if (el.attr('fontsize') == undefined || el.attr('fontsize') == "") {
                      el.attr('fontsize', text_styling[el.attr('aip-type')][3]);
                      el.attr('aip-size', translate_font_(el.attr('fontsize')));
                      el.css('font-size', translate_font_(el.attr('fontsize')) + "px");
                  } else {
                      el.css('font-size', (parseInt(translate_font_(el.attr('fontsize'))) + page_zoom_edit) + "px");
                      el.attr('aip-size', translate_font_(el.attr('fontsize')));;
                  }
                  if (style__ == undefined || style__ == "") {
                      el.attr('aip-style', trasnlate_attr_(text_styling[el.attr('aip-type')][4], el, true));
                      el.attr('font-style', el.attr('aip-style'));
                  } else {
                      trasnlate_attr_(style__, el);
                      el.attr('aip-style', trasnlate_attr_(style__, el, true));
                      el.attr('font-style', trasnlate_attr_(el.attr('aip-style'), el, true));
                  }
                  el.css({
                      'background-color': aip_type_colors[el.attr('aip-type')]
                  });

                  if(el.attr('size') == undefined && (el.attr('aip-size') == undefined || el.attr('aip-size') == '')){
                      el.attr('fontsize','normal');
                      el.attr('aip-size', translate_font_(el.attr('fontsize')));
                      el.css('font-size', translate_font_(el.attr('fontsize')) + "px");
                  }

              } else {
                  set_rule(el);
              }
              cache.i++;
          }
          if (el.is('end')) {
              open = false;
              block_set_events(el);
              el.css('background', block_colors[el.attr('block').split('-').length]);
              el.addClass('end_block');
              el.text(el.attr('aip-block-name'))
              if (el.attr('block').split('-').length == 4) {
                  el.addClass('start_end_notvisible');
              } else {
                  el.attr('block', cache.aip_block_store[el.attr('block')]);
                  el.addClass('start_end_notvisible');
              }
          }
      });
      if (in_html == "") {
          $('pageparts').html(html);
      } else {
          $('pageparts').append(html);
      }
      style_result = true;
      refresh_all_info();
      set_sortable_pageparts();
      _init_events_render();
      show_source();
      set_inline_block();
    }

    function toggle_map_view(button) {
        start_full_loader(true);
        setTimeout(function() {
            if (active_map_view) {
                active_map_view = false;
                $('#arround_page').find('.other_block_rep').remove();
                $('#arround_page').find('point').remove();
                start_full_loader(false);
            } else {
                second_render_text_block();
                active_map_view = true;
                start_full_loader(false);
            }
        }, 200);
    }

    function set_rule(el) {
        el.attr('aip-style', trasnlate_attr_(text_styling[el.attr('aip-type')][4], el, true));
        el.css('font-family', text_styling[el.attr('aip-type')][3]);
        el.attr('aip-font', text_styling[el.attr('aip-type')][3]);
        el.attr('aip-size', text_styling[el.attr('aip-type')][2]);
        el.attr('fontsize', translate_font_(text_styling[el.attr('aip-type')][2]));
        el.css('font-size', (parseInt(text_styling[el.attr('aip-type')][2]) + page_zoom_edit) + "px");
        el.attr('alphabet', text_styling[el.attr('aip-type')][5]);
        el.attr('lang', text_styling[el.attr('aip-type')][6]);
        el.css({
            'background-color': aip_type_colors[el.attr('aip-type')]
        });
    }

    function change_block_view() {
        if (active_block_view) {
            $('end').removeClass('start_end_notvisible').show(500);
            $('start').removeClass('start_end_notvisible').show(500);
            var html = $(pageparts).children();
            var margin = 0;
            var first = false;
            setTimeout(function() {
                $('.separ_block_view').remove();
                html.children().each(function() {
                    var kr = $('<kr class="separ_block_view"><kr>');
                    var el = $(this);
                    if (el.is('start')) {
                        el.addClass('block_view_layer');
                        el.css({
                            'margin-left': (el.attr('block').split('-').length * 10)
                        });
                        margin = el.attr('block').split('-').length * 10;
                        first = true;
                    }
                    if (el.is('span')) {
                        var clone = kr.clone();
                        if (first) {
                            (clone.css({
                                'width': margin
                            })).insertBefore(el);
                            first = false;
                        }
                    }
                    if (el.is('end')) {
                        el.css('font-family', 'freeserif');
                        el.addClass('block_view_layer');
                        el.css({
                            'margin-left': (el.attr('block').split('-').length * 10)
                        });
                        margin = el.attr('block').split('-').length * 10;
                    }
                });
            }, 550);
        } else {
            $('kr').remove();
            $('end').removeClass('block_view_layer').css({
                'margin-left': 0
            });
            $('start').removeClass('block_view_layer').css({
                'margin-left': 0
            });
            var html = $(pageparts).children();
            html.children().each(function() {
                var el = $(this);
                if (el.is('start')) {
                    if (el.attr('block').split('-').length == 4) {
                        el.addClass('start_end_notvisible');
                    } else {
                        el.css({
                            'display': 'none'
                        });
                    }
                }
                if (el.is('end')) {
                    if (el.attr('block').split('-').length == 4) {
                        el.addClass('start_end_notvisible');
                    } else {
                        el.css({
                            'display': 'none'
                        });
                    }
                }
            });
        }
    }
    function array_main_blocks() {
        var final_array = [];
        var html = $(pageparts).children();
        var span_text = "";
        html.children().each(function() {
            var kr = $('<kr class="separ_block_view"><kr>');
            var el = $(this);
            if (el.is('span')) {
                span_text += el.text();
            }
            if (el.is('end')) {
                if (el.attr('block').split('-').length == 4) {
                    final_array.push({
                        'block': el.attr('block'),
                        'span': span_text
                    });
                    span_text = "";
                }
            }
        });
        return final_array;
    }
    function set_nepresne_to_ssl(type,el){
        if (type == "ssl_zahlavi_nep") {
            el.attr('nepresne', '1')
        }else{
            el.removeAttr('nepresne');
        }
    }
    function set_sortable_pageparts() {
        var order = [];
        var first = [];
        $('pageparts div').sortable({
            disabled: false,
            placeholder: "placeholder",
            activate: function() {
            },
            helper: function(event, item) {
                add_history_step('text sort');
                if ($('.selected_span').length < 1) {
                    $(item).addClass('selected_span');
                }
                var result = $('<div></div>');
                $('.selected_span').each(function() {
                    var clone = $(this).clone();
                    result.append(clone);
                });
                return $(result);
            },
            cancel: 'kr,input,end,start',
            start: function(e, ui) {
                order = []
                first = $(ui.item).attr('list_num');
                $(ui.item).addClass('selected_span');
                $('.selected_span').each(function() {
                    if (!order.includes($(this).attr('list_num'))) {
                        order.push($(this).attr('list_num'));
                    }
            },
            stop: function(e, ui) {
                for (var i in order) {
                    $('span[list_num="' + order[i] + '"]:not(.other_block_rep)').insertAfter($(ui.item).prev());
                }
                if (order[order.indexOf(first) - 1] !== undefined) {
                    $('span[list_num="' + first + '"]:not(.other_block_rep)').insertAfter($('span[list_num="' + order[order.indexOf(first) - 1] + '"]:not(.other_block_rep)'));
                }
                if (order[order.indexOf(first) - 1] === undefined) {
                    $('span[list_num="' + first + '"]:not(.other_block_rep)').insertBefore($('span[list_num="' + order[order.indexOf(first) + 1] + '"]:not(.other_block_rep)'));
                }
            }
        });
    }
    function unset_sortable_pageparts() {
        $('pageparts div').sortable({
            disabled: true
        });
    }
    function render_layer(button, l) {
        start_full_loader(true);
        button_highlight(button)
        active_layer = l;
        render_text_block(json, active_layer);
        set_key_bind_events();
        setTimeout(function() {
            start_full_loader(false);
        }, 500);
    }
    function show_virtual_keyboard(button) {
        button_highlight(button);
        $('#keyboard_input').val($(pageparts).find('input').val())
        dialog_virtual_keyboard.dialog('open');
    }
    function second_render_text_block() {
        var html = $(String($(pageparts).html()));
        var i = 0;
        html.children().each(function(i, ol) {
            var point = $('<point></point>');
            var el = $(this);

            if (el.is('span') && el.attr('hpos') != undefined && $('#arround_page').find('span[list_num="' + el.attr('list_num') + '"]').length == 0) {
                el.text('');
                el.addClass('text_seg');
                el.addClass('other_block_rep');
                el.css({
                    'left': (el.attr('hpos') / cache.img_ratio[el.attr('page_id')]) + 'px',
                    'top': ((el.attr('vpos') / cache.img_ratio[el.attr('page_id')]) + cache.imgs_offset[el.attr('page_id')]) + 'px',
                    'width': (el.attr('width') / cache.img_ratio[el.attr('page_id')]) + 'px',
                    'height': (el.attr('height') / cache.img_ratio[el.attr('page_id')]) + 'px',
                });
                el.css({
                    'position': 'absolute',
                    'color': 'transparent',
                    "background-color": 'transparent',
                    'min-height': 0,
                    'padding': '0'
                });
                i++;
                var asd = el.clone();
                var left = ((el.attr('hpos') / cache.img_ratio[el.attr('page_id')]) < (cache.img_prev_max_width / 2) - 80) ? "80" : cache.img_prev_max_width - 80;

                point.css({
                    'left': left + 'px',
                    'top': ((el.attr('vpos') / cache.img_ratio[el.attr('page_id')]) + cache.imgs_offset[el.attr('page_id')]) + 'px',
                    'height': (el.attr('height') / cache.img_ratio[el.attr('page_id')]) + 'px',
                });
                $('#arround_page').append(point);
                asd.attr('title', '');
                asd.attr('aip-type', '');
                asd.off().unbind();
                $('#arround_page').append(asd);
            }
        });
    }
    function insert_hidden_space(e) {
        var ol = e.target.selectionStart;
        var input = $(pageparts_input);
        var arr = input.val().split('')
        arr.splice(ol, 0, String.fromCharCode(160));
        input.val(arr.join(''));
        input.focus().setCursorPosition(ol + 1);
    }
    function text_img_extremes() {
        var result = {};
        result.max_y = 0;
        result.max_x = 0;
        result.min_y = 10000000000;
        result.min_x = 10000000000;
        var html = $(String($('pageparts').html()));
        html.children().each(function(i, el) {
            var hpos = $(this).attr('HPOS');
            var vpos = $(this).attr('VPOS');
            if (result.max_y < parseInt(vpos)) {
                result.max_y = vpos;
            }
            if (result.min_y > parseInt(vpos)) {
                result.min_y = vpos;
            }
            if (result.min_x > parseInt(hpos)) {
                result.min_x = hpos;
            }
        });
        var ratio = 0;
        var i_ = 0;
        for (var i in cache.img_ratio) {
            ratio += cache.img_ratio[i];
            i_++
        }
        ratio = ratio / i_;
        if (cache.first_loaded_xml == undefined) {
            $('zoommenu div').first().next().click();
            setTimeout(function() {
                $('zoommenu div').first().next().click();
                html.find('span').each(function() {
                    if ($(this).attr('hpos') != undefined) {
                        $(pagepreview).scrollTop((($(this).attr('VPOS') / ratio) + cache.imgs_offset[$(this).attr('page_id')]) - 580).scrollLeft(($(this).attr('HPOS') / ratio) - 120);
                        return false;
                    }
                });
            }, 500);
        }
    }

    function block_input_edit(el) {
        if (el.length > 0 && check_open_dialogs() == true) {
            if (cache.input_span_replace == "") {
                cache.input_span_replac = "";
                add_history_step('update part');
                $('span').removeClass('selected_span');
                cache.input_span_replace = el.clone();
                var input = input_edit_temp.clone();
                input.css({
                    'font-size': cache.input_span_replace.css('font-size'),
                    'padding-left': '3px',
                    'font-family': cache.input_span_replace.css('font-family')
                });
                set_input_width_by_lenght(input, cache.input_span_replace.text());
                input.val(cache.input_span_replace.text());
                el.replaceWith(input);
                setTimeout(function() {
                    input.focus();
                }, 100);
                if (cache.input_span_replace.hasClass('new_create') == true) {
                    input.select();
                    input.addClass('new_create');
                }
                input.unbind('keyup');
                set_input_binds(input);
                setTimeout(function() {
                    set_autocomplete(input, cache.input_span_replace.attr('aip-type'));
                    input.keyup(function(e) {
                        update_el_info($(this));
                        set_input_width_by_lenght($(this), $(this).val());
                        if (e.keyCode == 13) {
                            remove_autocomplete(input);
                            all_func_disabled();
                            all_menu_func_disabled();
                            block_part_set_events(cache.input_span_replace);
                            $(this).replaceWith(cache.input_span_replace);
                            $(cache.input_span_replace).removeClass('new_create').text($.trim($(this).val())).attr('content', $.trim($(this).val())).addClass('selected_span');
                            if ($.trim($(this).val()) == " " || $.trim($(this).val()) == "") {
                                $(cache.input_span_replace).remove();
                            }
                            cache.input_span_replace = "";
                        }
                    });
                }, 200)
            } else {
                var input = $('pageparts').find('input');
                var val = input.val();
                if (input.hasClass('change_to_freeserif') && input.hasClass('new_create')) {
                    set_el_to_freeserif(cache.input_span_replace);
                }
                input.replaceWith(cache.input_span_replace);
                add_history_step('text edit');
                cache.input_span_replace.removeClass('new_create')
                cache.input_span_replace.text($.trim(val));
                cache.input_span_replace.attr('content', $.trim(val));
                block_part_set_events(cache.input_span_replace);
                cache.input_span_replace = "";
            }
        }
        set_inline_block();
        highlight_selected();
    }
    function set_inline_block() {
        $(pageparts_div).find('span').each(function(i, ol) {
            $(this).css({
                'display': 'inline-block',
                'background-color': aip_type_colors[$(this).attr('aip-type')]
            });
        });
    }

    function remove_autocomplete(input) {
    }

    function set_autocomplete(el, type) {
        var sou;
        switch (type) {
            case "pamatka":
                sou = auto_monuments;
                break;
            case "slovni_druh":
                sou = word_classes;
                break;
            default:
                sou = "";
                break;
        }
        if (sou != "" && sou != undefined) {
            el.autocomplete({
                source: sou
            });
        }
    }
    function remove_prev_block_input(e) {
        cache.cont = 0;
        cache.start_count = 0;
        cache.end_count = 0;
        var aa = 0;
        $(e.target).prevAll().each(function(i) {
            if ($(this).is('start')) {
                aa++;
            }
        });
        var prev_el = $(e.target).prev();
        $(e.target).prevAll().each(function(i) {
            var el = $(this);
            if ($(this).is('start')) {
                cache.start_count++;
                if (aa > 1) {
                    find_end_start_remove_block(el);
                }
            }
            if (!$(this).is('start')) {
                find_end_start_remove_block(el);
            }

        });
        if ($(e.target).prev().is('bigskip')) {
            $(e.target).prev().remove();
        }
        if ($(e.target).prev().is('tab')) {
            $(e.target).prev().remove();
        }
        remove_end_start_remove_block();
    }
    function remove_next_block_input(e) {
        cache.cont = 0;
        var aa = 0;
        $(e.target).nextAll().each(function(i) {
            if ($(this).is('end')) {
                aa++;
            }
        });
        $(e.target).nextAll().each(function(i) {
            var el = $(this);
            if ($(this).is('end')) {
                cache.start_count++;
                if (aa > 1) {
                    find_end_start_remove_block(el);
                }
            }
            if (!$(this).is('end')) {
                find_end_start_remove_block(el);
            }
        });
        if ($(e.target).next().is('bigskip')) {
            $(e.target).next().remove();
        }
        if ($(e.target).next().is('tab')) {
            $(e.target).next().remove();
        }
        remove_end_start_remove_block();
    }
    function remove_end_start_remove_block() {
        if (cache.start != undefined && cache.start != "" && cache.end != undefined && cache.end != "") {
            cache.start.remove();
            cache.end.remove();
            $('end[block="' + cache.start_num + '"]').attr('block', cache.end_num);
        }
    }
    function find_end_start_remove_block(el) {
        if (cache.cont < 2) {
            if (el.is('start')) {
                if (el.attr('block').split('-').length == 4) {
                    cache.cont++;
                    cache.start = el;
                    cache.start_num = el.attr('block');
                }
            }
            if (el.is('end')) {
                if (el.attr('block').split('-').length == 4) {
                    cache.cont++;
                    cache.end = el;
                    cache.end_num = el.attr('block');
                }
            }
        }
    }
    function refresh_all_info() {
        $(pageparts_div).find('span').each(function() {
            update_el_info($(this));
        });
    }
    function update_el_info(el) {
        var info = "";
        if (el.attr('alphabet') != "" && el.attr('alphabet') != undefined) {
            info += "Abeceda : " + lang_trans_alph_trans[el.attr('alphabet')] + "\n";
        }
        if (el.attr('aip-editable') != "" && el.attr('aip-editable') != undefined) {
            var val = ((el.attr('aip-editable') == "true") ? "ano" : "ne");
            info += "Editovatelný : " + val + "\n";
        }
        if (el.attr('font-style') != "" && el.attr('font-style') != undefined) {
            info += "Styl : " + el.attr('font-style') + "\n";
        }
        if (el.attr('aip-size') != "" && el.attr('aip-size') != undefined) {
            info += "Velikost : " + el.attr('aip-size') + "\n";
        }
        if (el.attr('aip-font') != "" && el.attr('aip-font') != undefined) {
            info += "Font : " + el.attr('aip-font') + "\n";
        }
        if (el.attr('lang') != "" && el.attr('lang') != undefined) {
            if (lang_trans_trans[el.attr('lang')] == undefined) {
                info += "Jazyk : " + el.attr('lang') + "\n";
            } else {
                info += "Jazyk : " + lang_trans_trans[el.attr('lang')] + "\n";
            }
        }
        if (el.attr('aip-type') != "" && el.attr('aip-type') != undefined) {
            if (word_type_trans[$.trim(el.attr('aip-type'))] == undefined) {
                info += "Typ : " + $.trim(el.attr('aip-type')) + "\n";
            } else {
                info += "Typ : " + word_type_trans[$.trim(el.attr('aip-type'))] + "\n";
            }
        }
        if (el.attr('aip-style') != "" && el.attr('aip-style') != undefined) {
            info += "Styl : " + font_style[el.attr('aip-style')] + "\n";
        }
        if (el.attr('aip-index') != "" && el.attr('aip-index') != undefined) {
            info += "Index : " + word_index[el.attr('aip-index')] + "\n";
        }
        if (el.attr('aip-grka') != "" && el.attr('aip-grka') != undefined) {
            var spliter = el.attr('aip-grka').split(',');
            var oll = "";
            for (var i in spliter) {
                if (i == spliter.length - 1) {
                    oll += type_spec_trans[spliter[i]] + "";
                } else {
                    oll += type_spec_trans[spliter[i]] + ",";
                }
            }
            info += "Gramatická kategorie : " + oll + "\n";
        }
        el.attr('title', info);
    }
    function create_new_block_input(e) {
        var cont = true;
        var prev_el = $(e.target).prev();
        var open_blocks = [];
        var new_blocks_dup = [];
        $(e.target).prevAll().each(function(i) {
            var el = $(this);
            if (cont) {
                if (el.is('start')) {
                    if (el.attr('block').split('-').length == 4) {
                        cont = false;
                    }
                    if (open_blocks.indexOf(el.attr('block')) > -1) {
                        open_blocks.splice(open_blocks.indexOf(el.attr('block')), 1);
                    } else {
                        open_blocks.push(el.attr('block'));
                    }
                }
                if (el.is('end')) {
                    if (el.attr('block').split('-').length == 4) {
                        cont = false;
                    } else {
                        if (open_blocks.indexOf(el.attr('block')) > -1) {
                            open_blocks.splice(open_blocks.indexOf(el.attr('block')), 1);
                        } else {
                            open_blocks.push(el.attr('block'));
                        }
                    }
                }
            }
        });
        if (open_blocks.length > 0) {
            for (var i in open_blocks) {
                var dup = check_start_end_duplicity(open_blocks[i]);
                new_blocks_dup.push(dup);
            }
            add_history_step('new block');
            for (var i in open_blocks) {
                $('start[block="' + open_blocks[i] + '"]').attr('block', new_blocks_dup[i])
                var end = end_block(new_blocks_dup[i]).clone();
                var start = start_block(open_blocks[i]).clone();
                block_set_events(start);
                block_set_events(end);
                end.insertBefore($(e.target));
                start.insertAfter($(e.target));
                end.text($('start[block="' + new_blocks_dup[i] + '"]').text()).attr('aip-block-name', $('start[block="' + new_blocks_dup[i] + '"]').text()).css('background', block_colors[new_blocks_dup[i].split('-').length]);
                start.text($('start[block="' + new_blocks_dup[i] + '"]').text()).attr('aip-block-name', $('start[block="' + new_blocks_dup[i] + '"]').text()).css('background', block_colors[new_blocks_dup[i].split('-').length]);
            }
            $(e.target).insertAfter($(prev_el));
            change_block_view();
        }
    }
    function block_set_events(block) {
        block.click(function(e) {
            if (active_func.remove_block_part) {
                cache.select_block_part = $(this).parent().find("[block='" + $(this).attr('block') + "']");
                preape_remove_block_part_dialog();
            }
            if (active_func.change_style) {
                load_block_style_change($(this))
            }
        });
    }
    function block_part_set_events(block, edit = true) {
        if (edit) {
            block.dblclick(function() {
                disable_edit_tools();
                block_input_edit($(this));
            });
        }

        block.mouseenter(function(e) {
            if (mouse_click_active && key_active[16] == true) {
                unset_sortable_pageparts();
                select_block_part(e, e.target);
                highlight_selected();
            }
        }).mouseleave(function() {
        });

        block.click(function(e) {
            if (active_func.change_style) {
                load_block_style_change($(this))
            }
            if (active_func.remove_block_part) {
                cache.select_block_part = $(this);
                preape_remove_block_part_dialog()
            }
            if (active_func.merge_block_parts) {
                if ($(selected_span).length > 1) {
                    merge_selected_block_parts(e);
                    disable_edit_tools();
                } else {
                    if (first_merge_block_part == undefined) {
                        first_merge_block_part = block;
                    } else {
                        second_merge_block_part = block;
                    }
                    if (first_merge_block_part != undefined && second_merge_block_part != undefined &&
                        first_merge_block_part != "" && second_merge_block_part != "" && first_merge_block_part != second_merge_block_part) {
                        merge_block_parts(first_merge_block_part, second_merge_block_part);
                    }
                }
            }
            if (active_func.split_block_parts) {
                add_history_step('split part');
                var x = e.clientX - $(e.target).offset().left
                var y = e.clientY - $(e.target).offset().top
                var clone = $(e.target).clone();
                $(e.target).text(clone.text().substr(Math.floor(x / 6.7), clone.text().length));
                clone.text(clone.text().substr(0, Math.floor(x / 6.7)))
                if (clone.text().length > 0) {
                    clone.insertBefore($(e.target));
                    block_part_set_events(clone);
                }
                disable_remove_block_part();
            }
        });
    }
    function add_new_block_before_selected() {
        if ($(selected_span).length > 0) {
            add_history_step('new point');
            var clone = span_create_temp().clone();
            clone.unbind();
            clone.addClass('new_create');
            block_part_set_events(clone);
            clone.attr('aip-type', 'text_hesla');
            set_rule(clone);
            clone.insertAfter($(pageparts_div).find('span.selected_span').last());
            set_el_to_freeserif(clone);
            refresh_all_info();
        }
        if ($(pageparts_div).find('span').length == 0) {
            add_history_step('new point');
            var clone = span_create_temp().clone();
            clone.unbind();
            clone.addClass('new_create');
            block_part_set_events(clone);
            clone.attr('aip-type', 'text_hesla');
            set_rule(clone);
            check_for_empty_block(clone);
        }
    }
    function check_for_empty_block(clone) {
        var start = '<start block="1-0-1-0" class="start_block start_end_notvisible ui-sortable-handle"></start>';
        var end = '<end block="1-0-1-0" class="end_block start_end_notvisible ui-sortable-handle"></end>';
        $(pageparts_div).find('end').remove();
        $(pageparts_div).find('start').remove();
        $(pageparts_div).prepend(end).prepend(start);
        clone.insertAfter($(pageparts_div).find('start'));
        set_el_to_freeserif(clone);
        refresh_all_info();
    }
    function highlight_selected() {
        $('.other_block_rep').removeClass('active_prev_block');
        $(pageparts_div).children().each(function(i, ol) {
            var el = $(this);
            if (el.is('span') && el.hasClass('selected_span')) {
                $('#arround_page').find("[list_num='" + el.attr('list_num') + "']").toggleClass('active_prev_block');
            }
        });
        if ($(pageparts_div).find('input').length > 0) {
            var el = cache.input_span_replace;
            $('#arround_page').find("[list_num='" + el.attr('list_num') + "']").toggleClass('active_prev_block');
        }
    }
    function remove_block_parts() {
        add_history_step('delete');
        setTimeout(function() {
            var next = $('span.selected_span').last().next();
            $('span.selected_span').remove();
            select_deleted_prev(next);
        }, 300);
    }
    function merge_block_parts(block_1, block_2) {
        add_history_step('merge part');
        var temp = block_2;
        temp.text(block_1.text() + block_2.text());
        block_1.remove();
        block_2.replaceWith(temp);
        first_merge_block_part = undefined;
        second_merge_block_part = undefined;
        disable_edit_tools();
    }

    function merge_selected_block_parts(e) {
        add_history_step('merge parts');
        var sers = $($(pageparts).children().find('.selected_span'));
        var first = sers.first().clone();
        first.text('');
        first.insertBefore(sers.first());
        block_part_set_events(first);
        sers.each(function() {
            first.text(first.text() + $(this).text());
            $(this).remove();
        });
    }
    function in_array(name) {
        for (var i in colors) {
            if (colors[i][0] == name) {
                return true;
            }
        }
        return false;
    }
    function get_color(name) {
        for (var i in colors) {
            if (colors[i][0] == name) {
                return colors[i][1];
            }
        }
        return false;
    }

    function remove_block_part(part) {
        select_deleted_prev(part);
        add_history_step('remove part');
        part.remove();
    }

    var got = {};

    function get_end_start_num(el) {
        got.start = false;
        got.end = false;
        var val_es;
        el.prevAll().each(function(i, el) {
            if ($(el).is('end') || $(el).is('start')) {
                if (got.end == false && got.start == false) {
                    got[$(el).get(0).tagName.toLowerCase()] = true;
                    val_es = $(el).attr('block');
                }
            }
        });
        if (got.start) {
            val_es = check_start_end_duplicity(end_start_add_level(val_es));
        } else {
            val_es = check_start_end_duplicity(end_start_add_one(val_es));
        }
        var start = start_block(val_es).clone();
        var end = end_block(val_es).clone();
        start.insertBefore(el);
        end.insertBefore(el)
        start.css('background', block_colors[start.attr('block').split('-').length]);
        end.css('background', block_colors[end.attr('block').split('-').length]);
        start.attr('aip-block-name', '');
        end.attr('aip-block-name', '');
        block_set_events(start);
        block_set_events(end);
        set_sortable_pageparts();
        prepare_select_block_type_dialog();
    }
    function end_start_add_one(num) {
        var temp_val_es = num.split('-');
        temp_val_es[num.split('-').length - 1] = parseInt(num.split('-')[num.split('-').length - 1]) + 1;
        return temp_val_es.join('-');
    }
    function check_start_end_duplicity(num) {
        got.result = false;
        var res = num;
        var update = 0;
        while (!got.result) {
            $(pageparts).children().children().each(function(i, el) {
                if ($(el).is('end') || $(el).is('start')) {
                    if ($(el).attr('block') == res) {
                        res = end_start_add_one(res);
                        update++;
                    }
                }
            });
            if (update == 0) {
                return res;
            } else {
                update = 0;
            }
        }
    }
    function check_start_end_duplicity_array_short(num) {
        got.result_ = false;
        var res = num;
        var update = 0;
        while (!got.result_) {
            var oj = cache.aip_block_store;
            for (var l in oj) {
                if (oj[l] == res) {
                    res = end_start_add_one(res);
                    update++;
                }
            }
            if (update == 0) {
                return res;
            } else {
                update = 0;
            }
        }
    }
    function end_start_add_level(num) {
        var temp_val_es = num.split('-');
        temp_val_es.push('1');
        return temp_val_es.join('-');
    }
    function send_to_control(sel) {
        cache.select_block_for_rec = sel;
        var html = "";
        if (sel == "all") {
            html = $(pageparts);
        } else {
            html = $($('start[block="' + sel + '"]').nextUntil($('end[block="' + sel + '"]')));
        }
        console.log(html);
        replace_resposnse(html);
    }
    function replace_response(html) {
        var sel = cache.select_block_for_rec;
        var remove = $($('start[block="' + sel + '"]').nextUntil($('end[block="' + sel + '"]')));
        remove.replaceWith(html);
        change_block_view();
    }
